/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.proxy.internal.types;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.proxy.internal.types.Flyweight;
import org.reaktivity.nukleus.proxy.internal.types.ProxyIdentityFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyInfoType;
import org.reaktivity.nukleus.proxy.internal.types.ProxyInfoTypeFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxySecureInfoFW;
import org.reaktivity.nukleus.proxy.internal.types.String16FW;
import org.reaktivity.nukleus.proxy.internal.types.String8FW;
import org.reaktivity.nukleus.proxy.internal.types.StringFW;

public final class ProxyInfoFW
extends Flyweight {
    public static final ProxyInfoType KIND_ALPN = ProxyInfoType.ALPN;
    public static final ProxyInfoType KIND_AUTHORITY = ProxyInfoType.AUTHORITY;
    public static final ProxyInfoType KIND_IDENTITY = ProxyInfoType.IDENTITY;
    public static final ProxyInfoType KIND_NAMESPACE = ProxyInfoType.NAMESPACE;
    public static final ProxyInfoType KIND_SECURE = ProxyInfoType.SECURE;
    private final ProxyInfoTypeFW proxyInfoTypeRO = new ProxyInfoTypeFW();
    private String8FW alpnRO;
    private String16FW authorityRO;
    private ProxyIdentityFW identityRO;
    private String16FW namespaceRO;
    private ProxySecureInfoFW secureRO;

    public ProxyInfoType kind() {
        return this.proxyInfoTypeRO.get();
    }

    public String8FW alpn() {
        if (this.alpnRO == null) {
            this.alpnRO = new String8FW();
        }
        return this.alpnRO;
    }

    public String16FW authority() {
        if (this.authorityRO == null) {
            this.authorityRO = new String16FW();
        }
        return this.authorityRO;
    }

    public ProxyIdentityFW identity() {
        if (this.identityRO == null) {
            this.identityRO = new ProxyIdentityFW();
        }
        return this.identityRO;
    }

    public String16FW namespace() {
        if (this.namespaceRO == null) {
            this.namespaceRO = new String16FW();
        }
        return this.namespaceRO;
    }

    public ProxySecureInfoFW secure() {
        if (this.secureRO == null) {
            this.secureRO = new ProxySecureInfoFW();
        }
        return this.secureRO;
    }

    @Override
    public ProxyInfoFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        ProxyInfoTypeFW proxyInfoType = this.proxyInfoTypeRO.tryWrap(buffer, offset, maxLimit);
        if (proxyInfoType == null) {
            return null;
        }
        switch (this.kind()) {
            case ALPN: {
                if (this.alpn().tryWrap(buffer, offset + proxyInfoType.sizeof(), maxLimit) != null) break;
                return null;
            }
            case AUTHORITY: {
                if (this.authority().tryWrap(buffer, offset + proxyInfoType.sizeof(), maxLimit) != null) break;
                return null;
            }
            case IDENTITY: {
                if (this.identity().tryWrap(buffer, offset + proxyInfoType.sizeof(), maxLimit) != null) break;
                return null;
            }
            case NAMESPACE: {
                if (this.namespace().tryWrap(buffer, offset + proxyInfoType.sizeof(), maxLimit) != null) break;
                return null;
            }
            case SECURE: {
                if (this.secure().tryWrap(buffer, offset + proxyInfoType.sizeof(), maxLimit) != null) break;
                return null;
            }
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public ProxyInfoFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        ProxyInfoTypeFW proxyInfoType = this.proxyInfoTypeRO.wrap(buffer, offset, maxLimit);
        switch (this.kind()) {
            case ALPN: {
                this.alpn().wrap(buffer, offset + proxyInfoType.sizeof(), maxLimit);
                break;
            }
            case AUTHORITY: {
                this.authority().wrap(buffer, offset + proxyInfoType.sizeof(), maxLimit);
                break;
            }
            case IDENTITY: {
                this.identity().wrap(buffer, offset + proxyInfoType.sizeof(), maxLimit);
                break;
            }
            case NAMESPACE: {
                this.namespace().wrap(buffer, offset + proxyInfoType.sizeof(), maxLimit);
                break;
            }
            case SECURE: {
                this.secure().wrap(buffer, offset + proxyInfoType.sizeof(), maxLimit);
                break;
            }
        }
        ProxyInfoFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        switch (this.kind()) {
            case ALPN: {
                return this.alpn().limit();
            }
            case AUTHORITY: {
                return this.authority().limit();
            }
            case IDENTITY: {
                return this.identity().limit();
            }
            case NAMESPACE: {
                return this.namespace().limit();
            }
            case SECURE: {
                return this.secure().limit();
            }
        }
        return this.offset();
    }

    public String toString() {
        switch (this.kind()) {
            case ALPN: {
                return String.format("PROXY_INFO [alpn=%s]", this.alpn());
            }
            case AUTHORITY: {
                return String.format("PROXY_INFO [authority=%s]", this.authority().asString());
            }
            case IDENTITY: {
                return String.format("PROXY_INFO [identity=%s]", this.identity());
            }
            case NAMESPACE: {
                return String.format("PROXY_INFO [namespace=%s]", this.namespace().asString());
            }
            case SECURE: {
                return String.format("PROXY_INFO [secure=%s]", this.secure());
            }
        }
        return String.format("PROXY_INFO [unknown]", new Object[0]);
    }

    public static final class Builder
    extends Flyweight.Builder<ProxyInfoFW> {
        private final ProxyInfoTypeFW.Builder proxyInfoTypeRW = new ProxyInfoTypeFW.Builder();
        private String8FW.Builder alpnRW;
        private String16FW.Builder authorityRW;
        private ProxyIdentityFW.Builder identityRW;
        private String16FW.Builder namespaceRW;
        private ProxySecureInfoFW.Builder secureRW;

        public Builder() {
            super(new ProxyInfoFW());
        }

        public Builder kind(ProxyInfoType value) {
            this.proxyInfoTypeRW.wrap(this.buffer(), this.offset(), this.maxLimit());
            this.proxyInfoTypeRW.set(value);
            this.limit(this.proxyInfoTypeRW.build().limit());
            return this;
        }

        private String8FW.Builder alpn() {
            if (this.alpnRW == null) {
                this.alpnRW = new String8FW.Builder();
            }
            return this.alpnRW.wrap(this.buffer(), this.offset() + this.proxyInfoTypeRW.sizeof(), this.maxLimit());
        }

        public Builder alpn(String value) {
            this.kind(KIND_ALPN);
            String8FW.Builder alpn = this.alpn();
            alpn.set(value, StandardCharsets.UTF_8);
            this.limit(alpn.build().limit());
            return this;
        }

        public Builder alpn(StringFW value) {
            this.kind(KIND_ALPN);
            String8FW.Builder alpn = this.alpn();
            alpn.set(value);
            this.limit(alpn.build().limit());
            return this;
        }

        private String16FW.Builder authority() {
            if (this.authorityRW == null) {
                this.authorityRW = new String16FW.Builder();
            }
            return this.authorityRW.wrap(this.buffer(), this.offset() + this.proxyInfoTypeRW.sizeof(), this.maxLimit());
        }

        public Builder authority(String value) {
            this.kind(KIND_AUTHORITY);
            String16FW.Builder authority = this.authority();
            authority.set(value, StandardCharsets.UTF_8);
            this.limit(authority.build().limit());
            return this;
        }

        public Builder authority(StringFW value) {
            this.kind(KIND_AUTHORITY);
            String16FW.Builder authority = this.authority();
            authority.set(value);
            this.limit(authority.build().limit());
            return this;
        }

        private ProxyIdentityFW.Builder identity() {
            if (this.identityRW == null) {
                this.identityRW = new ProxyIdentityFW.Builder();
            }
            return this.identityRW.wrap(this.buffer(), this.offset() + this.proxyInfoTypeRW.sizeof(), this.maxLimit());
        }

        public Builder identity(Consumer<ProxyIdentityFW.Builder> mutator) {
            this.kind(KIND_IDENTITY);
            ProxyIdentityFW.Builder identity = this.identity();
            mutator.accept(identity);
            this.limit(identity.build().limit());
            return this;
        }

        public Builder identity(ProxyIdentityFW field) {
            this.kind(KIND_IDENTITY);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            return this;
        }

        private String16FW.Builder namespace() {
            if (this.namespaceRW == null) {
                this.namespaceRW = new String16FW.Builder();
            }
            return this.namespaceRW.wrap(this.buffer(), this.offset() + this.proxyInfoTypeRW.sizeof(), this.maxLimit());
        }

        public Builder namespace(String value) {
            this.kind(KIND_NAMESPACE);
            String16FW.Builder namespace = this.namespace();
            namespace.set(value, StandardCharsets.UTF_8);
            this.limit(namespace.build().limit());
            return this;
        }

        public Builder namespace(StringFW value) {
            this.kind(KIND_NAMESPACE);
            String16FW.Builder namespace = this.namespace();
            namespace.set(value);
            this.limit(namespace.build().limit());
            return this;
        }

        private ProxySecureInfoFW.Builder secure() {
            if (this.secureRW == null) {
                this.secureRW = new ProxySecureInfoFW.Builder();
            }
            return this.secureRW.wrap(this.buffer(), this.offset() + this.proxyInfoTypeRW.sizeof(), this.maxLimit());
        }

        public Builder secure(Consumer<ProxySecureInfoFW.Builder> mutator) {
            this.kind(KIND_SECURE);
            ProxySecureInfoFW.Builder secure = this.secure();
            mutator.accept(secure);
            this.limit(((ProxySecureInfoFW)secure.build()).limit());
            return this;
        }

        public Builder secure(ProxySecureInfoFW field) {
            this.kind(KIND_SECURE);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            return this;
        }
    }
}

