/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.proxy.internal.types;

import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.proxy.internal.types.Flyweight;
import org.reaktivity.nukleus.proxy.internal.types.ProxySecureInfoType;
import org.reaktivity.nukleus.proxy.internal.types.ProxySecureInfoTypeFW;
import org.reaktivity.nukleus.proxy.internal.types.String16FW;
import org.reaktivity.nukleus.proxy.internal.types.String8FW;
import org.reaktivity.nukleus.proxy.internal.types.StringFW;

public final class ProxySecureInfoFW
extends Flyweight {
    public static final ProxySecureInfoType KIND_PROTOCOL = ProxySecureInfoType.PROTOCOL;
    public static final ProxySecureInfoType KIND_NAME = ProxySecureInfoType.NAME;
    public static final ProxySecureInfoType KIND_CIPHER = ProxySecureInfoType.CIPHER;
    public static final ProxySecureInfoType KIND_SIGNATURE = ProxySecureInfoType.SIGNATURE;
    public static final ProxySecureInfoType KIND_KEY = ProxySecureInfoType.KEY;
    private final ProxySecureInfoTypeFW proxySecureInfoTypeRO = new ProxySecureInfoTypeFW();
    private String8FW protocolRO;
    private String16FW nameRO;
    private String8FW cipherRO;
    private String8FW signatureRO;
    private String8FW keyRO;

    public ProxySecureInfoType kind() {
        return this.proxySecureInfoTypeRO.get();
    }

    public String8FW protocol() {
        if (this.protocolRO == null) {
            this.protocolRO = new String8FW();
        }
        return this.protocolRO;
    }

    public String16FW name() {
        if (this.nameRO == null) {
            this.nameRO = new String16FW();
        }
        return this.nameRO;
    }

    public String8FW cipher() {
        if (this.cipherRO == null) {
            this.cipherRO = new String8FW();
        }
        return this.cipherRO;
    }

    public String8FW signature() {
        if (this.signatureRO == null) {
            this.signatureRO = new String8FW();
        }
        return this.signatureRO;
    }

    public String8FW key() {
        if (this.keyRO == null) {
            this.keyRO = new String8FW();
        }
        return this.keyRO;
    }

    @Override
    public ProxySecureInfoFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        ProxySecureInfoTypeFW proxySecureInfoType = this.proxySecureInfoTypeRO.tryWrap(buffer, offset, maxLimit);
        if (proxySecureInfoType == null) {
            return null;
        }
        switch (this.kind()) {
            case PROTOCOL: {
                if (this.protocol().tryWrap(buffer, offset + proxySecureInfoType.sizeof(), maxLimit) != null) break;
                return null;
            }
            case NAME: {
                if (this.name().tryWrap(buffer, offset + proxySecureInfoType.sizeof(), maxLimit) != null) break;
                return null;
            }
            case CIPHER: {
                if (this.cipher().tryWrap(buffer, offset + proxySecureInfoType.sizeof(), maxLimit) != null) break;
                return null;
            }
            case SIGNATURE: {
                if (this.signature().tryWrap(buffer, offset + proxySecureInfoType.sizeof(), maxLimit) != null) break;
                return null;
            }
            case KEY: {
                if (this.key().tryWrap(buffer, offset + proxySecureInfoType.sizeof(), maxLimit) != null) break;
                return null;
            }
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public ProxySecureInfoFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        ProxySecureInfoTypeFW proxySecureInfoType = this.proxySecureInfoTypeRO.wrap(buffer, offset, maxLimit);
        switch (this.kind()) {
            case PROTOCOL: {
                this.protocol().wrap(buffer, offset + proxySecureInfoType.sizeof(), maxLimit);
                break;
            }
            case NAME: {
                this.name().wrap(buffer, offset + proxySecureInfoType.sizeof(), maxLimit);
                break;
            }
            case CIPHER: {
                this.cipher().wrap(buffer, offset + proxySecureInfoType.sizeof(), maxLimit);
                break;
            }
            case SIGNATURE: {
                this.signature().wrap(buffer, offset + proxySecureInfoType.sizeof(), maxLimit);
                break;
            }
            case KEY: {
                this.key().wrap(buffer, offset + proxySecureInfoType.sizeof(), maxLimit);
                break;
            }
        }
        ProxySecureInfoFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        switch (this.kind()) {
            case PROTOCOL: {
                return this.protocol().limit();
            }
            case NAME: {
                return this.name().limit();
            }
            case CIPHER: {
                return this.cipher().limit();
            }
            case SIGNATURE: {
                return this.signature().limit();
            }
            case KEY: {
                return this.key().limit();
            }
        }
        return this.offset();
    }

    public String toString() {
        switch (this.kind()) {
            case PROTOCOL: {
                return String.format("PROXY_SECURE_INFO [protocol=%s]", this.protocol());
            }
            case NAME: {
                return String.format("PROXY_SECURE_INFO [name=%s]", this.name().asString());
            }
            case CIPHER: {
                return String.format("PROXY_SECURE_INFO [cipher=%s]", this.cipher());
            }
            case SIGNATURE: {
                return String.format("PROXY_SECURE_INFO [signature=%s]", this.signature());
            }
            case KEY: {
                return String.format("PROXY_SECURE_INFO [key=%s]", this.key());
            }
        }
        return String.format("PROXY_SECURE_INFO [unknown]", new Object[0]);
    }

    public static final class Builder
    extends Flyweight.Builder<ProxySecureInfoFW> {
        private final ProxySecureInfoTypeFW.Builder proxySecureInfoTypeRW = new ProxySecureInfoTypeFW.Builder();
        private String8FW.Builder protocolRW;
        private String16FW.Builder nameRW;
        private String8FW.Builder cipherRW;
        private String8FW.Builder signatureRW;
        private String8FW.Builder keyRW;

        public Builder() {
            super(new ProxySecureInfoFW());
        }

        public Builder kind(ProxySecureInfoType value) {
            this.proxySecureInfoTypeRW.wrap(this.buffer(), this.offset(), this.maxLimit());
            this.proxySecureInfoTypeRW.set(value);
            this.limit(this.proxySecureInfoTypeRW.build().limit());
            return this;
        }

        private String8FW.Builder protocol() {
            if (this.protocolRW == null) {
                this.protocolRW = new String8FW.Builder();
            }
            return this.protocolRW.wrap(this.buffer(), this.offset() + this.proxySecureInfoTypeRW.sizeof(), this.maxLimit());
        }

        public Builder protocol(String value) {
            this.kind(KIND_PROTOCOL);
            String8FW.Builder protocol = this.protocol();
            protocol.set(value, StandardCharsets.UTF_8);
            this.limit(protocol.build().limit());
            return this;
        }

        public Builder protocol(StringFW value) {
            this.kind(KIND_PROTOCOL);
            String8FW.Builder protocol = this.protocol();
            protocol.set(value);
            this.limit(protocol.build().limit());
            return this;
        }

        private String16FW.Builder name() {
            if (this.nameRW == null) {
                this.nameRW = new String16FW.Builder();
            }
            return this.nameRW.wrap(this.buffer(), this.offset() + this.proxySecureInfoTypeRW.sizeof(), this.maxLimit());
        }

        public Builder name(String value) {
            this.kind(KIND_NAME);
            String16FW.Builder name = this.name();
            name.set(value, StandardCharsets.UTF_8);
            this.limit(name.build().limit());
            return this;
        }

        public Builder name(StringFW value) {
            this.kind(KIND_NAME);
            String16FW.Builder name = this.name();
            name.set(value);
            this.limit(name.build().limit());
            return this;
        }

        private String8FW.Builder cipher() {
            if (this.cipherRW == null) {
                this.cipherRW = new String8FW.Builder();
            }
            return this.cipherRW.wrap(this.buffer(), this.offset() + this.proxySecureInfoTypeRW.sizeof(), this.maxLimit());
        }

        public Builder cipher(String value) {
            this.kind(KIND_CIPHER);
            String8FW.Builder cipher = this.cipher();
            cipher.set(value, StandardCharsets.UTF_8);
            this.limit(cipher.build().limit());
            return this;
        }

        public Builder cipher(StringFW value) {
            this.kind(KIND_CIPHER);
            String8FW.Builder cipher = this.cipher();
            cipher.set(value);
            this.limit(cipher.build().limit());
            return this;
        }

        private String8FW.Builder signature() {
            if (this.signatureRW == null) {
                this.signatureRW = new String8FW.Builder();
            }
            return this.signatureRW.wrap(this.buffer(), this.offset() + this.proxySecureInfoTypeRW.sizeof(), this.maxLimit());
        }

        public Builder signature(String value) {
            this.kind(KIND_SIGNATURE);
            String8FW.Builder signature = this.signature();
            signature.set(value, StandardCharsets.UTF_8);
            this.limit(signature.build().limit());
            return this;
        }

        public Builder signature(StringFW value) {
            this.kind(KIND_SIGNATURE);
            String8FW.Builder signature = this.signature();
            signature.set(value);
            this.limit(signature.build().limit());
            return this;
        }

        private String8FW.Builder key() {
            if (this.keyRW == null) {
                this.keyRW = new String8FW.Builder();
            }
            return this.keyRW.wrap(this.buffer(), this.offset() + this.proxySecureInfoTypeRW.sizeof(), this.maxLimit());
        }

        public Builder key(String value) {
            this.kind(KIND_KEY);
            String8FW.Builder key = this.key();
            key.set(value, StandardCharsets.UTF_8);
            this.limit(key.build().limit());
            return this;
        }

        public Builder key(StringFW value) {
            this.kind(KIND_KEY);
            String8FW.Builder key = this.key();
            key.set(value);
            this.limit(key.build().limit());
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            return this;
        }
    }
}

