/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.proxy.internal.types.codec;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.proxy.internal.types.ArrayFW;
import org.reaktivity.nukleus.proxy.internal.types.Flyweight;
import org.reaktivity.nukleus.proxy.internal.types.OctetsFW;

public final class ProxyAddrUnixFW
extends Flyweight {
    public static final int FIELD_OFFSET_SOURCE = 0;
    public static final int FIELD_OFFSET_DESTINATION = 0;
    private final OctetsFW sourceRO = new OctetsFW();
    private final OctetsFW destinationRO = new OctetsFW();

    public OctetsFW source() {
        return this.sourceRO;
    }

    public OctetsFW destination() {
        return this.destinationRO;
    }

    @Override
    public ProxyAddrUnixFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.sourceRO.wrap(buffer, offset + 0, offset + 0 + 108);
        this.destinationRO.wrap(buffer, this.sourceRO.limit() + 0, this.sourceRO.limit() + 0 + 108);
        ProxyAddrUnixFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public ProxyAddrUnixFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        int limit = offset + 0 + 108;
        if (limit > maxLimit || null == this.sourceRO.tryWrap(buffer, offset + 0, limit)) {
            return null;
        }
        limit = this.sourceRO.limit() + 0 + 108;
        if (limit > maxLimit || null == this.destinationRO.tryWrap(buffer, this.sourceRO.limit() + 0, limit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.destinationRO.limit();
    }

    public String toString() {
        return String.format("PROXY_ADDR_UNIX [source=%s, destination=%s]", this.source(), this.destination());
    }

    public static final class Builder
    extends Flyweight.Builder<ProxyAddrUnixFW> {
        private static final int INDEX_SOURCE = 0;
        private static final int INDEX_DESTINATION = 1;
        private static final int FIELD_COUNT = 2;
        private final OctetsFW.Builder sourceRW = new OctetsFW.Builder();
        private final OctetsFW.Builder destinationRW = new OctetsFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new ProxyAddrUnixFW());
        }

        private OctetsFW.Builder source() {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 108;
            ProxyAddrUnixFW.checkLimit(newLimit, this.maxLimit());
            return this.sourceRW.wrap(this.buffer(), this.limit(), newLimit);
        }

        public Builder source(OctetsFW value) {
            OctetsFW.Builder sourceRW = this.source();
            sourceRW.set(value);
            int expectedLimit = sourceRW.maxLimit();
            int actualLimit = ((OctetsFW)sourceRW.build()).limit();
            if (actualLimit != expectedLimit) {
                throw new IllegalStateException(String.format("%d instead of %d bytes have been set for field \"source\"", actualLimit - this.limit(), expectedLimit - this.limit()));
            }
            this.limit(sourceRW.maxLimit());
            this.lastFieldSet = 0;
            return this;
        }

        public Builder source(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder sourceRW = this.source();
            mutator.accept(sourceRW);
            int expectedLimit = sourceRW.maxLimit();
            int actualLimit = ((OctetsFW)sourceRW.build()).limit();
            if (actualLimit != expectedLimit) {
                throw new IllegalStateException(String.format("%d instead of %d bytes have been set for field \"source\"", actualLimit - this.limit(), expectedLimit - this.limit()));
            }
            this.limit(sourceRW.maxLimit());
            this.lastFieldSet = 0;
            return this;
        }

        public Builder source(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder sourceRW = this.source();
            int fieldSize = sourceRW.maxLimit() - this.limit();
            if (length != fieldSize) {
                throw new IllegalArgumentException(String.format("Invalid length %d for field \"source\", expected %d", length, fieldSize));
            }
            sourceRW.set(buffer, offset, length);
            this.limit(((OctetsFW)sourceRW.build()).limit());
            this.lastFieldSet = 0;
            return this;
        }

        private OctetsFW.Builder destination() {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 108;
            ProxyAddrUnixFW.checkLimit(newLimit, this.maxLimit());
            return this.destinationRW.wrap(this.buffer(), this.limit(), newLimit);
        }

        public Builder destination(OctetsFW value) {
            OctetsFW.Builder destinationRW = this.destination();
            destinationRW.set(value);
            int expectedLimit = destinationRW.maxLimit();
            int actualLimit = ((OctetsFW)destinationRW.build()).limit();
            if (actualLimit != expectedLimit) {
                throw new IllegalStateException(String.format("%d instead of %d bytes have been set for field \"destination\"", actualLimit - this.limit(), expectedLimit - this.limit()));
            }
            this.limit(destinationRW.maxLimit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder destination(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder destinationRW = this.destination();
            mutator.accept(destinationRW);
            int expectedLimit = destinationRW.maxLimit();
            int actualLimit = ((OctetsFW)destinationRW.build()).limit();
            if (actualLimit != expectedLimit) {
                throw new IllegalStateException(String.format("%d instead of %d bytes have been set for field \"destination\"", actualLimit - this.limit(), expectedLimit - this.limit()));
            }
            this.limit(destinationRW.maxLimit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder destination(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder destinationRW = this.destination();
            int fieldSize = destinationRW.maxLimit() - this.limit();
            if (length != fieldSize) {
                throw new IllegalArgumentException(String.format("Invalid length %d for field \"destination\", expected %d", length, fieldSize));
            }
            destinationRW.set(buffer, offset, length);
            this.limit(((OctetsFW)destinationRW.build()).limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public ProxyAddrUnixFW build() {
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (ProxyAddrUnixFW)super.build();
        }
    }
}

