/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.proxy.internal.types.codec;

import java.nio.ByteOrder;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.proxy.internal.types.ArrayFW;
import org.reaktivity.nukleus.proxy.internal.types.Flyweight;
import org.reaktivity.nukleus.proxy.internal.types.OctetsFW;

public final class ProxyTlvFW
extends Flyweight {
    public static final int FIELD_OFFSET_TYPE = 0;
    private static final int FIELD_SIZE_TYPE = 1;
    public static final int FIELD_OFFSET_LENGTH = 1;
    private static final int FIELD_SIZE_LENGTH = 2;
    public static final int FIELD_OFFSET_VALUE = 3;
    private final OctetsFW valueRO = new OctetsFW();

    public int type() {
        return this.buffer().getByte(this.offset() + 0) & 0xFF;
    }

    public int length() {
        return this.buffer().getShort(this.offset() + 1, ByteOrder.BIG_ENDIAN) & 0xFFFF;
    }

    public OctetsFW value() {
        return this.valueRO;
    }

    @Override
    public ProxyTlvFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.valueRO.wrap(buffer, offset + 3, offset + 3 + this.length());
        ProxyTlvFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public ProxyTlvFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        int limit = offset + 3 + this.length();
        if (limit > maxLimit || null == this.valueRO.tryWrap(buffer, offset + 3, limit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.valueRO.limit();
    }

    public String toString() {
        return String.format("PROXY_TLV [type=%d, length=%d, value=%s]", this.type(), this.length(), this.value());
    }

    public static final class Builder
    extends Flyweight.Builder<ProxyTlvFW> {
        private static final int INDEX_TYPE = 0;
        public static final int DEFAULT_LENGTH = 0;
        private static final int INDEX_VALUE = 1;
        private static final int FIELD_COUNT = 2;
        private int dynamicOffsetLength;
        private final OctetsFW.Builder valueRW = new OctetsFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new ProxyTlvFW());
        }

        public Builder type(int value) {
            if (value < 0) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"type\"", value));
            }
            if (value > 255) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"type\"", value));
            }
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 1;
            ProxyTlvFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putByte(this.limit(), (byte)(value & 0xFF));
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        private Builder length(int value) {
            if (value < 0) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"length\"", value));
            }
            if (value > 65535) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"length\"", value));
            }
            int newLimit = this.limit() + 2;
            ProxyTlvFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putShort(this.limit(), (short)(value & 0xFFFF), ByteOrder.BIG_ENDIAN);
            this.dynamicOffsetLength = this.limit();
            this.limit(newLimit);
            return this;
        }

        private OctetsFW.Builder value() {
            this.length(0);
            assert (this.lastFieldSet == 0);
            return this.valueRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder value(OctetsFW value) {
            OctetsFW.Builder valueRW = this.value();
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null for field \"value\" that does not default to null");
            }
            valueRW.set(value);
            int newLimit = ((OctetsFW)valueRW.build()).limit();
            int size$ = newLimit - this.limit();
            this.limit(this.dynamicOffsetLength);
            this.length(size$);
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder value(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder valueRW = this.value();
            mutator.accept(valueRW);
            int newLimit = ((OctetsFW)valueRW.build()).limit();
            int size$ = newLimit - this.limit();
            this.limit(this.dynamicOffsetLength);
            this.length(size$);
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder value(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder valueRW = this.value();
            valueRW.set(buffer, offset, length);
            int newLimit = ((OctetsFW)valueRW.build()).limit();
            int size$ = newLimit - this.limit();
            this.limit(this.dynamicOffsetLength);
            this.length(size$);
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.dynamicOffsetLength = -1;
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.dynamicOffsetLength = -1;
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public ProxyTlvFW build() {
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (ProxyTlvFW)super.build();
        }
    }
}

