/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.proxy.internal.types.codec;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.proxy.internal.types.ArrayFW;
import org.reaktivity.nukleus.proxy.internal.types.Flyweight;

public final class ProxyTlvSslFW
extends Flyweight {
    public static final int FIELD_OFFSET_CLIENT = 0;
    private static final int FIELD_SIZE_CLIENT = 1;
    public static final int FIELD_OFFSET_VERIFY = 1;
    private static final int FIELD_SIZE_VERIFY = 4;

    public int client() {
        return this.buffer().getByte(this.offset() + 0) & 0xFF;
    }

    public long verify() {
        return (long)this.buffer().getInt(this.offset() + 1, ByteOrder.BIG_ENDIAN) & 0xFFFFFFFFL;
    }

    @Override
    public ProxyTlvSslFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        ProxyTlvSslFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public ProxyTlvSslFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.offset() + 1 + 4;
    }

    public String toString() {
        return String.format("PROXY_TLV_SSL [client=%d, verify=%d]", this.client(), this.verify());
    }

    public static final class Builder
    extends Flyweight.Builder<ProxyTlvSslFW> {
        private static final int INDEX_CLIENT = 0;
        private static final int INDEX_VERIFY = 1;
        private static final int FIELD_COUNT = 2;
        private int lastFieldSet = -1;

        public Builder() {
            super(new ProxyTlvSslFW());
        }

        public Builder client(int value) {
            if (value < 0) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"client\"", value));
            }
            if (value > 255) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"client\"", value));
            }
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 1;
            ProxyTlvSslFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putByte(this.limit(), (byte)(value & 0xFF));
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder verify(long value) {
            if (value < 0L) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"verify\"", value));
            }
            if (value > 0xFFFFFFFFL) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"verify\"", value));
            }
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 4;
            ProxyTlvSslFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), (int)(value & 0xFFFFFFFFL), ByteOrder.BIG_ENDIAN);
            this.lastFieldSet = 1;
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public ProxyTlvSslFW build() {
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (ProxyTlvSslFW)super.build();
        }
    }
}

