/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.proxy.internal.types.control;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.proxy.internal.types.Array32FW;
import org.reaktivity.nukleus.proxy.internal.types.ArrayFW;
import org.reaktivity.nukleus.proxy.internal.types.Flyweight;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressMatchFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyInfoFW;

public final class ProxyRouteExFW
extends Flyweight {
    public static final int FIELD_OFFSET_ADDRESS = 0;
    public static final int FIELD_OFFSET_INFOS = 0;
    private final ProxyAddressMatchFW addressRO = new ProxyAddressMatchFW();
    private final Array32FW<ProxyInfoFW> infosRO = new Array32FW<ProxyInfoFW>(new ProxyInfoFW());

    public ProxyAddressMatchFW address() {
        return this.addressRO;
    }

    public Array32FW<ProxyInfoFW> infos() {
        return this.infosRO;
    }

    @Override
    public ProxyRouteExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.addressRO.wrap(buffer, offset + 0, maxLimit);
        this.infosRO.wrap(buffer, this.addressRO.limit() + 0, maxLimit);
        ProxyRouteExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public ProxyRouteExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.addressRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        if (null == this.infosRO.tryWrap(buffer, this.addressRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.infosRO.limit();
    }

    public String toString() {
        return String.format("PROXY_ROUTE_EX [address=%s, infos=%s]", this.address(), this.infos());
    }

    public static final class Builder
    extends Flyweight.Builder<ProxyRouteExFW> {
        private static final int INDEX_ADDRESS = 0;
        private static final int INDEX_INFOS = 1;
        private static final int FIELD_COUNT = 2;
        private final ProxyAddressMatchFW.Builder addressRW = new ProxyAddressMatchFW.Builder();
        private final Array32FW.Builder<ProxyInfoFW.Builder, ProxyInfoFW> infosRW = new Array32FW.Builder<ProxyInfoFW.Builder, ProxyInfoFW>(new ProxyInfoFW.Builder(), new ProxyInfoFW());
        private int lastFieldSet = -1;

        public Builder() {
            super(new ProxyRouteExFW());
        }

        public Builder address(Consumer<ProxyAddressMatchFW.Builder> mutator) {
            assert (this.lastFieldSet == -1);
            ProxyAddressMatchFW.Builder addressRW = this.addressRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(addressRW);
            this.limit(((ProxyAddressMatchFW)addressRW.build()).limit());
            this.lastFieldSet = 0;
            return this;
        }

        public Builder address(ProxyAddressMatchFW field) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + field.sizeof();
            ProxyRouteExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        public Builder infos(Consumer<Array32FW.Builder<ProxyInfoFW.Builder, ProxyInfoFW>> mutator) {
            if (this.lastFieldSet < 0) {
                this.address((ProxyAddressMatchFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 0);
            Flyweight.Builder infosRW = this.infosRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept((Array32FW.Builder<ProxyInfoFW.Builder, ProxyInfoFW>)infosRW);
            this.limit(((Array32FW)((Array32FW.Builder)infosRW).build()).limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder infos(Array32FW<ProxyInfoFW> field) {
            if (this.lastFieldSet < 0) {
                this.address((ProxyAddressMatchFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + field.sizeof();
            ProxyRouteExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder infosItem(Consumer<ProxyInfoFW.Builder> mutator) {
            if (this.lastFieldSet < 0) {
                this.address((ProxyAddressMatchFW.Builder b) -> {});
            }
            assert (this.lastFieldSet >= 0);
            if (this.lastFieldSet < 1) {
                this.infosRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            }
            this.infosRW.item((Consumer)mutator);
            this.limit(((Array32FW)this.infosRW.build()).limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public ProxyRouteExFW build() {
            if (this.lastFieldSet < 1) {
                this.infos((Array32FW.Builder<ProxyInfoFW.Builder, ProxyInfoFW> b) -> {});
            }
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (ProxyRouteExFW)super.build();
        }
    }
}

