/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.proxy.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.proxy.internal.types.Array32FW;
import org.reaktivity.nukleus.proxy.internal.types.ArrayFW;
import org.reaktivity.nukleus.proxy.internal.types.Flyweight;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyInfoFW;

public final class ProxyBeginExFW
extends Flyweight {
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_TYPE_ID = 4;
    public static final int FIELD_OFFSET_ADDRESS = 4;
    public static final int FIELD_OFFSET_INFOS = 0;
    private final ProxyAddressFW addressRO = new ProxyAddressFW();
    private final Array32FW<ProxyInfoFW> infosRO = new Array32FW<ProxyInfoFW>(new ProxyInfoFW());

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public ProxyAddressFW address() {
        return this.addressRO;
    }

    public Array32FW<ProxyInfoFW> infos() {
        return this.infosRO;
    }

    @Override
    public ProxyBeginExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.addressRO.wrap(buffer, offset + 4, maxLimit);
        this.infosRO.wrap(buffer, this.addressRO.limit() + 0, maxLimit);
        ProxyBeginExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public ProxyBeginExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.addressRO.tryWrap(buffer, offset + 4, maxLimit)) {
            return null;
        }
        if (null == this.infosRO.tryWrap(buffer, this.addressRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.infosRO.limit();
    }

    public String toString() {
        return String.format("PROXY_BEGIN_EX [typeId=%d, address=%s, infos=%s]", this.typeId(), this.address(), this.infos());
    }

    public static final class Builder
    extends Flyweight.Builder<ProxyBeginExFW> {
        private static final int INDEX_TYPE_ID = 0;
        private static final int INDEX_ADDRESS = 1;
        private static final int INDEX_INFOS = 2;
        private static final int FIELD_COUNT = 3;
        private final ProxyAddressFW.Builder addressRW = new ProxyAddressFW.Builder();
        private final Array32FW.Builder<ProxyInfoFW.Builder, ProxyInfoFW> infosRW = new Array32FW.Builder<ProxyInfoFW.Builder, ProxyInfoFW>(new ProxyInfoFW.Builder(), new ProxyInfoFW());
        private int lastFieldSet = -1;

        public Builder() {
            super(new ProxyBeginExFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            ProxyBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder address(Consumer<ProxyAddressFW.Builder> mutator) {
            assert (this.lastFieldSet == 0);
            ProxyAddressFW.Builder addressRW = this.addressRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(addressRW);
            this.limit(((ProxyAddressFW)addressRW.build()).limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder address(ProxyAddressFW field) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + field.sizeof();
            ProxyBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder infos(Consumer<Array32FW.Builder<ProxyInfoFW.Builder, ProxyInfoFW>> mutator) {
            if (this.lastFieldSet < 1) {
                this.address((ProxyAddressFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 1);
            Flyweight.Builder infosRW = this.infosRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept((Array32FW.Builder<ProxyInfoFW.Builder, ProxyInfoFW>)infosRW);
            this.limit(((Array32FW)((Array32FW.Builder)infosRW).build()).limit());
            this.lastFieldSet = 2;
            return this;
        }

        public Builder infos(Array32FW<ProxyInfoFW> field) {
            if (this.lastFieldSet < 1) {
                this.address((ProxyAddressFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 1);
            int newLimit = this.limit() + field.sizeof();
            ProxyBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 2;
            return this;
        }

        public Builder infosItem(Consumer<ProxyInfoFW.Builder> mutator) {
            if (this.lastFieldSet < 1) {
                this.address((ProxyAddressFW.Builder b) -> {});
            }
            assert (this.lastFieldSet >= 1);
            if (this.lastFieldSet < 2) {
                this.infosRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            }
            this.infosRW.item((Consumer)mutator);
            this.limit(((Array32FW)this.infosRW.build()).limit());
            this.lastFieldSet = 2;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public ProxyBeginExFW build() {
            if (this.lastFieldSet < 2) {
                this.infos((Array32FW.Builder<ProxyInfoFW.Builder, ProxyInfoFW> b) -> {});
            }
            assert (this.lastFieldSet == 2);
            this.lastFieldSet = -1;
            return (ProxyBeginExFW)super.build();
        }
    }
}

