// TODO: license
package org.reaktivity.nukleus.tls.internal.types;

import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class ExtensionFW extends Flyweight {
  public static final int FIELD_OFFSET_TYPE = 0;

  private static final int FIELD_SIZE_TYPE = BitUtil.SIZE_OF_SHORT;

  public short type() {
    return buffer().getShort(offset() + FIELD_OFFSET_TYPE);
  }

  @Override
  public ExtensionFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public ExtensionFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return offset() + FIELD_OFFSET_TYPE + FIELD_SIZE_TYPE;
  }

  @Override
  public String toString() {
    return String.format("EXTENSION [type=%d]", type());
  }

  public static final class Builder extends Flyweight.Builder<ExtensionFW> {
    private static final int INDEX_TYPE = 0;

    private static final int FIELD_COUNT = 1;

    private int lastFieldSet = -1;

    public Builder() {
      super(new ExtensionFW());
    }

    public Builder type(short value) {
      assert lastFieldSet == INDEX_TYPE - 1;
      int newLimit = limit() + FIELD_SIZE_TYPE;
      checkLimit(newLimit, maxLimit());
      buffer().putShort(limit(), value);
      lastFieldSet = INDEX_TYPE;
      limit(newLimit);
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      lastFieldSet = -1;
      super.wrap(buffer, offset, maxLimit);
      limit(offset);
      return this;
    }

    @Override
    public ExtensionFW build() {
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
