// TODO: license
package org.reaktivity.nukleus.tls.internal.types.state;

import java.util.function.Consumer;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.tls.internal.types.Flyweight;
import org.reaktivity.nukleus.tls.internal.types.ListFW;

public final class RouteTableFW extends Flyweight {
  public static final int FIELD_OFFSET_MODIFICATION_COUNT = 0;

  private static final int FIELD_SIZE_MODIFICATION_COUNT = BitUtil.SIZE_OF_INT;

  public static final int FIELD_OFFSET_ENTRIES = FIELD_OFFSET_MODIFICATION_COUNT + FIELD_SIZE_MODIFICATION_COUNT;

  private final ListFW<RouteEntryFW> entriesRO = new ListFW<RouteEntryFW>(new RouteEntryFW());

  public int modificationCount() {
    return buffer().getInt(offset() + FIELD_OFFSET_MODIFICATION_COUNT);
  }

  public ListFW<RouteEntryFW> entries() {
    return entriesRO;
  }

  @Override
  public RouteTableFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    entriesRO.wrap(buffer, offset + FIELD_OFFSET_ENTRIES, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public RouteTableFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    if (null == entriesRO.tryWrap(buffer, offset + FIELD_OFFSET_ENTRIES, maxLimit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return entriesRO.limit();
  }

  @Override
  public String toString() {
    return String.format("ROUTE_TABLE [modificationCount=%d, entries=%s]", modificationCount(), entries());
  }

  public static final class Builder extends Flyweight.Builder<RouteTableFW> {
    private static final int INDEX_MODIFICATION_COUNT = 0;

    private static final int INDEX_ENTRIES = 1;

    private static final int FIELD_COUNT = 2;

    private final ListFW.Builder<RouteEntryFW.Builder, RouteEntryFW> entriesRW = new ListFW.Builder<RouteEntryFW.Builder, RouteEntryFW>(new RouteEntryFW.Builder(), new RouteEntryFW());

    private int lastFieldSet = -1;

    public Builder() {
      super(new RouteTableFW());
    }

    public Builder modificationCount(int value) {
      assert lastFieldSet == INDEX_MODIFICATION_COUNT - 1;
      int newLimit = limit() + FIELD_SIZE_MODIFICATION_COUNT;
      checkLimit(newLimit, maxLimit());
      buffer().putInt(limit(), value);
      lastFieldSet = INDEX_MODIFICATION_COUNT;
      limit(newLimit);
      return this;
    }

    public Builder entries(Consumer<ListFW.Builder<RouteEntryFW.Builder, RouteEntryFW>> mutator) {
      assert lastFieldSet == INDEX_ENTRIES - 1;
      ListFW.Builder<RouteEntryFW.Builder, RouteEntryFW> entriesRW = this.entriesRW.wrap(buffer(), limit(), maxLimit());
      mutator.accept(entriesRW);
      limit(entriesRW.build().limit());
      lastFieldSet = INDEX_ENTRIES;
      return this;
    }

    public Builder entriesItem(Consumer<RouteEntryFW.Builder> mutator) {
      assert lastFieldSet >= INDEX_ENTRIES - 1;
      if (lastFieldSet < INDEX_ENTRIES) {
        entriesRW.wrap(buffer(), limit(), maxLimit());
      }
      entriesRW.item(mutator);
      limit(entriesRW.build().limit());
      lastFieldSet = INDEX_ENTRIES;
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      lastFieldSet = -1;
      super.wrap(buffer, offset, maxLimit);
      limit(offset);
      return this;
    }

    @Override
    public RouteTableFW build() {
      if (lastFieldSet < INDEX_ENTRIES) {
        entries(b -> { });
      }
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
