// TODO: license
package org.reaktivity.nukleus.tls.internal.types.stream;

import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.tls.internal.types.Flyweight;

public final class SignalFW extends Flyweight {
  public static final int FIELD_OFFSET_ROUTE_ID = 0;

  private static final int FIELD_SIZE_ROUTE_ID = BitUtil.SIZE_OF_LONG;

  public static final int FIELD_OFFSET_STREAM_ID = FIELD_OFFSET_ROUTE_ID + FIELD_SIZE_ROUTE_ID;

  private static final int FIELD_SIZE_STREAM_ID = BitUtil.SIZE_OF_LONG;

  public static final int FIELD_OFFSET_TIMESTAMP = FIELD_OFFSET_STREAM_ID + FIELD_SIZE_STREAM_ID;

  private static final int FIELD_SIZE_TIMESTAMP = BitUtil.SIZE_OF_LONG;

  public static final int FIELD_OFFSET_TRACE = FIELD_OFFSET_TIMESTAMP + FIELD_SIZE_TIMESTAMP;

  private static final int FIELD_SIZE_TRACE = BitUtil.SIZE_OF_LONG;

  public static final int FIELD_OFFSET_AUTHORIZATION = FIELD_OFFSET_TRACE + FIELD_SIZE_TRACE;

  private static final int FIELD_SIZE_AUTHORIZATION = BitUtil.SIZE_OF_LONG;

  public static final int FIELD_OFFSET_SIGNAL_ID = FIELD_OFFSET_AUTHORIZATION + FIELD_SIZE_AUTHORIZATION;

  private static final int FIELD_SIZE_SIGNAL_ID = BitUtil.SIZE_OF_LONG;

  public static final int TYPE_ID = 0x00000005;

  public long routeId() {
    return buffer().getLong(offset() + FIELD_OFFSET_ROUTE_ID);
  }

  public long streamId() {
    return buffer().getLong(offset() + FIELD_OFFSET_STREAM_ID);
  }

  public long timestamp() {
    return buffer().getLong(offset() + FIELD_OFFSET_TIMESTAMP);
  }

  public long trace() {
    return buffer().getLong(offset() + FIELD_OFFSET_TRACE);
  }

  public long authorization() {
    return buffer().getLong(offset() + FIELD_OFFSET_AUTHORIZATION);
  }

  public long signalId() {
    return buffer().getLong(offset() + FIELD_OFFSET_SIGNAL_ID);
  }

  public int typeId() {
    return TYPE_ID;
  }

  @Override
  public SignalFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public SignalFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return offset() + FIELD_OFFSET_SIGNAL_ID + FIELD_SIZE_SIGNAL_ID;
  }

  @Override
  public String toString() {
    return String.format("SIGNAL [routeId=%d, streamId=%d, timestamp=%d, trace=%d, authorization=%d, signalId=%d]", routeId(), streamId(), timestamp(), trace(), authorization(), signalId());
  }

  public static final class Builder extends Flyweight.Builder<SignalFW> {
    private static final int INDEX_ROUTE_ID = 0;

    private static final int INDEX_STREAM_ID = 1;

    private static final int INDEX_TIMESTAMP = 2;

    private static final long DEFAULT_TIMESTAMP = 0;

    private static final int INDEX_TRACE = 3;

    private static final long DEFAULT_TRACE = 0;

    private static final int INDEX_AUTHORIZATION = 4;

    private static final long DEFAULT_AUTHORIZATION = 0;

    private static final int INDEX_SIGNAL_ID = 5;

    private static final int FIELD_COUNT = 6;

    private int lastFieldSet = -1;

    public Builder() {
      super(new SignalFW());
    }

    public Builder routeId(long value) {
      assert lastFieldSet == INDEX_ROUTE_ID - 1;
      int newLimit = limit() + FIELD_SIZE_ROUTE_ID;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_ROUTE_ID;
      limit(newLimit);
      return this;
    }

    public Builder streamId(long value) {
      assert lastFieldSet == INDEX_STREAM_ID - 1;
      int newLimit = limit() + FIELD_SIZE_STREAM_ID;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_STREAM_ID;
      limit(newLimit);
      return this;
    }

    public Builder timestamp(long value) {
      assert lastFieldSet == INDEX_TIMESTAMP - 1;
      int newLimit = limit() + FIELD_SIZE_TIMESTAMP;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_TIMESTAMP;
      limit(newLimit);
      return this;
    }

    public Builder trace(long value) {
      if (lastFieldSet < INDEX_TIMESTAMP) {
        timestamp(DEFAULT_TIMESTAMP);
      }
      assert lastFieldSet == INDEX_TRACE - 1;
      int newLimit = limit() + FIELD_SIZE_TRACE;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_TRACE;
      limit(newLimit);
      return this;
    }

    public Builder authorization(long value) {
      if (lastFieldSet < INDEX_TRACE) {
        trace(DEFAULT_TRACE);
      }
      assert lastFieldSet == INDEX_AUTHORIZATION - 1;
      int newLimit = limit() + FIELD_SIZE_AUTHORIZATION;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_AUTHORIZATION;
      limit(newLimit);
      return this;
    }

    public Builder signalId(long value) {
      if (lastFieldSet < INDEX_AUTHORIZATION) {
        authorization(DEFAULT_AUTHORIZATION);
      }
      assert lastFieldSet == INDEX_SIGNAL_ID - 1;
      int newLimit = limit() + FIELD_SIZE_SIGNAL_ID;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_SIGNAL_ID;
      limit(newLimit);
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      lastFieldSet = -1;
      super.wrap(buffer, offset, maxLimit);
      limit(offset);
      return this;
    }

    @Override
    public SignalFW build() {
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
