// TODO: license
package org.reaktivity.nukleus.tls.internal.types.stream;

import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.tls.internal.types.Flyweight;
import org.reaktivity.nukleus.tls.internal.types.StringFW;

public final class TlsBeginExFW extends Flyweight {
  public static final int FIELD_OFFSET_HOSTNAME = 0;

  public static final int FIELD_OFFSET_APPLICATION_PROTOCOL = 0;

  private final StringFW hostnameRO = new StringFW();

  private final StringFW applicationProtocolRO = new StringFW();

  public StringFW hostname() {
    return hostnameRO;
  }

  public StringFW applicationProtocol() {
    return applicationProtocolRO;
  }

  @Override
  public TlsBeginExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    hostnameRO.wrap(buffer, offset + FIELD_OFFSET_HOSTNAME, maxLimit);
    applicationProtocolRO.wrap(buffer, hostnameRO.limit() + FIELD_OFFSET_APPLICATION_PROTOCOL, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public TlsBeginExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    if (null == hostnameRO.tryWrap(buffer, offset + FIELD_OFFSET_HOSTNAME, maxLimit)) {
      return null;
    }
    if (null == applicationProtocolRO.tryWrap(buffer, hostnameRO.limit() + FIELD_OFFSET_APPLICATION_PROTOCOL, maxLimit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return applicationProtocolRO.limit();
  }

  @Override
  public String toString() {
    return String.format("TLS_BEGIN_EX [hostname=%s, applicationProtocol=%s]", hostnameRO.asString(), applicationProtocolRO.asString());
  }

  public static final class Builder extends Flyweight.Builder<TlsBeginExFW> {
    private static final int INDEX_HOSTNAME = 0;

    private static final int INDEX_APPLICATION_PROTOCOL = 1;

    private static final int FIELD_COUNT = 2;

    private final StringFW.Builder hostnameRW = new StringFW.Builder();

    private final StringFW.Builder applicationProtocolRW = new StringFW.Builder();

    private int lastFieldSet = -1;

    public Builder() {
      super(new TlsBeginExFW());
    }

    private StringFW.Builder hostname() {
      assert lastFieldSet == INDEX_HOSTNAME - 1;
      return hostnameRW.wrap(buffer(), limit(), maxLimit());
    }

    public Builder hostname(String value) {
      StringFW.Builder hostnameRW = hostname();
      hostnameRW.set(value, StandardCharsets.UTF_8);
      lastFieldSet = INDEX_HOSTNAME;
      limit(hostnameRW.build().limit());
      return this;
    }

    public Builder hostname(StringFW value) {
      StringFW.Builder hostnameRW = hostname();
      hostnameRW.set(value);
      lastFieldSet = INDEX_HOSTNAME;
      limit(hostnameRW.build().limit());
      return this;
    }

    public Builder hostname(DirectBuffer buffer, int offset, int length) {
      StringFW.Builder hostnameRW = hostname();
      hostnameRW.set(buffer, offset, length);
      lastFieldSet = INDEX_HOSTNAME;
      limit(hostnameRW.build().limit());
      return this;
    }

    private StringFW.Builder applicationProtocol() {
      assert lastFieldSet == INDEX_APPLICATION_PROTOCOL - 1;
      return applicationProtocolRW.wrap(buffer(), limit(), maxLimit());
    }

    public Builder applicationProtocol(String value) {
      StringFW.Builder applicationProtocolRW = applicationProtocol();
      applicationProtocolRW.set(value, StandardCharsets.UTF_8);
      lastFieldSet = INDEX_APPLICATION_PROTOCOL;
      limit(applicationProtocolRW.build().limit());
      return this;
    }

    public Builder applicationProtocol(StringFW value) {
      StringFW.Builder applicationProtocolRW = applicationProtocol();
      applicationProtocolRW.set(value);
      lastFieldSet = INDEX_APPLICATION_PROTOCOL;
      limit(applicationProtocolRW.build().limit());
      return this;
    }

    public Builder applicationProtocol(DirectBuffer buffer, int offset, int length) {
      StringFW.Builder applicationProtocolRW = applicationProtocol();
      applicationProtocolRW.set(buffer, offset, length);
      lastFieldSet = INDEX_APPLICATION_PROTOCOL;
      limit(applicationProtocolRW.build().limit());
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      lastFieldSet = -1;
      super.wrap(buffer, offset, maxLimit);
      limit(offset);
      return this;
    }

    @Override
    public TlsBeginExFW build() {
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
