/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.tls.internal.bench;

import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.ToIntFunction;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Group;
import org.openjdk.jmh.annotations.GroupThreads;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Control;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.reaktivity.nukleus.Configuration;
import org.reaktivity.nukleus.function.MessageConsumer;
import org.reaktivity.nukleus.function.MessagePredicate;
import org.reaktivity.nukleus.tls.internal.TlsController;
import org.reaktivity.nukleus.tls.internal.types.Flyweight;
import org.reaktivity.nukleus.tls.internal.types.OctetsFW;
import org.reaktivity.nukleus.tls.internal.types.stream.BeginFW;
import org.reaktivity.nukleus.tls.internal.types.stream.DataFW;
import org.reaktivity.nukleus.tls.internal.types.stream.TlsBeginExFW;
import org.reaktivity.nukleus.tls.internal.types.stream.WindowFW;
import org.reaktivity.reaktor.Reaktor;
import org.reaktivity.reaktor.ReaktorConfiguration;

@State(value=Scope.Benchmark)
@BenchmarkMode(value={Mode.Throughput})
@Fork(value=3)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@OutputTimeUnit(value=TimeUnit.SECONDS)
public class TlsServerBM {
    private final Configuration configuration;
    private final Reaktor reaktor;
    private final BeginFW beginRO;
    private final DataFW dataRO;
    private final BeginFW.Builder beginRW;
    private final DataFW.Builder dataRW;
    private final WindowFW.Builder windowRW;
    private final TlsBeginExFW.Builder tlsBeginExRW;
    private Source source;
    private Target target;
    private long routeId;
    private long targetRef;

    public TlsServerBM() {
        Properties properties = new Properties();
        properties.setProperty(ReaktorConfiguration.REAKTOR_DIRECTORY.name(), "target/nukleus-benchmarks");
        properties.setProperty(ReaktorConfiguration.REAKTOR_STREAMS_BUFFER_CAPACITY.name(), Long.toString(0x1000000L));
        this.configuration = new Configuration(properties);
        this.reaktor = Reaktor.builder().config(this.configuration).nukleus("tls"::equals).controller("tls"::equals).errorHandler(ex -> ex.printStackTrace(System.err)).build();
        this.beginRO = new BeginFW();
        this.dataRO = new DataFW();
        this.beginRW = new BeginFW.Builder();
        this.dataRW = new DataFW.Builder();
        this.windowRW = new WindowFW.Builder();
        this.tlsBeginExRW = new TlsBeginExFW.Builder();
    }

    @Setup(value=Level.Trial)
    public void reinit() throws Exception {
        TlsController controller = (TlsController)this.reaktor.controller(TlsController.class);
        Random random = new Random();
        this.targetRef = random.nextLong();
        this.routeId = (Long)controller.routeServer("tls#0", "target#0", null, null, null).get();
        long sourceId = random.nextLong();
        this.source.reinit(this.routeId, sourceId);
        this.target.reinit();
        this.source.doBegin();
    }

    @TearDown(value=Level.Trial)
    public void reset() throws Exception {
        TlsController controller = (TlsController)this.reaktor.controller(TlsController.class);
        controller.unroute(this.routeId).get();
        this.source = null;
        this.target = null;
    }

    @Benchmark
    @Group(value="throughput")
    @GroupThreads(value=1)
    public void writer(Control control) throws Exception {
        while (!control.stopMeasurement && this.source.process() == 0) {
            Thread.yield();
        }
    }

    @Benchmark
    @Group(value="throughput")
    @GroupThreads(value=1)
    public void reader(Control control) throws Exception {
        while (!control.stopMeasurement && this.target.read() == 0) {
            Thread.yield();
        }
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(TlsServerBM.class.getSimpleName()).forks(0).build();
        new Runner(opt).run();
    }

    private final class Target {
        private final ToIntFunction<MessageConsumer> streams;
        private final MessagePredicate throttle;
        private MutableDirectBuffer writeBuffer;
        private MessageConsumer readHandler;

        private Target(ToIntFunction<MessageConsumer> streams, MessagePredicate throttle) {
            this.streams = streams;
            this.throttle = throttle;
        }

        private void reinit() {
            this.writeBuffer = new UnsafeBuffer(new byte[256]);
            this.readHandler = this::beforeBegin;
        }

        private int read() {
            return this.streams.applyAsInt(this.readHandler);
        }

        private void beforeBegin(int msgTypeId, DirectBuffer buffer, int index, int length) {
            BeginFW begin = TlsServerBM.this.beginRO.wrap(buffer, index, index + length);
            long streamId = begin.streamId();
            this.doWindow(streamId, 8192, 0);
            this.readHandler = this::afterBegin;
        }

        private void afterBegin(int msgTypeId, DirectBuffer buffer, int index, int length) {
            DataFW data = TlsServerBM.this.dataRO.wrap(buffer, index, index + length);
            long streamId = data.streamId();
            OctetsFW payload = data.payload();
            int update = payload.sizeof();
            this.doWindow(streamId, update, 0);
        }

        private boolean doWindow(long streamId, int credit, int padding) {
            WindowFW window = TlsServerBM.this.windowRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).streamId(streamId).credit(credit).padding(padding).build();
            return this.throttle.test(window.typeId(), window.buffer(), window.offset(), window.sizeof());
        }
    }

    private final class Source {
        private final MessagePredicate streams;
        private final ToIntFunction<MessageConsumer> throttle;
        private BeginFW begin;
        private DataFW data;

        private Source(MessagePredicate streams, ToIntFunction<MessageConsumer> throttle) {
            this.streams = streams;
            this.throttle = throttle;
        }

        private void reinit(long sourceRef, long sourceId) {
            UnsafeBuffer writeBuffer = new UnsafeBuffer(new byte[256]);
            this.begin = TlsServerBM.this.beginRW.wrap((MutableDirectBuffer)writeBuffer, 0, writeBuffer.capacity()).routeId(TlsServerBM.this.routeId).streamId(sourceId).extension(e -> e.set(this.visitTlsBeginEx("example.com"))).build();
            byte[] charBytes = "Hello, world".getBytes(StandardCharsets.UTF_8);
        }

        private boolean doBegin() {
            return this.streams.test(this.begin.typeId(), this.begin.buffer(), this.begin.offset(), this.begin.sizeof());
        }

        private int process() {
            int work = 0;
            if (this.streams.test(this.data.typeId(), this.data.buffer(), this.data.offset(), this.data.sizeof())) {
                ++work;
            }
            return work += this.throttle.applyAsInt((t, b, i, l) -> {});
        }

        private Flyweight.Builder.Visitor visitTlsBeginEx(String hostname) {
            return (buffer, offset, limit) -> TlsServerBM.this.tlsBeginExRW.wrap(buffer, offset, limit).hostname(hostname).build().sizeof();
        }
    }
}

