/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.tls.internal.control;

import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.DisableOnDebug;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.kaazing.k3po.junit.annotation.ScriptProperty;
import org.kaazing.k3po.junit.annotation.Specification;
import org.kaazing.k3po.junit.rules.K3poRule;
import org.reaktivity.reaktor.test.ReaktorRule;

public class ControlIT {
    private final K3poRule k3po = new K3poRule().addScriptRoot("route", "org/reaktivity/specification/nukleus/tls/control/route").addScriptRoot("resolve", "org/reaktivity/specification/nukleus/tls/control/resolve").addScriptRoot("unroute", "org/reaktivity/specification/nukleus/tls/control/unroute").addScriptRoot("freeze", "org/reaktivity/specification/nukleus/control/freeze");
    private final TestRule timeout = new DisableOnDebug((TestRule)new Timeout(5L, TimeUnit.SECONDS));
    private final ReaktorRule reaktor = new ReaktorRule().directory("target/nukleus-itests").commandBufferCapacity(1024).responseBufferCapacity(1024).counterValuesBufferCapacity(4096).nukleus("tls"::equals);
    @Rule
    public final TestRule chain = RuleChain.outerRule((TestRule)this.k3po).around(this.timeout).around((TestRule)this.reaktor);

    @Test
    @Specification(value={"${route}/server/controller"})
    public void shouldRouteServer() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client/controller"})
    public void shouldRouteClient() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${resolve}/one.realm/controller"})
    public void shouldResolve() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/server/controller", "${unroute}/server/controller"})
    public void shouldUnrouteServer() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client/controller", "${unroute}/client/controller"})
    public void shouldUnrouteClient() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${freeze}/controller"})
    @ScriptProperty(value={"nameF00C \"tls\""})
    public void shouldFreeze() throws Exception {
        this.k3po.finish();
    }
}

