/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.tls.internal.control;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.DisableOnDebug;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.kaazing.k3po.junit.annotation.ScriptProperty;
import org.kaazing.k3po.junit.annotation.Specification;
import org.kaazing.k3po.junit.rules.K3poRule;
import org.reaktivity.nukleus.route.RouteKind;
import org.reaktivity.nukleus.tls.internal.TlsController;
import org.reaktivity.reaktor.test.ReaktorRule;

public class ControllerIT {
    private final K3poRule k3po = new K3poRule().addScriptRoot("route", "org/reaktivity/specification/nukleus/tls/control/route").addScriptRoot("unroute", "org/reaktivity/specification/nukleus/tls/control/unroute").addScriptRoot("freeze", "org/reaktivity/specification/nukleus/control/freeze");
    private final TestRule timeout = new DisableOnDebug((TestRule)new Timeout(5L, TimeUnit.SECONDS));
    private final ReaktorRule reaktor = new ReaktorRule().directory("target/nukleus-itests").commandBufferCapacity(1024).responseBufferCapacity(1024).counterValuesBufferCapacity(4096).controller("tls"::equals);
    @Rule
    public final TestRule chain = RuleChain.outerRule((TestRule)this.k3po).around(this.timeout).around((TestRule)this.reaktor);
    private final Gson gson = new Gson();

    @Test
    @Specification(value={"${route}/server/nukleus"})
    public void shouldRouteServer() throws Exception {
        this.k3po.start();
        JsonObject extension = new JsonObject();
        extension.addProperty("store", "server");
        extension.addProperty("hostname", "localhost");
        ((TlsController)this.reaktor.controller(TlsController.class)).route(RouteKind.SERVER, "tls#0", "target#0", this.gson.toJson((JsonElement)extension)).get();
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client/nukleus"})
    public void shouldRouteClient() throws Exception {
        this.k3po.start();
        JsonObject extension = new JsonObject();
        extension.addProperty("store", "client");
        extension.addProperty("hostname", "localhost");
        ((TlsController)this.reaktor.controller(TlsController.class)).route(RouteKind.CLIENT, "tls#0", "target#0", this.gson.toJson((JsonElement)extension)).get();
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/server/nukleus", "${unroute}/server/nukleus"})
    public void shouldUnrouteServer() throws Exception {
        this.k3po.start();
        JsonObject extension = new JsonObject();
        extension.addProperty("store", "server");
        extension.addProperty("hostname", "localhost");
        long routeId = (Long)((TlsController)this.reaktor.controller(TlsController.class)).route(RouteKind.SERVER, "tls#0", "target#0", this.gson.toJson((JsonElement)extension)).get();
        this.k3po.notifyBarrier("ROUTED_SERVER");
        ((TlsController)this.reaktor.controller(TlsController.class)).unroute(routeId).get();
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client/nukleus", "${unroute}/client/nukleus"})
    public void shouldUnrouteClient() throws Exception {
        this.k3po.start();
        JsonObject extension = new JsonObject();
        extension.addProperty("store", "client");
        extension.addProperty("hostname", "localhost");
        long routeId = (Long)((TlsController)this.reaktor.controller(TlsController.class)).route(RouteKind.CLIENT, "tls#0", "target#0", this.gson.toJson((JsonElement)extension)).get();
        this.k3po.notifyBarrier("ROUTED_CLIENT");
        ((TlsController)this.reaktor.controller(TlsController.class)).unroute(routeId).get();
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${freeze}/nukleus"})
    @ScriptProperty(value={"nameF00N \"tls\""})
    public void shouldFreeze() throws Exception {
        this.k3po.start();
        ((TlsController)this.reaktor.controller(TlsController.class)).freeze().get();
        this.k3po.finish();
    }
}

