/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.tls.internal.streams;

import java.util.concurrent.TimeUnit;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.DisableOnDebug;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.kaazing.k3po.junit.annotation.ScriptProperty;
import org.kaazing.k3po.junit.annotation.Specification;
import org.kaazing.k3po.junit.rules.K3poRule;
import org.reaktivity.reaktor.test.ReaktorRule;

public class ClientIT {
    private final K3poRule k3po = new K3poRule().addScriptRoot("route", "org/reaktivity/specification/nukleus/tls/control/route").addScriptRoot("client", "org/reaktivity/specification/nukleus/tls/streams").addScriptRoot("server", "org/reaktivity/specification/tls");
    private final TestRule timeout = new DisableOnDebug((TestRule)new Timeout(10L, TimeUnit.SECONDS));
    private final ReaktorRule reaktor = new ReaktorRule().directory("target/nukleus-itests").commandBufferCapacity(1024).responseBufferCapacity(1024).counterValuesBufferCapacity(8192).nukleus("tls"::equals).affinityMask("target#0", Long.MIN_VALUE).clean();
    @Rule
    public final TestRule chain = RuleChain.outerRule((TestRule)this.reaktor).around((TestRule)this.k3po).around(this.timeout);

    @Test
    @Specification(value={"${route}/client/controller", "${client}/connection.established/client", "${server}/connection.established/server"})
    @ScriptProperty(value={"serverAccept \"nukleus://streams/target#0\""})
    public void shouldEstablishConnection() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client.default.store/controller", "${client}/connection.established/client", "${server}/connection.established/server"})
    @ScriptProperty(value={"serverAccept \"nukleus://streams/target#0\""})
    public void shouldEstablishConnectionDefaultStore() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client.default.store/controller", "${client}/client.auth/client", "${server}/client.auth/server"})
    @ScriptProperty(value={"serverAccept \"nukleus://streams/target#0\""})
    public void shouldEstablishConnectionWithClientAuth() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client/controller", "${client}/connection.established.with.extension.data/client", "${server}/connection.established.with.extension.data/server"})
    public void shouldEstablishConnectionWithExtensionData() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client.alpn/controller", "${client}/connection.established.with.alpn/client", "${server}/connection.established.with.alpn/server"})
    @ScriptProperty(value={"serverAccept \"nukleus://streams/target#0\""})
    public void shouldEstablishConnectionWithAlpn() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client/controller", "${client}/connection.established.no.hostname.no.alpn/client", "${server}/connection.established.no.hostname.no.alpn/server"})
    @ScriptProperty(value={"serverAccept \"nukleus://streams/target#0\""})
    public void shouldEstablishConnectionWithNoHostnameNoAlpn() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client/controller", "${client}/connection.established.with.alpn/client", "${server}/connection.established/server"})
    @ScriptProperty(value={"serverAccept \"nukleus://streams/target#0\""})
    public void shouldNegotiateWithNoALPNAsNoProtocolRouteExists() throws Exception {
        this.k3po.finish();
    }

    @Ignore(value="https://github.com/k3po/k3po/issues/454 - Support connect aborted")
    @Test
    @Specification(value={"${route}/client.alpn/controller", "${client}/connection.established.with.alpn/client", "${server}/connection.established/server"})
    @ScriptProperty(value={"serverAccept \"nukleus://streams/target#0\""})
    public void shouldFailNoALPNNoDefaultRoute() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client.alpn.default/controller", "${client}/connection.established.with.alpn/client", "${server}/connection.established/server"})
    @ScriptProperty(value={"serverAccept \"nukleus://streams/target#0\""})
    public void shouldSucceedNoALPNDefaultRoute() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client/controller", "${client}/connection.established/client", "${server}/connection.established/server"})
    @ScriptProperty(value={"serverAccept \"nukleus://streams/target#0\"", "authorization 0x0001_000000000000L"})
    public void shouldEstablishConnectionWithAuthorization() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client/controller", "${client}/echo.payload.length.10k/client", "${server}/echo.payload.length.10k/server"})
    @ScriptProperty(value={"serverAccept \"nukleus://streams/target#0\""})
    public void shouldEchoPayloadLength10k() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client/controller", "${client}/echo.payload.length.10k/client", "${server}/echo.payload.length.10k/server"})
    @ScriptProperty(value={"serverAccept \"nukleus://streams/target#0\""})
    public void shouldEchoPayloadLength10kWithAuthorization() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client/controller", "${client}/echo.payload.length.100k/client", "${server}/echo.payload.length.100k/server"})
    @ScriptProperty(value={"serverAccept \"nukleus://streams/target#0\""})
    public void shouldEchoPayloadLength100k() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client/controller", "${client}/echo.payload.length.1000k/client", "${server}/echo.payload.length.1000k/server"})
    @ScriptProperty(value={"serverAccept \"nukleus://streams/target#0\""})
    public void shouldEchoPayloadLength1000k() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client/controller", "${client}/server.sent.write.close/client", "${server}/server.sent.write.close/server"})
    @ScriptProperty(value={"serverAccept \"nukleus://streams/target#0\""})
    public void shouldReceiveServerSentWriteClose() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client/controller", "${client}/server.sent.write.close.before.correlated/client", "${server}/server.sent.write.close.before.correlated/server"})
    @ScriptProperty(value={"serverAccept \"nukleus://streams/target#0\""})
    public void shouldReceiveServerSentWriteCloseBeforeCorrelated() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client/controller", "${client}/client.sent.write.close/client", "${server}/client.sent.write.close/server"})
    @ScriptProperty(value={"serverAccept \"nukleus://streams/target#0\""})
    public void shouldReceiveClientSentWriteClose() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client/controller", "${client}/client.sent.write.close.before.correlated/client", "${server}/client.sent.write.close.before.correlated/server"})
    @ScriptProperty(value={"serverAccept \"nukleus://streams/target#0\""})
    public void shouldReceiveClientSentWriteCloseBeforeCorrelated() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client/controller", "${client}/server.sent.write.abort/client", "${server}/server.sent.write.abort/server"})
    @ScriptProperty(value={"serverAccept \"nukleus://streams/target#0\""})
    public void shouldReceiveServerSentWriteAbort() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client/controller", "${client}/server.sent.write.abort.before.correlated/client", "${server}/server.sent.write.abort.before.correlated/server"})
    @ScriptProperty(value={"serverAccept \"nukleus://streams/target#0\""})
    public void shouldReceiveServerSentWriteAbortBeforeCorrelated() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client/controller", "${client}/client.sent.write.abort/client", "${server}/client.sent.write.abort/server"})
    @ScriptProperty(value={"serverAccept \"nukleus://streams/target#0\""})
    public void shouldReceiveClientSentWriteAbort() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client/controller", "${client}/client.sent.write.abort.before.correlated/client", "${server}/client.sent.write.abort.before.correlated/server"})
    @ScriptProperty(value={"serverAccept \"nukleus://streams/target#0\""})
    public void shouldReceiveClientSentWriteAbortBeforeCorrelated() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client/controller", "${client}/server.sent.read.abort/client", "${server}/server.sent.read.abort/server"})
    @ScriptProperty(value={"serverAccept \"nukleus://streams/target#0\""})
    public void shouldReceiveServerSentReadAbort() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client/controller", "${client}/server.sent.read.abort.before.correlated/client", "${server}/server.sent.read.abort.before.correlated/server"})
    @ScriptProperty(value={"serverAccept \"nukleus://streams/target#0\""})
    public void shouldReceiveServerSentReadAbortBeforeCorrelated() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client/controller", "${client}/client.sent.read.abort/client", "${server}/client.sent.read.abort/server"})
    @ScriptProperty(value={"serverAccept \"nukleus://streams/target#0\""})
    public void shouldReceiveClientSentReadAbort() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/client/controller", "${client}/client.sent.read.abort.before.correlated/client", "${server}/client.sent.read.abort.before.correlated/server"})
    @ScriptProperty(value={"serverAccept \"nukleus://streams/target#0\""})
    public void shouldReceiveClientSentReadAbortBeforeCorrelated() throws Exception {
        this.k3po.finish();
    }
}

