/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.tls.internal.streams;

import java.util.concurrent.TimeUnit;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.DisableOnDebug;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.kaazing.k3po.junit.annotation.ScriptProperty;
import org.kaazing.k3po.junit.annotation.Specification;
import org.kaazing.k3po.junit.rules.K3poRule;
import org.reaktivity.reaktor.test.ReaktorRule;

public class ServerIT {
    private final K3poRule k3po = new K3poRule().addScriptRoot("route", "org/reaktivity/specification/nukleus/tls/control/route").addScriptRoot("client", "org/reaktivity/specification/tls").addScriptRoot("server", "org/reaktivity/specification/nukleus/tls/streams");
    private final TestRule timeout = new DisableOnDebug((TestRule)new Timeout(10L, TimeUnit.SECONDS));
    private final ReaktorRule reaktor = new ReaktorRule().directory("target/nukleus-itests").commandBufferCapacity(1024).responseBufferCapacity(1024).counterValuesBufferCapacity(8192).nukleus("tls"::equals).affinityMask("target#0", Long.MIN_VALUE).clean();
    @Rule
    public final TestRule chain = RuleChain.outerRule((TestRule)this.reaktor).around((TestRule)this.k3po).around(this.timeout);

    @Test
    @Specification(value={"${route}/server/controller", "${client}/connection.established/client", "${server}/connection.established/server"})
    @ScriptProperty(value={"clientAccept \"nukleus://streams/target#0\""})
    public void shouldEstablishConnection() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/server/controller", "${client}/connection.established/client", "${server}/connection.established/server"})
    @ScriptProperty(value={"clientAccept \"nukleus://streams/target#0\""})
    public void shouldEstablishConnectionDefaultStore() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/server.alpn/controller", "${client}/connection.established.with.alpn/client", "${server}/connection.established.with.alpn/server"})
    @ScriptProperty(value={"clientAccept \"nukleus://streams/target#0\""})
    public void shouldNegotiateWithALPN() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/server/controller", "${client}/connection.established.with.alpn/client", "${server}/connection.established/server"})
    @ScriptProperty(value={"clientAccept \"nukleus://streams/target#0\""})
    public void shouldNotNegotiateALPNWithDefaultRoute() throws Exception {
        this.k3po.finish();
    }

    @Ignore(value="https://github.com/k3po/k3po/issues/454 - Support connect aborted")
    @Test
    @Specification(value={"${route}/server.alpn/controller", "${client}/connection.not.established.with.wrong.alpn/client", "${server}/connection.established/server"})
    @ScriptProperty(value={"clientAccept \"nukleus://streams/target#0\""})
    public void shouldNotNegotiateWithALPNAsProtocolMismatch() throws Exception {
        this.k3po.finish();
    }

    @Ignore(value="https://github.com/k3po/k3po/issues/454 - Support connect aborted")
    @Test
    @Specification(value={"${route}/server.alpn/controller", "${client}/connection.established/client"})
    @ScriptProperty(value={"clientAccept \"nukleus://streams/target#0\""})
    public void shouldNegotiateWithNoALPNButRouteMismatch() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/server.alpn.default/controller", "${client}/connection.established.with.alpn/client", "${server}/connection.established.with.alpn/server"})
    @ScriptProperty(value={"clientAccept \"nukleus://streams/target#0\""})
    public void shouldNegotiateALPNWithAlpnAndDefaultRoutes() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/server.alpn.default/controller", "${client}/connection.established/client", "${server}/connection.established/server"})
    @ScriptProperty(value={"clientAccept \"nukleus://streams/target#0\""})
    public void shouldNotNegotiateALPNWithAlpnAndDefaultRoutes() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/server/controller", "${client}/echo.payload.length.10k/client", "${server}/echo.payload.length.10k/server"})
    @ScriptProperty(value={"clientAccept \"nukleus://streams/target#0\""})
    public void shouldEchoPayloadLength10k() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/server/controller", "${client}/echo.payload.length.100k/client", "${server}/echo.payload.length.100k/server"})
    @ScriptProperty(value={"clientAccept \"nukleus://streams/target#0\""})
    public void shouldEchoPayloadLength100k() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/server/controller", "${client}/echo.payload.length.1000k/client", "${server}/echo.payload.length.1000k/server"})
    @ScriptProperty(value={"clientAccept \"nukleus://streams/target#0\""})
    public void shouldEchoPayloadLength1000k() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/server/controller", "${client}/server.sent.write.close.before.correlated/client", "${server}/server.sent.write.close.before.correlated/server"})
    @ScriptProperty(value={"clientAccept \"nukleus://streams/target#0\""})
    public void shouldReceiveServerSentWriteCloseBeforeCorrelated() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/server/controller", "${client}/server.sent.write.close/client", "${server}/server.sent.write.close/server"})
    @ScriptProperty(value={"clientAccept \"nukleus://streams/target#0\""})
    public void shouldReceiveServerSentWriteClose() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/server/controller", "${client}/client.sent.write.close.before.correlated/client", "${server}/client.sent.write.close.before.correlated/server"})
    @ScriptProperty(value={"clientAccept \"nukleus://streams/target#0\""})
    public void shouldReceiveClientSentWriteCloseBeforeCorrelated() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/server/controller", "${client}/client.sent.write.close.before.handshake/client"})
    public void shouldReceiveClientSentWriteCloseBeforeHandshake() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/server/controller", "${client}/client.sent.write.close/client", "${server}/client.sent.write.close/server"})
    @ScriptProperty(value={"clientAccept \"nukleus://streams/target#0\""})
    public void shouldReceiveClientSentWriteClose() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/server/controller", "${client}/server.sent.write.abort/client", "${server}/server.sent.write.abort/server"})
    @ScriptProperty(value={"clientAccept \"nukleus://streams/target#0\""})
    public void shouldReceiveServerSentWriteAbort() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/server/controller", "${client}/client.sent.write.abort.before.correlated/client", "${server}/client.sent.write.abort.before.correlated/server"})
    @ScriptProperty(value={"clientAccept \"nukleus://streams/target#0\""})
    public void shouldReceiveClientSentWriteAbortBeforeCorrelated() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/server/controller", "${client}/client.sent.write.abort/client", "${server}/client.sent.write.abort/server"})
    @ScriptProperty(value={"clientAccept \"nukleus://streams/target#0\""})
    public void shouldReceiveClientSentWriteAbort() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/server/controller", "${client}/server.sent.read.abort/client", "${server}/server.sent.read.abort/server"})
    @ScriptProperty(value={"clientAccept \"nukleus://streams/target#0\""})
    public void shouldReceiveServerSentReadAbort() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/server/controller", "${client}/client.sent.read.abort.before.correlated/client", "${server}/client.sent.read.abort.before.correlated/server"})
    @ScriptProperty(value={"clientAccept \"nukleus://streams/target#0\""})
    public void shouldReceiveClientSentReadAbortBeforeCorrelated() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/server/controller", "${client}/client.sent.read.abort/client", "${server}/client.sent.read.abort/server"})
    @ScriptProperty(value={"clientAccept \"nukleus://streams/target#0\""})
    public void shouldReceiveClientSentReadAbort() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/server/controller", "${client}/client.hello.malformed/client"})
    public void shouldResetMalformedClientHello() throws Exception {
        this.k3po.finish();
    }

    @Test
    @Specification(value={"${route}/server.want.auth/controller", "${client}/server.want.auth/client", "${server}/server.want.auth/server"})
    @ScriptProperty(value={"clientAccept \"nukleus://streams/target#0\"", "authorization  -2666130979403333631L"})
    public void serverWantClientAuth() throws Exception {
        this.k3po.finish();
    }
}

