/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.tls.internal.streams;

import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.DisableOnDebug;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.kaazing.k3po.junit.annotation.ScriptProperty;
import org.kaazing.k3po.junit.annotation.Specification;
import org.kaazing.k3po.junit.rules.K3poRule;
import org.reaktivity.reaktor.test.ReaktorRule;

public class ServerRouteCountersIT {
    private static final long SERVER_ROUTE_ID = 0x2000100000001L;
    private final K3poRule k3po = new K3poRule().addScriptRoot("route", "org/reaktivity/specification/nukleus/tls/control/route").addScriptRoot("client", "org/reaktivity/specification/tls").addScriptRoot("server", "org/reaktivity/specification/nukleus/tls/streams");
    private final TestRule timeout = new DisableOnDebug((TestRule)new Timeout(10L, TimeUnit.SECONDS));
    private final ReaktorRule reaktor = new ReaktorRule().directory("target/nukleus-itests").controller("tls"::equals).commandBufferCapacity(1024).responseBufferCapacity(1024).counterValuesBufferCapacity(8192).nukleus("tls"::equals).affinityMask("target#0", Long.MIN_VALUE).clean();
    @Rule
    public final TestRule chain = RuleChain.outerRule((TestRule)this.reaktor).around((TestRule)this.k3po).around(this.timeout);

    @Test
    @Specification(value={"${route}/server/controller", "${client}/echo.payload.length.10k/client", "${server}/echo.payload.length.10k/server"})
    @ScriptProperty(value={"clientAccept \"nukleus://streams/target#0\""})
    public void shouldEchoPayloadLength10k() throws Exception {
        this.k3po.finish();
        Assert.assertThat((Object)this.reaktor.bytesWritten("tls", 0x2000100000001L), (Matcher)Matchers.equalTo((Object)10240L));
        Assert.assertThat((Object)this.reaktor.bytesRead("tls", 0x2000100000001L), (Matcher)Matchers.equalTo((Object)10240L));
        Assert.assertThat((Object)this.reaktor.framesWritten("tls", 0x2000100000001L), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(1L)));
        Assert.assertThat((Object)this.reaktor.framesRead("tls", 0x2000100000001L), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(1L)));
    }
}

