/**
 * Copyright 2016-2020 The Reaktivity Project
 *
 * The Reaktivity Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at:
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package org.reaktivity.nukleus.function;

import java.util.Objects;

import org.agrona.DirectBuffer;

@FunctionalInterface
public interface MessagePredicate
{
    boolean test(
        int msgTypeId,
        DirectBuffer buffer,
        int index,
        int length);

    default MessagePredicate and(
        MessagePredicate other)
    {
        Objects.requireNonNull(other);
        return (t, b, i, l) -> test(t, b, i, l) && other.test(t, b, i, l);
    }

    default MessagePredicate negate()
    {
        return (t, b, i, l) -> !test(t, b, i, l);
    }

    default MessagePredicate or(
        MessagePredicate other)
    {
        Objects.requireNonNull(other);
        return (t, b, i, l) -> test(t, b, i, l) || other.test(t, b, i, l);
    }
}
