package react4j.dom;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;
import react4j.ReactElement;
import react4j.ReactNode;
import react4j.dom.proptypes.html.AnchorProps;
import react4j.dom.proptypes.html.AudioProps;
import react4j.dom.proptypes.html.BtnProps;
import react4j.dom.proptypes.html.ColProps;
import react4j.dom.proptypes.html.FormProps;
import react4j.dom.proptypes.html.HtmlProps;
import react4j.dom.proptypes.html.IFrameProps;
import react4j.dom.proptypes.html.ImgProps;
import react4j.dom.proptypes.html.InputProps;
import react4j.dom.proptypes.html.LabelProps;
import react4j.dom.proptypes.html.OptGroupProps;
import react4j.dom.proptypes.html.OptionProps;
import react4j.dom.proptypes.html.SelectProps;
import react4j.dom.proptypes.html.SourceProps;
import react4j.dom.proptypes.html.TdProps;
import react4j.dom.proptypes.html.TextAreaProps;
import react4j.dom.proptypes.html.ThProps;

/**
 * DOM provides convenience wrappers around React.createElement for DOM components.
 */
@Generated( "GwtReact" )
public final class DOM
{
  private DOM()
  {
  }

  // Arbitrarily large value as the time will be clamped to the expiration time of the whole tree
  private static final int DEFAULT_TIME_TO_FALLBACK = 1000000000;

  @Nonnull
  public static ReactNode text( @Nonnull final String content )
  {
    return ReactNode.of( content );
  }

  @Nonnull
  public static ReactNode fragment( @Nullable final String key, @Nonnull final ReactNode... children )
  {
    return ReactElement.createFragment( key, children );
  }

  @Nonnull
  public static ReactNode fragment( @Nullable final String key, @Nonnull final Stream<? extends ReactNode> children )
  {
    return fragment( key, toArray( children ) );
  }

  @Nonnull
  public static ReactNode fragment( @Nonnull final ReactNode... children )
  {
    return fragment( null, children );
  }

  @Nonnull
  public static ReactNode fragment( @Nonnull final Stream<? extends ReactNode> children )
  {
    return fragment( null, children );
  }

  @Nonnull
  public static ReactNode suspense( @Nullable final String key,
                                    @Nullable final ReactNode fallback,
                                    final int maxTimeToFallback,
                                    @Nonnull final ReactNode... children )
  {
    return ReactElement.createSuspense( key, fallback, maxTimeToFallback, children );
  }

  @Nonnull
  public static ReactNode suspense( @Nullable final String key,
                                    @Nullable final ReactNode fallback,
                                    final int maxTimeToFallback,
                                    @Nonnull final Stream<? extends ReactNode> children )
  {
    return suspense( key, fallback, maxTimeToFallback, toArray( children ) );
  }

  @Nonnull
  public static ReactNode suspense( @Nullable final ReactNode fallback,
                                    final int maxTimeToFallback,
                                    @Nonnull final ReactNode... children )
  {
    return suspense( null, fallback, maxTimeToFallback, children );
  }

  @Nonnull
  public static ReactNode suspense( @Nullable final ReactNode fallback,
                                    final int maxTimeToFallback,
                                    @Nonnull final Stream<? extends ReactNode> children )
  {
    return suspense( null, fallback, maxTimeToFallback, children );
  }

  @Nonnull
  public static ReactNode suspense( @Nullable final String key,
                                    @Nullable final ReactNode fallback,
                                    @Nonnull final ReactNode... children )
  {
    return suspense( key, fallback, DEFAULT_TIME_TO_FALLBACK, children );
  }

  @Nonnull
  public static ReactNode suspense( @Nullable final String key,
                                    @Nullable final ReactNode fallback,
                                    @Nonnull final Stream<? extends ReactNode> children )
  {
    return suspense( key, fallback, DEFAULT_TIME_TO_FALLBACK, toArray( children ) );
  }

  @Nonnull
  public static ReactNode suspense( @Nullable final ReactNode fallback, @Nonnull final ReactNode... children )
  {
    return suspense( null, fallback, DEFAULT_TIME_TO_FALLBACK, children );
  }

  @Nonnull
  public static ReactNode suspense( @Nullable final ReactNode fallback,
                                    @Nonnull final Stream<? extends ReactNode> children )
  {
    return suspense( null, fallback, DEFAULT_TIME_TO_FALLBACK, toArray( children ) );
  }

  @Nonnull
  public static ReactNode a()
  {
    return createElement( "a", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode a( @Nonnull final AnchorProps props )
  {
    return createElement( "a", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode a( @Nonnull final AnchorProps props, @Nullable final ReactNode... children )
  {
    return createElement( "a", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode a( @Nullable final ReactNode... children )
  {
    return createElement( "a", null, children );
  }

  @Nonnull
  public static ReactNode a( @Nonnull final AnchorProps props, @Nonnull final String content )
  {
    return createElement( "a", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode a( @Nonnull final String content )
  {
    return a( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode a( final byte content )
  {
    return a( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode a( final short content )
  {
    return a( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode a( final int content )
  {
    return a( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode a( final long content )
  {
    return a( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode a( final float content )
  {
    return a( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode a( final double content )
  {
    return a( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode a( @Nonnull final AnchorProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return a( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode a( @Nonnull final Stream<? extends ReactNode> children )
  {
    return a( toArray( children ) );
  }

  @Nonnull
  public static ReactNode article()
  {
    return createElement( "article", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode article( @Nonnull final HtmlProps props )
  {
    return createElement( "article", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode article( @Nonnull final HtmlProps props, @Nullable final ReactNode... children )
  {
    return createElement( "article", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode article( @Nullable final ReactNode... children )
  {
    return createElement( "article", null, children );
  }

  @Nonnull
  public static ReactNode article( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return createElement( "article", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode article( @Nonnull final String content )
  {
    return article( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode article( final byte content )
  {
    return article( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode article( final short content )
  {
    return article( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode article( final int content )
  {
    return article( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode article( final long content )
  {
    return article( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode article( final float content )
  {
    return article( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode article( final double content )
  {
    return article( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode article( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return article( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode article( @Nonnull final Stream<? extends ReactNode> children )
  {
    return article( toArray( children ) );
  }

  @Nonnull
  public static ReactNode audio()
  {
    return createElement( "audio", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode audio( @Nonnull final AudioProps props )
  {
    return createElement( "audio", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode audio( @Nonnull final AudioProps props, @Nullable final ReactNode... children )
  {
    return createElement( "audio", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode audio( @Nullable final ReactNode... children )
  {
    return createElement( "audio", null, children );
  }

  @Nonnull
  public static ReactNode audio( @Nonnull final AudioProps props, @Nonnull final String content )
  {
    return createElement( "audio", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode audio( @Nonnull final String content )
  {
    return audio( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode audio( final byte content )
  {
    return audio( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode audio( final short content )
  {
    return audio( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode audio( final int content )
  {
    return audio( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode audio( final long content )
  {
    return audio( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode audio( final float content )
  {
    return audio( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode audio( final double content )
  {
    return audio( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode audio( @Nonnull final AudioProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return audio( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode audio( @Nonnull final Stream<? extends ReactNode> children )
  {
    return audio( toArray( children ) );
  }

  @Nonnull
  public static ReactNode br()
  {
    return createElement( "br", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode br( @Nonnull final HtmlProps props )
  {
    return createElement( "br", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode button()
  {
    return createElement( "button", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode button( @Nonnull final BtnProps props )
  {
    return createElement( "button", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode button( @Nonnull final BtnProps props, @Nullable final ReactNode... children )
  {
    return createElement( "button", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode button( @Nullable final ReactNode... children )
  {
    return createElement( "button", null, children );
  }

  @Nonnull
  public static ReactNode button( @Nonnull final BtnProps props, @Nonnull final String content )
  {
    return createElement( "button", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode button( @Nonnull final String content )
  {
    return button( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode button( final byte content )
  {
    return button( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode button( final short content )
  {
    return button( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode button( final int content )
  {
    return button( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode button( final long content )
  {
    return button( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode button( final float content )
  {
    return button( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode button( final double content )
  {
    return button( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode button( @Nonnull final BtnProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return button( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode button( @Nonnull final Stream<? extends ReactNode> children )
  {
    return button( toArray( children ) );
  }

  @Nonnull
  public static ReactNode canvas()
  {
    return createElement( "canvas", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode canvas( @Nonnull final HtmlProps props )
  {
    return createElement( "canvas", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode canvas( @Nonnull final HtmlProps props, @Nullable final ReactNode... children )
  {
    return createElement( "canvas", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode canvas( @Nullable final ReactNode... children )
  {
    return createElement( "canvas", null, children );
  }

  @Nonnull
  public static ReactNode canvas( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return createElement( "canvas", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode canvas( @Nonnull final String content )
  {
    return canvas( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode canvas( final byte content )
  {
    return canvas( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode canvas( final short content )
  {
    return canvas( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode canvas( final int content )
  {
    return canvas( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode canvas( final long content )
  {
    return canvas( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode canvas( final float content )
  {
    return canvas( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode canvas( final double content )
  {
    return canvas( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode canvas( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return canvas( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode canvas( @Nonnull final Stream<? extends ReactNode> children )
  {
    return canvas( toArray( children ) );
  }

  @Nonnull
  public static ReactNode caption()
  {
    return createElement( "caption", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode caption( @Nonnull final HtmlProps props )
  {
    return createElement( "caption", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode caption( @Nonnull final HtmlProps props, @Nullable final ReactNode... children )
  {
    return createElement( "caption", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode caption( @Nullable final ReactNode... children )
  {
    return createElement( "caption", null, children );
  }

  @Nonnull
  public static ReactNode caption( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return createElement( "caption", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode caption( @Nonnull final String content )
  {
    return caption( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode caption( final byte content )
  {
    return caption( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode caption( final short content )
  {
    return caption( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode caption( final int content )
  {
    return caption( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode caption( final long content )
  {
    return caption( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode caption( final float content )
  {
    return caption( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode caption( final double content )
  {
    return caption( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode caption( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return caption( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode caption( @Nonnull final Stream<? extends ReactNode> children )
  {
    return caption( toArray( children ) );
  }

  @Nonnull
  public static ReactNode col()
  {
    return createElement( "col", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode col( @Nonnull final ColProps props )
  {
    return createElement( "col", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode colgroup()
  {
    return createElement( "colgroup", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode colgroup( @Nonnull final HtmlProps props )
  {
    return createElement( "colgroup", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode colgroup( @Nonnull final HtmlProps props, @Nullable final ReactNode... children )
  {
    return createElement( "colgroup", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode colgroup( @Nullable final ReactNode... children )
  {
    return createElement( "colgroup", null, children );
  }

  @Nonnull
  public static ReactNode colgroup( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return createElement( "colgroup", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode colgroup( @Nonnull final String content )
  {
    return colgroup( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode colgroup( final byte content )
  {
    return colgroup( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode colgroup( final short content )
  {
    return colgroup( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode colgroup( final int content )
  {
    return colgroup( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode colgroup( final long content )
  {
    return colgroup( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode colgroup( final float content )
  {
    return colgroup( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode colgroup( final double content )
  {
    return colgroup( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode colgroup( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return colgroup( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode colgroup( @Nonnull final Stream<? extends ReactNode> children )
  {
    return colgroup( toArray( children ) );
  }

  @Nonnull
  public static ReactNode div()
  {
    return createElement( "div", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode div( @Nonnull final HtmlProps props )
  {
    return createElement( "div", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode div( @Nonnull final HtmlProps props, @Nullable final ReactNode... children )
  {
    return createElement( "div", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode div( @Nullable final ReactNode... children )
  {
    return createElement( "div", null, children );
  }

  @Nonnull
  public static ReactNode div( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return createElement( "div", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode div( @Nonnull final String content )
  {
    return div( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode div( final byte content )
  {
    return div( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode div( final short content )
  {
    return div( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode div( final int content )
  {
    return div( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode div( final long content )
  {
    return div( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode div( final float content )
  {
    return div( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode div( final double content )
  {
    return div( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode div( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return div( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode div( @Nonnull final Stream<? extends ReactNode> children )
  {
    return div( toArray( children ) );
  }

  @Nonnull
  public static ReactNode footer()
  {
    return createElement( "footer", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode footer( @Nonnull final HtmlProps props )
  {
    return createElement( "footer", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode footer( @Nonnull final HtmlProps props, @Nullable final ReactNode... children )
  {
    return createElement( "footer", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode footer( @Nullable final ReactNode... children )
  {
    return createElement( "footer", null, children );
  }

  @Nonnull
  public static ReactNode footer( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return createElement( "footer", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode footer( @Nonnull final String content )
  {
    return footer( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode footer( final byte content )
  {
    return footer( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode footer( final short content )
  {
    return footer( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode footer( final int content )
  {
    return footer( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode footer( final long content )
  {
    return footer( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode footer( final float content )
  {
    return footer( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode footer( final double content )
  {
    return footer( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode footer( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return footer( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode footer( @Nonnull final Stream<? extends ReactNode> children )
  {
    return footer( toArray( children ) );
  }

  @Nonnull
  public static ReactNode form()
  {
    return createElement( "form", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode form( @Nonnull final FormProps props )
  {
    return createElement( "form", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode form( @Nonnull final FormProps props, @Nullable final ReactNode... children )
  {
    return createElement( "form", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode form( @Nullable final ReactNode... children )
  {
    return createElement( "form", null, children );
  }

  @Nonnull
  public static ReactNode form( @Nonnull final FormProps props, @Nonnull final String content )
  {
    return createElement( "form", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode form( @Nonnull final String content )
  {
    return form( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode form( final byte content )
  {
    return form( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode form( final short content )
  {
    return form( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode form( final int content )
  {
    return form( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode form( final long content )
  {
    return form( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode form( final float content )
  {
    return form( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode form( final double content )
  {
    return form( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode form( @Nonnull final FormProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return form( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode form( @Nonnull final Stream<? extends ReactNode> children )
  {
    return form( toArray( children ) );
  }

  @Nonnull
  public static ReactNode header()
  {
    return createElement( "header", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode header( @Nonnull final HtmlProps props )
  {
    return createElement( "header", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode header( @Nonnull final HtmlProps props, @Nullable final ReactNode... children )
  {
    return createElement( "header", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode header( @Nullable final ReactNode... children )
  {
    return createElement( "header", null, children );
  }

  @Nonnull
  public static ReactNode header( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return createElement( "header", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode header( @Nonnull final String content )
  {
    return header( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode header( final byte content )
  {
    return header( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode header( final short content )
  {
    return header( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode header( final int content )
  {
    return header( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode header( final long content )
  {
    return header( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode header( final float content )
  {
    return header( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode header( final double content )
  {
    return header( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode header( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return header( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode header( @Nonnull final Stream<? extends ReactNode> children )
  {
    return header( toArray( children ) );
  }

  @Nonnull
  public static ReactNode h1()
  {
    return createElement( "h1", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode h1( @Nonnull final HtmlProps props )
  {
    return createElement( "h1", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode h1( @Nonnull final HtmlProps props, @Nullable final ReactNode... children )
  {
    return createElement( "h1", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode h1( @Nullable final ReactNode... children )
  {
    return createElement( "h1", null, children );
  }

  @Nonnull
  public static ReactNode h1( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return createElement( "h1", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode h1( @Nonnull final String content )
  {
    return h1( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h1( final byte content )
  {
    return h1( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h1( final short content )
  {
    return h1( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h1( final int content )
  {
    return h1( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h1( final long content )
  {
    return h1( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h1( final float content )
  {
    return h1( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h1( final double content )
  {
    return h1( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h1( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return h1( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode h1( @Nonnull final Stream<? extends ReactNode> children )
  {
    return h1( toArray( children ) );
  }

  @Nonnull
  public static ReactNode h2()
  {
    return createElement( "h2", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode h2( @Nonnull final HtmlProps props )
  {
    return createElement( "h2", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode h2( @Nonnull final HtmlProps props, @Nullable final ReactNode... children )
  {
    return createElement( "h2", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode h2( @Nullable final ReactNode... children )
  {
    return createElement( "h2", null, children );
  }

  @Nonnull
  public static ReactNode h2( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return createElement( "h2", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode h2( @Nonnull final String content )
  {
    return h2( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h2( final byte content )
  {
    return h2( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h2( final short content )
  {
    return h2( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h2( final int content )
  {
    return h2( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h2( final long content )
  {
    return h2( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h2( final float content )
  {
    return h2( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h2( final double content )
  {
    return h2( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h2( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return h2( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode h2( @Nonnull final Stream<? extends ReactNode> children )
  {
    return h2( toArray( children ) );
  }

  @Nonnull
  public static ReactNode h3()
  {
    return createElement( "h3", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode h3( @Nonnull final HtmlProps props )
  {
    return createElement( "h3", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode h3( @Nonnull final HtmlProps props, @Nullable final ReactNode... children )
  {
    return createElement( "h3", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode h3( @Nullable final ReactNode... children )
  {
    return createElement( "h3", null, children );
  }

  @Nonnull
  public static ReactNode h3( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return createElement( "h3", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode h3( @Nonnull final String content )
  {
    return h3( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h3( final byte content )
  {
    return h3( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h3( final short content )
  {
    return h3( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h3( final int content )
  {
    return h3( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h3( final long content )
  {
    return h3( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h3( final float content )
  {
    return h3( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h3( final double content )
  {
    return h3( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h3( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return h3( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode h3( @Nonnull final Stream<? extends ReactNode> children )
  {
    return h3( toArray( children ) );
  }

  @Nonnull
  public static ReactNode h4()
  {
    return createElement( "h4", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode h4( @Nonnull final HtmlProps props )
  {
    return createElement( "h4", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode h4( @Nonnull final HtmlProps props, @Nullable final ReactNode... children )
  {
    return createElement( "h4", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode h4( @Nullable final ReactNode... children )
  {
    return createElement( "h4", null, children );
  }

  @Nonnull
  public static ReactNode h4( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return createElement( "h4", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode h4( @Nonnull final String content )
  {
    return h4( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h4( final byte content )
  {
    return h4( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h4( final short content )
  {
    return h4( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h4( final int content )
  {
    return h4( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h4( final long content )
  {
    return h4( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h4( final float content )
  {
    return h4( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h4( final double content )
  {
    return h4( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h4( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return h4( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode h4( @Nonnull final Stream<? extends ReactNode> children )
  {
    return h4( toArray( children ) );
  }

  @Nonnull
  public static ReactNode h5()
  {
    return createElement( "h5", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode h5( @Nonnull final HtmlProps props )
  {
    return createElement( "h5", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode h5( @Nonnull final HtmlProps props, @Nullable final ReactNode... children )
  {
    return createElement( "h5", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode h5( @Nullable final ReactNode... children )
  {
    return createElement( "h5", null, children );
  }

  @Nonnull
  public static ReactNode h5( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return createElement( "h5", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode h5( @Nonnull final String content )
  {
    return h5( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h5( final byte content )
  {
    return h5( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h5( final short content )
  {
    return h5( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h5( final int content )
  {
    return h5( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h5( final long content )
  {
    return h5( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h5( final float content )
  {
    return h5( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h5( final double content )
  {
    return h5( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h5( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return h5( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode h5( @Nonnull final Stream<? extends ReactNode> children )
  {
    return h5( toArray( children ) );
  }

  @Nonnull
  public static ReactNode h6()
  {
    return createElement( "h6", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode h6( @Nonnull final HtmlProps props )
  {
    return createElement( "h6", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode h6( @Nonnull final HtmlProps props, @Nullable final ReactNode... children )
  {
    return createElement( "h6", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode h6( @Nullable final ReactNode... children )
  {
    return createElement( "h6", null, children );
  }

  @Nonnull
  public static ReactNode h6( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return createElement( "h6", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode h6( @Nonnull final String content )
  {
    return h6( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h6( final byte content )
  {
    return h6( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h6( final short content )
  {
    return h6( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h6( final int content )
  {
    return h6( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h6( final long content )
  {
    return h6( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h6( final float content )
  {
    return h6( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h6( final double content )
  {
    return h6( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode h6( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return h6( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode h6( @Nonnull final Stream<? extends ReactNode> children )
  {
    return h6( toArray( children ) );
  }

  @Nonnull
  public static ReactNode i()
  {
    return createElement( "i", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode i( @Nonnull final HtmlProps props )
  {
    return createElement( "i", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode i( @Nonnull final HtmlProps props, @Nullable final ReactNode... children )
  {
    return createElement( "i", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode i( @Nullable final ReactNode... children )
  {
    return createElement( "i", null, children );
  }

  @Nonnull
  public static ReactNode i( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return createElement( "i", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode i( @Nonnull final String content )
  {
    return i( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode i( final byte content )
  {
    return i( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode i( final short content )
  {
    return i( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode i( final int content )
  {
    return i( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode i( final long content )
  {
    return i( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode i( final float content )
  {
    return i( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode i( final double content )
  {
    return i( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode i( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return i( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode i( @Nonnull final Stream<? extends ReactNode> children )
  {
    return i( toArray( children ) );
  }

  @Nonnull
  public static ReactNode iframe()
  {
    return createElement( "iframe", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode iframe( @Nonnull final IFrameProps props )
  {
    return createElement( "iframe", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode iframe( @Nonnull final IFrameProps props, @Nullable final ReactNode... children )
  {
    return createElement( "iframe", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode iframe( @Nullable final ReactNode... children )
  {
    return createElement( "iframe", null, children );
  }

  @Nonnull
  public static ReactNode iframe( @Nonnull final IFrameProps props, @Nonnull final String content )
  {
    return createElement( "iframe", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode iframe( @Nonnull final String content )
  {
    return iframe( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode iframe( final byte content )
  {
    return iframe( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode iframe( final short content )
  {
    return iframe( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode iframe( final int content )
  {
    return iframe( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode iframe( final long content )
  {
    return iframe( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode iframe( final float content )
  {
    return iframe( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode iframe( final double content )
  {
    return iframe( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode iframe( @Nonnull final IFrameProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return iframe( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode iframe( @Nonnull final Stream<? extends ReactNode> children )
  {
    return iframe( toArray( children ) );
  }

  @Nonnull
  public static ReactNode img()
  {
    return createElement( "img", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode img( @Nonnull final ImgProps props )
  {
    return createElement( "img", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode input()
  {
    return createElement( "input", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode input( @Nonnull final InputProps props )
  {
    return createElement( "input", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode label()
  {
    return createElement( "label", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode label( @Nonnull final LabelProps props )
  {
    return createElement( "label", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode label( @Nonnull final LabelProps props, @Nullable final ReactNode... children )
  {
    return createElement( "label", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode label( @Nullable final ReactNode... children )
  {
    return createElement( "label", null, children );
  }

  @Nonnull
  public static ReactNode label( @Nonnull final LabelProps props, @Nonnull final String content )
  {
    return createElement( "label", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode label( @Nonnull final String content )
  {
    return label( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode label( final byte content )
  {
    return label( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode label( final short content )
  {
    return label( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode label( final int content )
  {
    return label( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode label( final long content )
  {
    return label( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode label( final float content )
  {
    return label( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode label( final double content )
  {
    return label( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode label( @Nonnull final LabelProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return label( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode label( @Nonnull final Stream<? extends ReactNode> children )
  {
    return label( toArray( children ) );
  }

  @Nonnull
  public static ReactNode li()
  {
    return createElement( "li", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode li( @Nonnull final HtmlProps props )
  {
    return createElement( "li", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode li( @Nonnull final HtmlProps props, @Nullable final ReactNode... children )
  {
    return createElement( "li", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode li( @Nullable final ReactNode... children )
  {
    return createElement( "li", null, children );
  }

  @Nonnull
  public static ReactNode li( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return createElement( "li", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode li( @Nonnull final String content )
  {
    return li( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode li( final byte content )
  {
    return li( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode li( final short content )
  {
    return li( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode li( final int content )
  {
    return li( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode li( final long content )
  {
    return li( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode li( final float content )
  {
    return li( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode li( final double content )
  {
    return li( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode li( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return li( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode li( @Nonnull final Stream<? extends ReactNode> children )
  {
    return li( toArray( children ) );
  }

  @Nonnull
  public static ReactNode ol()
  {
    return createElement( "ol", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode ol( @Nonnull final HtmlProps props )
  {
    return createElement( "ol", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode ol( @Nonnull final HtmlProps props, @Nullable final ReactNode... children )
  {
    return createElement( "ol", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode ol( @Nullable final ReactNode... children )
  {
    return createElement( "ol", null, children );
  }

  @Nonnull
  public static ReactNode ol( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return createElement( "ol", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode ol( @Nonnull final String content )
  {
    return ol( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode ol( final byte content )
  {
    return ol( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode ol( final short content )
  {
    return ol( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode ol( final int content )
  {
    return ol( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode ol( final long content )
  {
    return ol( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode ol( final float content )
  {
    return ol( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode ol( final double content )
  {
    return ol( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode ol( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return ol( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode ol( @Nonnull final Stream<? extends ReactNode> children )
  {
    return ol( toArray( children ) );
  }

  @Nonnull
  public static ReactNode option()
  {
    return createElement( "option", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode option( @Nonnull final OptionProps props )
  {
    return createElement( "option", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode option( @Nonnull final OptionProps props, @Nullable final ReactNode... children )
  {
    return createElement( "option", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode option( @Nullable final ReactNode... children )
  {
    return createElement( "option", null, children );
  }

  @Nonnull
  public static ReactNode option( @Nonnull final OptionProps props, @Nonnull final String content )
  {
    return createElement( "option", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode option( @Nonnull final String content )
  {
    return option( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode option( final byte content )
  {
    return option( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode option( final short content )
  {
    return option( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode option( final int content )
  {
    return option( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode option( final long content )
  {
    return option( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode option( final float content )
  {
    return option( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode option( final double content )
  {
    return option( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode option( @Nonnull final OptionProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return option( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode option( @Nonnull final Stream<? extends ReactNode> children )
  {
    return option( toArray( children ) );
  }

  @Nonnull
  public static ReactNode optgroup()
  {
    return createElement( "optgroup", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode optgroup( @Nonnull final OptGroupProps props )
  {
    return createElement( "optgroup", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode optgroup( @Nonnull final OptGroupProps props, @Nullable final ReactNode... children )
  {
    return createElement( "optgroup", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode optgroup( @Nullable final ReactNode... children )
  {
    return createElement( "optgroup", null, children );
  }

  @Nonnull
  public static ReactNode optgroup( @Nonnull final OptGroupProps props, @Nonnull final String content )
  {
    return createElement( "optgroup", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode optgroup( @Nonnull final String content )
  {
    return optgroup( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode optgroup( final byte content )
  {
    return optgroup( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode optgroup( final short content )
  {
    return optgroup( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode optgroup( final int content )
  {
    return optgroup( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode optgroup( final long content )
  {
    return optgroup( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode optgroup( final float content )
  {
    return optgroup( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode optgroup( final double content )
  {
    return optgroup( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode optgroup( @Nonnull final OptGroupProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return optgroup( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode optgroup( @Nonnull final Stream<? extends ReactNode> children )
  {
    return optgroup( toArray( children ) );
  }

  @Nonnull
  public static ReactNode p()
  {
    return createElement( "p", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode p( @Nonnull final HtmlProps props )
  {
    return createElement( "p", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode p( @Nonnull final HtmlProps props, @Nullable final ReactNode... children )
  {
    return createElement( "p", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode p( @Nullable final ReactNode... children )
  {
    return createElement( "p", null, children );
  }

  @Nonnull
  public static ReactNode p( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return createElement( "p", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode p( @Nonnull final String content )
  {
    return p( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode p( final byte content )
  {
    return p( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode p( final short content )
  {
    return p( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode p( final int content )
  {
    return p( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode p( final long content )
  {
    return p( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode p( final float content )
  {
    return p( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode p( final double content )
  {
    return p( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode p( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return p( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode p( @Nonnull final Stream<? extends ReactNode> children )
  {
    return p( toArray( children ) );
  }

  @Nonnull
  public static ReactNode span()
  {
    return createElement( "span", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode span( @Nonnull final HtmlProps props )
  {
    return createElement( "span", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode span( @Nonnull final HtmlProps props, @Nullable final ReactNode... children )
  {
    return createElement( "span", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode span( @Nullable final ReactNode... children )
  {
    return createElement( "span", null, children );
  }

  @Nonnull
  public static ReactNode span( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return createElement( "span", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode span( @Nonnull final String content )
  {
    return span( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode span( final byte content )
  {
    return span( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode span( final short content )
  {
    return span( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode span( final int content )
  {
    return span( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode span( final long content )
  {
    return span( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode span( final float content )
  {
    return span( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode span( final double content )
  {
    return span( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode span( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return span( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode span( @Nonnull final Stream<? extends ReactNode> children )
  {
    return span( toArray( children ) );
  }

  @Nonnull
  public static ReactNode select()
  {
    return createElement( "select", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode select( @Nonnull final SelectProps props )
  {
    return createElement( "select", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode select( @Nonnull final SelectProps props, @Nullable final ReactNode... children )
  {
    return createElement( "select", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode select( @Nullable final ReactNode... children )
  {
    return createElement( "select", null, children );
  }

  @Nonnull
  public static ReactNode select( @Nonnull final SelectProps props, @Nonnull final String content )
  {
    return createElement( "select", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode select( @Nonnull final String content )
  {
    return select( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode select( final byte content )
  {
    return select( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode select( final short content )
  {
    return select( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode select( final int content )
  {
    return select( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode select( final long content )
  {
    return select( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode select( final float content )
  {
    return select( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode select( final double content )
  {
    return select( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode select( @Nonnull final SelectProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return select( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode select( @Nonnull final Stream<? extends ReactNode> children )
  {
    return select( toArray( children ) );
  }

  @Nonnull
  public static ReactNode section()
  {
    return createElement( "section", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode section( @Nonnull final HtmlProps props )
  {
    return createElement( "section", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode section( @Nonnull final HtmlProps props, @Nullable final ReactNode... children )
  {
    return createElement( "section", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode section( @Nullable final ReactNode... children )
  {
    return createElement( "section", null, children );
  }

  @Nonnull
  public static ReactNode section( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return createElement( "section", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode section( @Nonnull final String content )
  {
    return section( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode section( final byte content )
  {
    return section( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode section( final short content )
  {
    return section( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode section( final int content )
  {
    return section( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode section( final long content )
  {
    return section( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode section( final float content )
  {
    return section( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode section( final double content )
  {
    return section( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode section( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return section( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode section( @Nonnull final Stream<? extends ReactNode> children )
  {
    return section( toArray( children ) );
  }

  @Nonnull
  public static ReactNode strong()
  {
    return createElement( "strong", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode strong( @Nonnull final HtmlProps props )
  {
    return createElement( "strong", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode strong( @Nonnull final HtmlProps props, @Nullable final ReactNode... children )
  {
    return createElement( "strong", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode strong( @Nullable final ReactNode... children )
  {
    return createElement( "strong", null, children );
  }

  @Nonnull
  public static ReactNode strong( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return createElement( "strong", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode strong( @Nonnull final String content )
  {
    return strong( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode strong( final byte content )
  {
    return strong( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode strong( final short content )
  {
    return strong( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode strong( final int content )
  {
    return strong( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode strong( final long content )
  {
    return strong( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode strong( final float content )
  {
    return strong( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode strong( final double content )
  {
    return strong( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode strong( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return strong( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode strong( @Nonnull final Stream<? extends ReactNode> children )
  {
    return strong( toArray( children ) );
  }

  @Nonnull
  public static ReactNode source()
  {
    return createElement( "source", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode source( @Nonnull final SourceProps props )
  {
    return createElement( "source", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode table()
  {
    return createElement( "table", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode table( @Nonnull final HtmlProps props )
  {
    return createElement( "table", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode table( @Nonnull final HtmlProps props, @Nullable final ReactNode... children )
  {
    return createElement( "table", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode table( @Nullable final ReactNode... children )
  {
    return createElement( "table", null, children );
  }

  @Nonnull
  public static ReactNode table( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return createElement( "table", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode table( @Nonnull final String content )
  {
    return table( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode table( final byte content )
  {
    return table( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode table( final short content )
  {
    return table( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode table( final int content )
  {
    return table( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode table( final long content )
  {
    return table( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode table( final float content )
  {
    return table( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode table( final double content )
  {
    return table( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode table( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return table( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode table( @Nonnull final Stream<? extends ReactNode> children )
  {
    return table( toArray( children ) );
  }

  @Nonnull
  public static ReactNode textarea()
  {
    return createElement( "textarea", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode textarea( @Nonnull final TextAreaProps props )
  {
    return createElement( "textarea", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode tbody()
  {
    return createElement( "tbody", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode tbody( @Nonnull final HtmlProps props )
  {
    return createElement( "tbody", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode tbody( @Nonnull final HtmlProps props, @Nullable final ReactNode... children )
  {
    return createElement( "tbody", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode tbody( @Nullable final ReactNode... children )
  {
    return createElement( "tbody", null, children );
  }

  @Nonnull
  public static ReactNode tbody( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return createElement( "tbody", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode tbody( @Nonnull final String content )
  {
    return tbody( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode tbody( final byte content )
  {
    return tbody( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode tbody( final short content )
  {
    return tbody( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode tbody( final int content )
  {
    return tbody( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode tbody( final long content )
  {
    return tbody( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode tbody( final float content )
  {
    return tbody( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode tbody( final double content )
  {
    return tbody( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode tbody( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return tbody( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode tbody( @Nonnull final Stream<? extends ReactNode> children )
  {
    return tbody( toArray( children ) );
  }

  @Nonnull
  public static ReactNode td()
  {
    return createElement( "td", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode td( @Nonnull final TdProps props )
  {
    return createElement( "td", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode td( @Nonnull final TdProps props, @Nullable final ReactNode... children )
  {
    return createElement( "td", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode td( @Nullable final ReactNode... children )
  {
    return createElement( "td", null, children );
  }

  @Nonnull
  public static ReactNode td( @Nonnull final TdProps props, @Nonnull final String content )
  {
    return createElement( "td", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode td( @Nonnull final String content )
  {
    return td( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode td( final byte content )
  {
    return td( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode td( final short content )
  {
    return td( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode td( final int content )
  {
    return td( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode td( final long content )
  {
    return td( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode td( final float content )
  {
    return td( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode td( final double content )
  {
    return td( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode td( @Nonnull final TdProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return td( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode td( @Nonnull final Stream<? extends ReactNode> children )
  {
    return td( toArray( children ) );
  }

  @Nonnull
  public static ReactNode th()
  {
    return createElement( "th", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode th( @Nonnull final ThProps props )
  {
    return createElement( "th", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode th( @Nonnull final ThProps props, @Nullable final ReactNode... children )
  {
    return createElement( "th", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode th( @Nullable final ReactNode... children )
  {
    return createElement( "th", null, children );
  }

  @Nonnull
  public static ReactNode th( @Nonnull final ThProps props, @Nonnull final String content )
  {
    return createElement( "th", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode th( @Nonnull final String content )
  {
    return th( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode th( final byte content )
  {
    return th( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode th( final short content )
  {
    return th( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode th( final int content )
  {
    return th( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode th( final long content )
  {
    return th( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode th( final float content )
  {
    return th( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode th( final double content )
  {
    return th( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode th( @Nonnull final ThProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return th( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode th( @Nonnull final Stream<? extends ReactNode> children )
  {
    return th( toArray( children ) );
  }

  @Nonnull
  public static ReactNode thead()
  {
    return createElement( "thead", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode thead( @Nonnull final HtmlProps props )
  {
    return createElement( "thead", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode thead( @Nonnull final HtmlProps props, @Nullable final ReactNode... children )
  {
    return createElement( "thead", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode thead( @Nullable final ReactNode... children )
  {
    return createElement( "thead", null, children );
  }

  @Nonnull
  public static ReactNode thead( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return createElement( "thead", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode thead( @Nonnull final String content )
  {
    return thead( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode thead( final byte content )
  {
    return thead( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode thead( final short content )
  {
    return thead( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode thead( final int content )
  {
    return thead( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode thead( final long content )
  {
    return thead( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode thead( final float content )
  {
    return thead( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode thead( final double content )
  {
    return thead( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode thead( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return thead( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode thead( @Nonnull final Stream<? extends ReactNode> children )
  {
    return thead( toArray( children ) );
  }

  @Nonnull
  public static ReactNode tr()
  {
    return createElement( "tr", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode tr( @Nonnull final HtmlProps props )
  {
    return createElement( "tr", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode tr( @Nonnull final HtmlProps props, @Nullable final ReactNode... children )
  {
    return createElement( "tr", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode tr( @Nullable final ReactNode... children )
  {
    return createElement( "tr", null, children );
  }

  @Nonnull
  public static ReactNode tr( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return createElement( "tr", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode tr( @Nonnull final String content )
  {
    return tr( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode tr( final byte content )
  {
    return tr( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode tr( final short content )
  {
    return tr( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode tr( final int content )
  {
    return tr( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode tr( final long content )
  {
    return tr( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode tr( final float content )
  {
    return tr( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode tr( final double content )
  {
    return tr( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode tr( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return tr( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode tr( @Nonnull final Stream<? extends ReactNode> children )
  {
    return tr( toArray( children ) );
  }

  @Nonnull
  public static ReactNode ul()
  {
    return createElement( "ul", null, (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode ul( @Nonnull final HtmlProps props )
  {
    return createElement( "ul", Js.asPropertyMap( props ), (ReactNode[]) null );
  }

  @Nonnull
  public static ReactNode ul( @Nonnull final HtmlProps props, @Nullable final ReactNode... children )
  {
    return createElement( "ul", Js.asPropertyMap( props ), children );
  }

  @Nonnull
  public static ReactNode ul( @Nullable final ReactNode... children )
  {
    return createElement( "ul", null, children );
  }

  @Nonnull
  public static ReactNode ul( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return createElement( "ul", Js.asPropertyMap( props ), text( content ) );
  }

  @Nonnull
  public static ReactNode ul( @Nonnull final String content )
  {
    return ul( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode ul( final byte content )
  {
    return ul( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode ul( final short content )
  {
    return ul( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode ul( final int content )
  {
    return ul( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode ul( final long content )
  {
    return ul( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode ul( final float content )
  {
    return ul( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode ul( final double content )
  {
    return ul( ReactNode.of( content ) );
  }

  @Nonnull
  public static ReactNode ul( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return ul( props, toArray( children ) );
  }

  @Nonnull
  public static ReactNode ul( @Nonnull final Stream<? extends ReactNode> children )
  {
    return ul( toArray( children ) );
  }

  /**
   * Create and return a new ReactElement of the given type with specified children.
   *
   * @param type     A HTML tag name (eg. 'div', 'span', etc)
   * @param props    The props to pass to the element.
   * @param children The child elements.
   * @return the created ReactElement
   */
  @Nonnull
  private static ReactElement createElement( @Nonnull final String type, @Nullable final JsPropertyMap<Object> props, @Nullable final ReactNode... children )
  {
    final JsPropertyMap<Object> actual = JsPropertyMap.of();
    String key = null;
    Object ref = null;
    if ( null != props )
    {
      key = props.has( "key" ) ? Js.asString( props.get( "key" ) ) : null;
      ref = props.has( "ref" ) ? props.get( "ref" ) : null;
      props.forEach( p -> {
        // In future we can probably remove this check when/if components are creating elements directly
        // and can thus guarantee that these keys are not part of props.
        if ( !p.equals( "key" ) && !p.equals( "ref" ) )
        {
          actual.set( p, props.get( p ) );
        }
      } );
    }
    // In a future iteration if we re-write the reconciler we should probably ensure that shape of ReactElement
    // is always consistent and is either null or always an array element.
    if ( null != children && children.length > 0 )
    {
      if ( 1 == children.length )
      {
        actual.set( "children", children[ 0 ] );
      }
      else
      {
        actual.set( "children", children );
      }
    }
    return ReactElement.createHostElement( type, key, ref, actual );
  }

  @Nonnull
  private static ReactNode[] toArray( @Nonnull final Stream<? extends ReactNode> children )
  {
    return Objects.requireNonNull( children ).toArray( ReactNode[]::new );
  }
}
