package react4j.dom;

import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jsinterop.base.Js;
import react4j.core.ReactNode;
import react4j.dom.proptypes.html.AnchorProps;
import react4j.dom.proptypes.html.AudioProps;
import react4j.dom.proptypes.html.BtnProps;
import react4j.dom.proptypes.html.ColProps;
import react4j.dom.proptypes.html.FormProps;
import react4j.dom.proptypes.html.HtmlProps;
import react4j.dom.proptypes.html.IFrameProps;
import react4j.dom.proptypes.html.ImgProps;
import react4j.dom.proptypes.html.InputProps;
import react4j.dom.proptypes.html.LabelProps;
import react4j.dom.proptypes.html.OptGroupProps;
import react4j.dom.proptypes.html.OptionProps;
import react4j.dom.proptypes.html.SelectProps;
import react4j.dom.proptypes.html.SourceProps;
import react4j.dom.proptypes.html.TdProps;
import react4j.dom.proptypes.html.TextAreaProps;
import react4j.dom.proptypes.html.ThProps;

/**
 * DOM provides convenience wrappers around React.createElement for DOM components.
 */
@Generated( "GwtReact" )
public final class DOM
{
  private DOM()
  {
  }

  @Nonnull
  public static ReactNode text( @Nonnull final String content )
  {
    return ReactNode.of( content );
  }


  @Nonnull
  public static ReactNode a( @Nonnull final AnchorProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "a", props, child );
  }

  @Nonnull
  public static ReactNode a( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "a", null, child );
  }

  @Nonnull
  public static ReactNode a( @Nonnull final AnchorProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "a", props, text( content ) );
  }

  @Nonnull
  public static ReactNode a( @Nonnull final AnchorProps props )
  {
    return ReactDOM.createElement( "a", props );
  }

  @Nonnull
  public static ReactNode a( @Nonnull final String content )
  {
    return ReactDOM.createElement( "a", null, text( content ) );
  }

  @Nonnull
  public static ReactNode a()
  {
    return ReactDOM.createElement( "a", null );
  }

  @Nonnull
  public static ReactNode a( @Nonnull final AnchorProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return a( props, children.stream() );
  }

  @Nonnull
  public static ReactNode a( @Nonnull final AnchorProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return a( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode article( @Nonnull final HtmlProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "article", props, child );
  }

  @Nonnull
  public static ReactNode article( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "article", null, child );
  }

  @Nonnull
  public static ReactNode article( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "article", props, text( content ) );
  }

  @Nonnull
  public static ReactNode article( @Nonnull final HtmlProps props )
  {
    return ReactDOM.createElement( "article", props );
  }

  @Nonnull
  public static ReactNode article( @Nonnull final String content )
  {
    return ReactDOM.createElement( "article", null, text( content ) );
  }

  @Nonnull
  public static ReactNode article()
  {
    return ReactDOM.createElement( "article", null );
  }

  @Nonnull
  public static ReactNode article( @Nonnull final HtmlProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return article( props, children.stream() );
  }

  @Nonnull
  public static ReactNode article( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return article( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode audio( @Nonnull final AudioProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "audio", props, child );
  }

  @Nonnull
  public static ReactNode audio( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "audio", null, child );
  }

  @Nonnull
  public static ReactNode audio( @Nonnull final AudioProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "audio", props, text( content ) );
  }

  @Nonnull
  public static ReactNode audio( @Nonnull final AudioProps props )
  {
    return ReactDOM.createElement( "audio", props );
  }

  @Nonnull
  public static ReactNode audio( @Nonnull final String content )
  {
    return ReactDOM.createElement( "audio", null, text( content ) );
  }

  @Nonnull
  public static ReactNode audio()
  {
    return ReactDOM.createElement( "audio", null );
  }

  @Nonnull
  public static ReactNode audio( @Nonnull final AudioProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return audio( props, children.stream() );
  }

  @Nonnull
  public static ReactNode audio( @Nonnull final AudioProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return audio( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode br( @Nonnull final HtmlProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "br", props, child );
  }

  @Nonnull
  public static ReactNode br( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "br", null, child );
  }

  @Nonnull
  public static ReactNode br( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "br", props, text( content ) );
  }

  @Nonnull
  public static ReactNode br( @Nonnull final HtmlProps props )
  {
    return ReactDOM.createElement( "br", props );
  }

  @Nonnull
  public static ReactNode br( @Nonnull final String content )
  {
    return ReactDOM.createElement( "br", null, text( content ) );
  }

  @Nonnull
  public static ReactNode br()
  {
    return ReactDOM.createElement( "br", null );
  }

  @Nonnull
  public static ReactNode br( @Nonnull final HtmlProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return br( props, children.stream() );
  }

  @Nonnull
  public static ReactNode br( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return br( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode button( @Nonnull final BtnProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "button", props, child );
  }

  @Nonnull
  public static ReactNode button( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "button", null, child );
  }

  @Nonnull
  public static ReactNode button( @Nonnull final BtnProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "button", props, text( content ) );
  }

  @Nonnull
  public static ReactNode button( @Nonnull final BtnProps props )
  {
    return ReactDOM.createElement( "button", props );
  }

  @Nonnull
  public static ReactNode button( @Nonnull final String content )
  {
    return ReactDOM.createElement( "button", null, text( content ) );
  }

  @Nonnull
  public static ReactNode button()
  {
    return ReactDOM.createElement( "button", null );
  }

  @Nonnull
  public static ReactNode button( @Nonnull final BtnProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return button( props, children.stream() );
  }

  @Nonnull
  public static ReactNode button( @Nonnull final BtnProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return button( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode canvas( @Nonnull final HtmlProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "canvas", props, child );
  }

  @Nonnull
  public static ReactNode canvas( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "canvas", null, child );
  }

  @Nonnull
  public static ReactNode canvas( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "canvas", props, text( content ) );
  }

  @Nonnull
  public static ReactNode canvas( @Nonnull final HtmlProps props )
  {
    return ReactDOM.createElement( "canvas", props );
  }

  @Nonnull
  public static ReactNode canvas( @Nonnull final String content )
  {
    return ReactDOM.createElement( "canvas", null, text( content ) );
  }

  @Nonnull
  public static ReactNode canvas()
  {
    return ReactDOM.createElement( "canvas", null );
  }

  @Nonnull
  public static ReactNode canvas( @Nonnull final HtmlProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return canvas( props, children.stream() );
  }

  @Nonnull
  public static ReactNode canvas( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return canvas( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode caption( @Nonnull final HtmlProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "caption", props, child );
  }

  @Nonnull
  public static ReactNode caption( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "caption", null, child );
  }

  @Nonnull
  public static ReactNode caption( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "caption", props, text( content ) );
  }

  @Nonnull
  public static ReactNode caption( @Nonnull final HtmlProps props )
  {
    return ReactDOM.createElement( "caption", props );
  }

  @Nonnull
  public static ReactNode caption( @Nonnull final String content )
  {
    return ReactDOM.createElement( "caption", null, text( content ) );
  }

  @Nonnull
  public static ReactNode caption()
  {
    return ReactDOM.createElement( "caption", null );
  }

  @Nonnull
  public static ReactNode caption( @Nonnull final HtmlProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return caption( props, children.stream() );
  }

  @Nonnull
  public static ReactNode caption( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return caption( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode col( @Nonnull final ColProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "col", props, child );
  }

  @Nonnull
  public static ReactNode col( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "col", null, child );
  }

  @Nonnull
  public static ReactNode col( @Nonnull final ColProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "col", props, text( content ) );
  }

  @Nonnull
  public static ReactNode col( @Nonnull final ColProps props )
  {
    return ReactDOM.createElement( "col", props );
  }

  @Nonnull
  public static ReactNode col( @Nonnull final String content )
  {
    return ReactDOM.createElement( "col", null, text( content ) );
  }

  @Nonnull
  public static ReactNode col()
  {
    return ReactDOM.createElement( "col", null );
  }

  @Nonnull
  public static ReactNode col( @Nonnull final ColProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return col( props, children.stream() );
  }

  @Nonnull
  public static ReactNode col( @Nonnull final ColProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return col( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode colgroup( @Nonnull final HtmlProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "colgroup", props, child );
  }

  @Nonnull
  public static ReactNode colgroup( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "colgroup", null, child );
  }

  @Nonnull
  public static ReactNode colgroup( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "colgroup", props, text( content ) );
  }

  @Nonnull
  public static ReactNode colgroup( @Nonnull final HtmlProps props )
  {
    return ReactDOM.createElement( "colgroup", props );
  }

  @Nonnull
  public static ReactNode colgroup( @Nonnull final String content )
  {
    return ReactDOM.createElement( "colgroup", null, text( content ) );
  }

  @Nonnull
  public static ReactNode colgroup()
  {
    return ReactDOM.createElement( "colgroup", null );
  }

  @Nonnull
  public static ReactNode colgroup( @Nonnull final HtmlProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return colgroup( props, children.stream() );
  }

  @Nonnull
  public static ReactNode colgroup( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return colgroup( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode div( @Nonnull final HtmlProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "div", props, child );
  }

  @Nonnull
  public static ReactNode div( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "div", null, child );
  }

  @Nonnull
  public static ReactNode div( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "div", props, text( content ) );
  }

  @Nonnull
  public static ReactNode div( @Nonnull final HtmlProps props )
  {
    return ReactDOM.createElement( "div", props );
  }

  @Nonnull
  public static ReactNode div( @Nonnull final String content )
  {
    return ReactDOM.createElement( "div", null, text( content ) );
  }

  @Nonnull
  public static ReactNode div()
  {
    return ReactDOM.createElement( "div", null );
  }

  @Nonnull
  public static ReactNode div( @Nonnull final HtmlProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return div( props, children.stream() );
  }

  @Nonnull
  public static ReactNode div( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return div( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode footer( @Nonnull final HtmlProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "footer", props, child );
  }

  @Nonnull
  public static ReactNode footer( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "footer", null, child );
  }

  @Nonnull
  public static ReactNode footer( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "footer", props, text( content ) );
  }

  @Nonnull
  public static ReactNode footer( @Nonnull final HtmlProps props )
  {
    return ReactDOM.createElement( "footer", props );
  }

  @Nonnull
  public static ReactNode footer( @Nonnull final String content )
  {
    return ReactDOM.createElement( "footer", null, text( content ) );
  }

  @Nonnull
  public static ReactNode footer()
  {
    return ReactDOM.createElement( "footer", null );
  }

  @Nonnull
  public static ReactNode footer( @Nonnull final HtmlProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return footer( props, children.stream() );
  }

  @Nonnull
  public static ReactNode footer( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return footer( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode form( @Nonnull final FormProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "form", props, child );
  }

  @Nonnull
  public static ReactNode form( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "form", null, child );
  }

  @Nonnull
  public static ReactNode form( @Nonnull final FormProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "form", props, text( content ) );
  }

  @Nonnull
  public static ReactNode form( @Nonnull final FormProps props )
  {
    return ReactDOM.createElement( "form", props );
  }

  @Nonnull
  public static ReactNode form( @Nonnull final String content )
  {
    return ReactDOM.createElement( "form", null, text( content ) );
  }

  @Nonnull
  public static ReactNode form()
  {
    return ReactDOM.createElement( "form", null );
  }

  @Nonnull
  public static ReactNode form( @Nonnull final FormProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return form( props, children.stream() );
  }

  @Nonnull
  public static ReactNode form( @Nonnull final FormProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return form( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode header( @Nonnull final HtmlProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "header", props, child );
  }

  @Nonnull
  public static ReactNode header( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "header", null, child );
  }

  @Nonnull
  public static ReactNode header( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "header", props, text( content ) );
  }

  @Nonnull
  public static ReactNode header( @Nonnull final HtmlProps props )
  {
    return ReactDOM.createElement( "header", props );
  }

  @Nonnull
  public static ReactNode header( @Nonnull final String content )
  {
    return ReactDOM.createElement( "header", null, text( content ) );
  }

  @Nonnull
  public static ReactNode header()
  {
    return ReactDOM.createElement( "header", null );
  }

  @Nonnull
  public static ReactNode header( @Nonnull final HtmlProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return header( props, children.stream() );
  }

  @Nonnull
  public static ReactNode header( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return header( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode h1( @Nonnull final HtmlProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "h1", props, child );
  }

  @Nonnull
  public static ReactNode h1( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "h1", null, child );
  }

  @Nonnull
  public static ReactNode h1( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "h1", props, text( content ) );
  }

  @Nonnull
  public static ReactNode h1( @Nonnull final HtmlProps props )
  {
    return ReactDOM.createElement( "h1", props );
  }

  @Nonnull
  public static ReactNode h1( @Nonnull final String content )
  {
    return ReactDOM.createElement( "h1", null, text( content ) );
  }

  @Nonnull
  public static ReactNode h1()
  {
    return ReactDOM.createElement( "h1", null );
  }

  @Nonnull
  public static ReactNode h1( @Nonnull final HtmlProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return h1( props, children.stream() );
  }

  @Nonnull
  public static ReactNode h1( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return h1( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode h2( @Nonnull final HtmlProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "h2", props, child );
  }

  @Nonnull
  public static ReactNode h2( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "h2", null, child );
  }

  @Nonnull
  public static ReactNode h2( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "h2", props, text( content ) );
  }

  @Nonnull
  public static ReactNode h2( @Nonnull final HtmlProps props )
  {
    return ReactDOM.createElement( "h2", props );
  }

  @Nonnull
  public static ReactNode h2( @Nonnull final String content )
  {
    return ReactDOM.createElement( "h2", null, text( content ) );
  }

  @Nonnull
  public static ReactNode h2()
  {
    return ReactDOM.createElement( "h2", null );
  }

  @Nonnull
  public static ReactNode h2( @Nonnull final HtmlProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return h2( props, children.stream() );
  }

  @Nonnull
  public static ReactNode h2( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return h2( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode h3( @Nonnull final HtmlProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "h3", props, child );
  }

  @Nonnull
  public static ReactNode h3( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "h3", null, child );
  }

  @Nonnull
  public static ReactNode h3( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "h3", props, text( content ) );
  }

  @Nonnull
  public static ReactNode h3( @Nonnull final HtmlProps props )
  {
    return ReactDOM.createElement( "h3", props );
  }

  @Nonnull
  public static ReactNode h3( @Nonnull final String content )
  {
    return ReactDOM.createElement( "h3", null, text( content ) );
  }

  @Nonnull
  public static ReactNode h3()
  {
    return ReactDOM.createElement( "h3", null );
  }

  @Nonnull
  public static ReactNode h3( @Nonnull final HtmlProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return h3( props, children.stream() );
  }

  @Nonnull
  public static ReactNode h3( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return h3( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode h4( @Nonnull final HtmlProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "h4", props, child );
  }

  @Nonnull
  public static ReactNode h4( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "h4", null, child );
  }

  @Nonnull
  public static ReactNode h4( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "h4", props, text( content ) );
  }

  @Nonnull
  public static ReactNode h4( @Nonnull final HtmlProps props )
  {
    return ReactDOM.createElement( "h4", props );
  }

  @Nonnull
  public static ReactNode h4( @Nonnull final String content )
  {
    return ReactDOM.createElement( "h4", null, text( content ) );
  }

  @Nonnull
  public static ReactNode h4()
  {
    return ReactDOM.createElement( "h4", null );
  }

  @Nonnull
  public static ReactNode h4( @Nonnull final HtmlProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return h4( props, children.stream() );
  }

  @Nonnull
  public static ReactNode h4( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return h4( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode h5( @Nonnull final HtmlProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "h5", props, child );
  }

  @Nonnull
  public static ReactNode h5( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "h5", null, child );
  }

  @Nonnull
  public static ReactNode h5( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "h5", props, text( content ) );
  }

  @Nonnull
  public static ReactNode h5( @Nonnull final HtmlProps props )
  {
    return ReactDOM.createElement( "h5", props );
  }

  @Nonnull
  public static ReactNode h5( @Nonnull final String content )
  {
    return ReactDOM.createElement( "h5", null, text( content ) );
  }

  @Nonnull
  public static ReactNode h5()
  {
    return ReactDOM.createElement( "h5", null );
  }

  @Nonnull
  public static ReactNode h5( @Nonnull final HtmlProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return h5( props, children.stream() );
  }

  @Nonnull
  public static ReactNode h5( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return h5( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode h6( @Nonnull final HtmlProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "h6", props, child );
  }

  @Nonnull
  public static ReactNode h6( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "h6", null, child );
  }

  @Nonnull
  public static ReactNode h6( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "h6", props, text( content ) );
  }

  @Nonnull
  public static ReactNode h6( @Nonnull final HtmlProps props )
  {
    return ReactDOM.createElement( "h6", props );
  }

  @Nonnull
  public static ReactNode h6( @Nonnull final String content )
  {
    return ReactDOM.createElement( "h6", null, text( content ) );
  }

  @Nonnull
  public static ReactNode h6()
  {
    return ReactDOM.createElement( "h6", null );
  }

  @Nonnull
  public static ReactNode h6( @Nonnull final HtmlProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return h6( props, children.stream() );
  }

  @Nonnull
  public static ReactNode h6( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return h6( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode i( @Nonnull final HtmlProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "i", props, child );
  }

  @Nonnull
  public static ReactNode i( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "i", null, child );
  }

  @Nonnull
  public static ReactNode i( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "i", props, text( content ) );
  }

  @Nonnull
  public static ReactNode i( @Nonnull final HtmlProps props )
  {
    return ReactDOM.createElement( "i", props );
  }

  @Nonnull
  public static ReactNode i( @Nonnull final String content )
  {
    return ReactDOM.createElement( "i", null, text( content ) );
  }

  @Nonnull
  public static ReactNode i()
  {
    return ReactDOM.createElement( "i", null );
  }

  @Nonnull
  public static ReactNode i( @Nonnull final HtmlProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return i( props, children.stream() );
  }

  @Nonnull
  public static ReactNode i( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return i( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode iframe( @Nonnull final IFrameProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "iframe", props, child );
  }

  @Nonnull
  public static ReactNode iframe( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "iframe", null, child );
  }

  @Nonnull
  public static ReactNode iframe( @Nonnull final IFrameProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "iframe", props, text( content ) );
  }

  @Nonnull
  public static ReactNode iframe( @Nonnull final IFrameProps props )
  {
    return ReactDOM.createElement( "iframe", props );
  }

  @Nonnull
  public static ReactNode iframe( @Nonnull final String content )
  {
    return ReactDOM.createElement( "iframe", null, text( content ) );
  }

  @Nonnull
  public static ReactNode iframe()
  {
    return ReactDOM.createElement( "iframe", null );
  }

  @Nonnull
  public static ReactNode iframe( @Nonnull final IFrameProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return iframe( props, children.stream() );
  }

  @Nonnull
  public static ReactNode iframe( @Nonnull final IFrameProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return iframe( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode img( @Nonnull final ImgProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "img", props, child );
  }

  @Nonnull
  public static ReactNode img( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "img", null, child );
  }

  @Nonnull
  public static ReactNode img( @Nonnull final ImgProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "img", props, text( content ) );
  }

  @Nonnull
  public static ReactNode img( @Nonnull final ImgProps props )
  {
    return ReactDOM.createElement( "img", props );
  }

  @Nonnull
  public static ReactNode img( @Nonnull final String content )
  {
    return ReactDOM.createElement( "img", null, text( content ) );
  }

  @Nonnull
  public static ReactNode img()
  {
    return ReactDOM.createElement( "img", null );
  }

  @Nonnull
  public static ReactNode img( @Nonnull final ImgProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return img( props, children.stream() );
  }

  @Nonnull
  public static ReactNode img( @Nonnull final ImgProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return img( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode input( @Nonnull final InputProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "input", props, child );
  }

  @Nonnull
  public static ReactNode input( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "input", null, child );
  }

  @Nonnull
  public static ReactNode input( @Nonnull final InputProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "input", props, text( content ) );
  }

  @Nonnull
  public static ReactNode input( @Nonnull final InputProps props )
  {
    return ReactDOM.createElement( "input", props );
  }

  @Nonnull
  public static ReactNode input( @Nonnull final String content )
  {
    return ReactDOM.createElement( "input", null, text( content ) );
  }

  @Nonnull
  public static ReactNode input()
  {
    return ReactDOM.createElement( "input", null );
  }

  @Nonnull
  public static ReactNode input( @Nonnull final InputProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return input( props, children.stream() );
  }

  @Nonnull
  public static ReactNode input( @Nonnull final InputProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return input( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode label( @Nonnull final LabelProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "label", props, child );
  }

  @Nonnull
  public static ReactNode label( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "label", null, child );
  }

  @Nonnull
  public static ReactNode label( @Nonnull final LabelProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "label", props, text( content ) );
  }

  @Nonnull
  public static ReactNode label( @Nonnull final LabelProps props )
  {
    return ReactDOM.createElement( "label", props );
  }

  @Nonnull
  public static ReactNode label( @Nonnull final String content )
  {
    return ReactDOM.createElement( "label", null, text( content ) );
  }

  @Nonnull
  public static ReactNode label()
  {
    return ReactDOM.createElement( "label", null );
  }

  @Nonnull
  public static ReactNode label( @Nonnull final LabelProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return label( props, children.stream() );
  }

  @Nonnull
  public static ReactNode label( @Nonnull final LabelProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return label( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode li( @Nonnull final HtmlProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "li", props, child );
  }

  @Nonnull
  public static ReactNode li( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "li", null, child );
  }

  @Nonnull
  public static ReactNode li( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "li", props, text( content ) );
  }

  @Nonnull
  public static ReactNode li( @Nonnull final HtmlProps props )
  {
    return ReactDOM.createElement( "li", props );
  }

  @Nonnull
  public static ReactNode li( @Nonnull final String content )
  {
    return ReactDOM.createElement( "li", null, text( content ) );
  }

  @Nonnull
  public static ReactNode li()
  {
    return ReactDOM.createElement( "li", null );
  }

  @Nonnull
  public static ReactNode li( @Nonnull final HtmlProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return li( props, children.stream() );
  }

  @Nonnull
  public static ReactNode li( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return li( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode ol( @Nonnull final HtmlProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "ol", props, child );
  }

  @Nonnull
  public static ReactNode ol( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "ol", null, child );
  }

  @Nonnull
  public static ReactNode ol( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "ol", props, text( content ) );
  }

  @Nonnull
  public static ReactNode ol( @Nonnull final HtmlProps props )
  {
    return ReactDOM.createElement( "ol", props );
  }

  @Nonnull
  public static ReactNode ol( @Nonnull final String content )
  {
    return ReactDOM.createElement( "ol", null, text( content ) );
  }

  @Nonnull
  public static ReactNode ol()
  {
    return ReactDOM.createElement( "ol", null );
  }

  @Nonnull
  public static ReactNode ol( @Nonnull final HtmlProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return ol( props, children.stream() );
  }

  @Nonnull
  public static ReactNode ol( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return ol( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode option( @Nonnull final OptionProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "option", props, child );
  }

  @Nonnull
  public static ReactNode option( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "option", null, child );
  }

  @Nonnull
  public static ReactNode option( @Nonnull final OptionProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "option", props, text( content ) );
  }

  @Nonnull
  public static ReactNode option( @Nonnull final OptionProps props )
  {
    return ReactDOM.createElement( "option", props );
  }

  @Nonnull
  public static ReactNode option( @Nonnull final String content )
  {
    return ReactDOM.createElement( "option", null, text( content ) );
  }

  @Nonnull
  public static ReactNode option()
  {
    return ReactDOM.createElement( "option", null );
  }

  @Nonnull
  public static ReactNode option( @Nonnull final OptionProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return option( props, children.stream() );
  }

  @Nonnull
  public static ReactNode option( @Nonnull final OptionProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return option( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode optgroup( @Nonnull final OptGroupProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "optgroup", props, child );
  }

  @Nonnull
  public static ReactNode optgroup( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "optgroup", null, child );
  }

  @Nonnull
  public static ReactNode optgroup( @Nonnull final OptGroupProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "optgroup", props, text( content ) );
  }

  @Nonnull
  public static ReactNode optgroup( @Nonnull final OptGroupProps props )
  {
    return ReactDOM.createElement( "optgroup", props );
  }

  @Nonnull
  public static ReactNode optgroup( @Nonnull final String content )
  {
    return ReactDOM.createElement( "optgroup", null, text( content ) );
  }

  @Nonnull
  public static ReactNode optgroup()
  {
    return ReactDOM.createElement( "optgroup", null );
  }

  @Nonnull
  public static ReactNode optgroup( @Nonnull final OptGroupProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return optgroup( props, children.stream() );
  }

  @Nonnull
  public static ReactNode optgroup( @Nonnull final OptGroupProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return optgroup( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode p( @Nonnull final HtmlProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "p", props, child );
  }

  @Nonnull
  public static ReactNode p( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "p", null, child );
  }

  @Nonnull
  public static ReactNode p( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "p", props, text( content ) );
  }

  @Nonnull
  public static ReactNode p( @Nonnull final HtmlProps props )
  {
    return ReactDOM.createElement( "p", props );
  }

  @Nonnull
  public static ReactNode p( @Nonnull final String content )
  {
    return ReactDOM.createElement( "p", null, text( content ) );
  }

  @Nonnull
  public static ReactNode p()
  {
    return ReactDOM.createElement( "p", null );
  }

  @Nonnull
  public static ReactNode p( @Nonnull final HtmlProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return p( props, children.stream() );
  }

  @Nonnull
  public static ReactNode p( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return p( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode span( @Nonnull final HtmlProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "span", props, child );
  }

  @Nonnull
  public static ReactNode span( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "span", null, child );
  }

  @Nonnull
  public static ReactNode span( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "span", props, text( content ) );
  }

  @Nonnull
  public static ReactNode span( @Nonnull final HtmlProps props )
  {
    return ReactDOM.createElement( "span", props );
  }

  @Nonnull
  public static ReactNode span( @Nonnull final String content )
  {
    return ReactDOM.createElement( "span", null, text( content ) );
  }

  @Nonnull
  public static ReactNode span()
  {
    return ReactDOM.createElement( "span", null );
  }

  @Nonnull
  public static ReactNode span( @Nonnull final HtmlProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return span( props, children.stream() );
  }

  @Nonnull
  public static ReactNode span( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return span( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode select( @Nonnull final SelectProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "select", props, child );
  }

  @Nonnull
  public static ReactNode select( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "select", null, child );
  }

  @Nonnull
  public static ReactNode select( @Nonnull final SelectProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "select", props, text( content ) );
  }

  @Nonnull
  public static ReactNode select( @Nonnull final SelectProps props )
  {
    return ReactDOM.createElement( "select", props );
  }

  @Nonnull
  public static ReactNode select( @Nonnull final String content )
  {
    return ReactDOM.createElement( "select", null, text( content ) );
  }

  @Nonnull
  public static ReactNode select()
  {
    return ReactDOM.createElement( "select", null );
  }

  @Nonnull
  public static ReactNode select( @Nonnull final SelectProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return select( props, children.stream() );
  }

  @Nonnull
  public static ReactNode select( @Nonnull final SelectProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return select( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode section( @Nonnull final HtmlProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "section", props, child );
  }

  @Nonnull
  public static ReactNode section( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "section", null, child );
  }

  @Nonnull
  public static ReactNode section( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "section", props, text( content ) );
  }

  @Nonnull
  public static ReactNode section( @Nonnull final HtmlProps props )
  {
    return ReactDOM.createElement( "section", props );
  }

  @Nonnull
  public static ReactNode section( @Nonnull final String content )
  {
    return ReactDOM.createElement( "section", null, text( content ) );
  }

  @Nonnull
  public static ReactNode section()
  {
    return ReactDOM.createElement( "section", null );
  }

  @Nonnull
  public static ReactNode section( @Nonnull final HtmlProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return section( props, children.stream() );
  }

  @Nonnull
  public static ReactNode section( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return section( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode strong( @Nonnull final HtmlProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "strong", props, child );
  }

  @Nonnull
  public static ReactNode strong( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "strong", null, child );
  }

  @Nonnull
  public static ReactNode strong( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "strong", props, text( content ) );
  }

  @Nonnull
  public static ReactNode strong( @Nonnull final HtmlProps props )
  {
    return ReactDOM.createElement( "strong", props );
  }

  @Nonnull
  public static ReactNode strong( @Nonnull final String content )
  {
    return ReactDOM.createElement( "strong", null, text( content ) );
  }

  @Nonnull
  public static ReactNode strong()
  {
    return ReactDOM.createElement( "strong", null );
  }

  @Nonnull
  public static ReactNode strong( @Nonnull final HtmlProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return strong( props, children.stream() );
  }

  @Nonnull
  public static ReactNode strong( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return strong( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode source( @Nonnull final SourceProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "source", props, child );
  }

  @Nonnull
  public static ReactNode source( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "source", null, child );
  }

  @Nonnull
  public static ReactNode source( @Nonnull final SourceProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "source", props, text( content ) );
  }

  @Nonnull
  public static ReactNode source( @Nonnull final SourceProps props )
  {
    return ReactDOM.createElement( "source", props );
  }

  @Nonnull
  public static ReactNode source( @Nonnull final String content )
  {
    return ReactDOM.createElement( "source", null, text( content ) );
  }

  @Nonnull
  public static ReactNode source()
  {
    return ReactDOM.createElement( "source", null );
  }

  @Nonnull
  public static ReactNode source( @Nonnull final SourceProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return source( props, children.stream() );
  }

  @Nonnull
  public static ReactNode source( @Nonnull final SourceProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return source( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode table( @Nonnull final HtmlProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "table", props, child );
  }

  @Nonnull
  public static ReactNode table( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "table", null, child );
  }

  @Nonnull
  public static ReactNode table( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "table", props, text( content ) );
  }

  @Nonnull
  public static ReactNode table( @Nonnull final HtmlProps props )
  {
    return ReactDOM.createElement( "table", props );
  }

  @Nonnull
  public static ReactNode table( @Nonnull final String content )
  {
    return ReactDOM.createElement( "table", null, text( content ) );
  }

  @Nonnull
  public static ReactNode table()
  {
    return ReactDOM.createElement( "table", null );
  }

  @Nonnull
  public static ReactNode table( @Nonnull final HtmlProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return table( props, children.stream() );
  }

  @Nonnull
  public static ReactNode table( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return table( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode textarea( @Nonnull final TextAreaProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "textarea", props, child );
  }

  @Nonnull
  public static ReactNode textarea( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "textarea", null, child );
  }

  @Nonnull
  public static ReactNode textarea( @Nonnull final TextAreaProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "textarea", props, text( content ) );
  }

  @Nonnull
  public static ReactNode textarea( @Nonnull final TextAreaProps props )
  {
    return ReactDOM.createElement( "textarea", props );
  }

  @Nonnull
  public static ReactNode textarea( @Nonnull final String content )
  {
    return ReactDOM.createElement( "textarea", null, text( content ) );
  }

  @Nonnull
  public static ReactNode textarea()
  {
    return ReactDOM.createElement( "textarea", null );
  }

  @Nonnull
  public static ReactNode textarea( @Nonnull final TextAreaProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return textarea( props, children.stream() );
  }

  @Nonnull
  public static ReactNode textarea( @Nonnull final TextAreaProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return textarea( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode td( @Nonnull final TdProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "td", props, child );
  }

  @Nonnull
  public static ReactNode td( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "td", null, child );
  }

  @Nonnull
  public static ReactNode td( @Nonnull final TdProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "td", props, text( content ) );
  }

  @Nonnull
  public static ReactNode td( @Nonnull final TdProps props )
  {
    return ReactDOM.createElement( "td", props );
  }

  @Nonnull
  public static ReactNode td( @Nonnull final String content )
  {
    return ReactDOM.createElement( "td", null, text( content ) );
  }

  @Nonnull
  public static ReactNode td()
  {
    return ReactDOM.createElement( "td", null );
  }

  @Nonnull
  public static ReactNode td( @Nonnull final TdProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return td( props, children.stream() );
  }

  @Nonnull
  public static ReactNode td( @Nonnull final TdProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return td( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode th( @Nonnull final ThProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "th", props, child );
  }

  @Nonnull
  public static ReactNode th( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "th", null, child );
  }

  @Nonnull
  public static ReactNode th( @Nonnull final ThProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "th", props, text( content ) );
  }

  @Nonnull
  public static ReactNode th( @Nonnull final ThProps props )
  {
    return ReactDOM.createElement( "th", props );
  }

  @Nonnull
  public static ReactNode th( @Nonnull final String content )
  {
    return ReactDOM.createElement( "th", null, text( content ) );
  }

  @Nonnull
  public static ReactNode th()
  {
    return ReactDOM.createElement( "th", null );
  }

  @Nonnull
  public static ReactNode th( @Nonnull final ThProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return th( props, children.stream() );
  }

  @Nonnull
  public static ReactNode th( @Nonnull final ThProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return th( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode tr( @Nonnull final HtmlProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "tr", props, child );
  }

  @Nonnull
  public static ReactNode tr( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "tr", null, child );
  }

  @Nonnull
  public static ReactNode tr( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "tr", props, text( content ) );
  }

  @Nonnull
  public static ReactNode tr( @Nonnull final HtmlProps props )
  {
    return ReactDOM.createElement( "tr", props );
  }

  @Nonnull
  public static ReactNode tr( @Nonnull final String content )
  {
    return ReactDOM.createElement( "tr", null, text( content ) );
  }

  @Nonnull
  public static ReactNode tr()
  {
    return ReactDOM.createElement( "tr", null );
  }

  @Nonnull
  public static ReactNode tr( @Nonnull final HtmlProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return tr( props, children.stream() );
  }

  @Nonnull
  public static ReactNode tr( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return tr( props, children.toArray( ReactNode[]::new ) );
  }

  @Nonnull
  public static ReactNode ul( @Nonnull final HtmlProps props, @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "ul", props, child );
  }

  @Nonnull
  public static ReactNode ul( @Nullable final ReactNode... child )
  {
    return ReactDOM.createElement( "ul", null, child );
  }

  @Nonnull
  public static ReactNode ul( @Nonnull final HtmlProps props, @Nonnull final String content )
  {
    return ReactDOM.createElement( "ul", props, text( content ) );
  }

  @Nonnull
  public static ReactNode ul( @Nonnull final HtmlProps props )
  {
    return ReactDOM.createElement( "ul", props );
  }

  @Nonnull
  public static ReactNode ul( @Nonnull final String content )
  {
    return ReactDOM.createElement( "ul", null, text( content ) );
  }

  @Nonnull
  public static ReactNode ul()
  {
    return ReactDOM.createElement( "ul", null );
  }

  @Nonnull
  public static ReactNode ul( @Nonnull final HtmlProps props, @Nonnull final List<? extends ReactNode> children )
  {
    return ul( props, children.stream() );
  }

  @Nonnull
  public static ReactNode ul( @Nonnull final HtmlProps props, @Nonnull final Stream<? extends ReactNode> children )
  {
    return ul( props, children.toArray( ReactNode[]::new ) );
  }
}
