/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import react4j.processor.ComponentDescriptor;
import react4j.processor.React4jProcessor;
import react4j.processor.vendor.javapoet.ClassName;
import react4j.processor.vendor.javapoet.CodeBlock;
import react4j.processor.vendor.javapoet.FieldSpec;
import react4j.processor.vendor.javapoet.MethodSpec;
import react4j.processor.vendor.javapoet.ParameterSpec;
import react4j.processor.vendor.javapoet.TypeName;
import react4j.processor.vendor.javapoet.TypeSpec;
import react4j.processor.vendor.proton.AnnotationsUtil;
import react4j.processor.vendor.proton.ElementsUtil;
import react4j.processor.vendor.proton.GeneratorUtil;
import react4j.processor.vendor.proton.SuppressWarningsUtil;

final class FactoryGenerator {
    private static final ClassName REACT_NATIVE_COMPONENT_CLASSNAME = ClassName.get("react4j.internal", "NativeComponent", new String[0]);
    private static final ClassName GUARDS_CLASSNAME = ClassName.get("org.realityforge.braincheck", "Guards", new String[0]);
    private static final ClassName REACT_CLASSNAME = ClassName.get("react4j", "React", new String[0]);

    private FactoryGenerator() {
    }

    @Nonnull
    static TypeSpec buildType(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ComponentDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder(descriptor.getFactoryClassName());
        GeneratorUtil.addGeneratedAnnotation(processingEnv, builder, React4jProcessor.class.getName());
        GeneratorUtil.addOriginatingTypes(descriptor.getElement(), builder);
        builder.addModifiers(Modifier.PUBLIC, Modifier.FINAL);
        if (descriptor.enableSting()) {
            builder.addAnnotation(ClassName.bestGuess("sting.Injectable"));
            builder.addAnnotation(ClassName.bestGuess("sting.Eager"));
            GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)descriptor.getElement(), builder, Arrays.asList("sting.Named", "sting.ContributeTo"));
        }
        ExecutableElement constructor = ElementsUtil.getConstructors(descriptor.getElement()).get(0);
        FactoryGenerator.buildFields(processingEnv, builder, constructor);
        FactoryGenerator.buildConstructor(processingEnv, descriptor, builder, constructor);
        FactoryGenerator.buildCreateMethod(descriptor, builder);
        builder.addType(FactoryGenerator.buildInjectSupport(descriptor));
        return builder.build();
    }

    private static void buildConstructor(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ComponentDescriptor descriptor, @Nonnull TypeSpec.Builder builder, @Nonnull ExecutableElement constructor) {
        MethodSpec.Builder ctor = MethodSpec.constructorBuilder();
        boolean inject = descriptor.enableInject();
        if (inject) {
            ctor.addAnnotation(ClassName.bestGuess("javax.inject.Inject"));
        }
        boolean sting = descriptor.enableSting();
        ArrayList<String> additionalSuppressions = new ArrayList<String>();
        if (inject && sting) {
            additionalSuppressions.add("Sting:Jsr330InjectPresent");
        }
        if (sting && constructor.getParameters().stream().anyMatch(p -> AnnotationsUtil.hasAnnotationOfType(p, "javax.inject.Named"))) {
            additionalSuppressions.add("Sting:Jsr330NamedPresent");
        }
        SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, ctor, additionalSuppressions, Collections.singletonList(constructor.asType()));
        GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)constructor, ctor);
        if (!inject && !sting) {
            ctor.addModifiers(Modifier.PUBLIC);
        }
        ArrayList<String> whitelistedAnnotations = new ArrayList<String>(GeneratorUtil.ANNOTATION_WHITELIST);
        whitelistedAnnotations.add("sting.Named");
        whitelistedAnnotations.add("javax.inject.Named");
        for (VariableElement variableElement : constructor.getParameters()) {
            String name = variableElement.getSimpleName().toString();
            ParameterSpec.Builder param = ParameterSpec.builder(TypeName.get(variableElement.asType()), name, Modifier.FINAL);
            GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)variableElement, param, whitelistedAnnotations);
            ctor.addParameter(param.build());
            if (AnnotationsUtil.hasNonnullAnnotation(variableElement)) {
                ctor.addStatement("this.$N = $T.requireNonNull( $N )", name, Objects.class, name);
                continue;
            }
            ctor.addStatement("this.$N = $N", name, name);
        }
        ctor.addStatement("InjectSupport.setFactory( this )", new Object[0]);
        builder.addMethod(ctor.build());
    }

    private static void buildFields(@Nonnull ProcessingEnvironment processingEnv, TypeSpec.Builder builder, ExecutableElement constructor) {
        for (VariableElement variableElement : constructor.getParameters()) {
            FieldSpec.Builder field = FieldSpec.builder(TypeName.get(variableElement.asType()), variableElement.getSimpleName().toString(), Modifier.PRIVATE, Modifier.FINAL);
            List<TypeMirror> types = Arrays.asList(constructor.asType(), variableElement.asType());
            SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, field, types);
            GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)variableElement, field);
            builder.addField(field.build());
        }
    }

    private static void buildCreateMethod(@Nonnull ComponentDescriptor descriptor, @Nonnull TypeSpec.Builder builder) {
        builder.addMethod(MethodSpec.methodBuilder("create").addModifiers(Modifier.PUBLIC, Modifier.STATIC).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).addParameter(ParameterSpec.builder(REACT_NATIVE_COMPONENT_CLASSNAME, "component", Modifier.FINAL).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).build()).returns(descriptor.getEnhancedClassName()).addStatement("return InjectSupport.create( component )", descriptor.getArezClassName()).build());
    }

    @Nonnull
    private static TypeSpec buildInjectSupport(@Nonnull ComponentDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder("InjectSupport").addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL);
        builder.addField(FactoryGenerator.buildFactoryField(descriptor).build());
        builder.addMethod(FactoryGenerator.buildSetFactoryMethod(descriptor).build());
        builder.addMethod(FactoryGenerator.buildInjectCreateMethod(descriptor).build());
        return builder.build();
    }

    @Nonnull
    private static FieldSpec.Builder buildFactoryField(@Nonnull ComponentDescriptor descriptor) {
        return FieldSpec.builder(descriptor.getFactoryClassName(), "c_factory", Modifier.STATIC, Modifier.PRIVATE);
    }

    @Nonnull
    private static MethodSpec.Builder buildSetFactoryMethod(@Nonnull ComponentDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("setFactory").addModifiers(Modifier.PRIVATE, Modifier.STATIC).addParameter(ParameterSpec.builder(descriptor.getFactoryClassName(), "factory", Modifier.FINAL).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).build());
        CodeBlock.Builder block = CodeBlock.builder();
        block.beginControlFlow("if ( $T.shouldCheckInvariants() )", REACT_CLASSNAME);
        block.addStatement("$T.invariant( () -> null == c_factory, () -> \"Attempted to instantiate the React4j component factory for the component named '$N' a second time\" )", GUARDS_CLASSNAME, descriptor.getName());
        block.endControlFlow();
        method.addCode(block.build());
        method.addStatement("c_factory = factory", new Object[0]);
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildInjectCreateMethod(@Nonnull ComponentDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("create").addModifiers(Modifier.PRIVATE, Modifier.STATIC).addParameter(ParameterSpec.builder(REACT_NATIVE_COMPONENT_CLASSNAME, "component", Modifier.FINAL).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).build()).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).returns(descriptor.getEnhancedClassName());
        CodeBlock.Builder block = CodeBlock.builder();
        block.beginControlFlow("if ( $T.shouldCheckInvariants() )", REACT_CLASSNAME);
        block.addStatement("$T.invariant( () -> null != c_factory, () -> \"Attempted to create an instance of the React4j component named '$N' before the component factory has been initialized. Please see the documentation at https://react4j.github.io/dependency_injection for directions how to configure dependency injection.\" )", GUARDS_CLASSNAME, descriptor.getName());
        block.endControlFlow();
        method.addCode(block.build());
        ExecutableElement constructor = ElementsUtil.getConstructors(descriptor.getElement()).get(0);
        return method.addStatement("return new $T( component" + constructor.getParameters().stream().map(p -> ", c_factory." + p.getSimpleName().toString()).collect(Collectors.joining()) + " )", descriptor.getArezClassName());
    }
}

