/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.ExecutableType;
import react4j.processor.InputDescriptor;
import react4j.processor.StepMethodType;
import react4j.processor.vendor.javapoet.TypeName;

final class StepMethod {
    @Nonnull
    private final String _name;
    @Nonnull
    private final String _key;
    @Nonnull
    private final TypeName _type;
    @Nullable
    private final InputDescriptor _input;
    @Nonnull
    private final StepMethodType _stepMethodType;

    StepMethod(@Nonnull InputDescriptor input, @Nonnull StepMethodType stepMethodType) {
        this(input.getName(), input.getName(), TypeName.get(input.getMethodType().getReturnType()), input, stepMethodType);
    }

    StepMethod(@Nonnull String name, @Nonnull String key, @Nonnull TypeName type, @Nullable InputDescriptor input, @Nonnull StepMethodType stepMethodType) {
        this._name = Objects.requireNonNull(name);
        this._key = Objects.requireNonNull(key);
        this._type = Objects.requireNonNull(type);
        this._input = input;
        this._stepMethodType = Objects.requireNonNull(stepMethodType);
    }

    @Nonnull
    String getName() {
        return this._name;
    }

    @Nonnull
    TypeName getType() {
        return this._type;
    }

    @Nullable
    InputDescriptor getInput() {
        return this._input;
    }

    @Nullable
    ExecutableElement getMethod() {
        return null != this._input ? this._input.getMethod() : null;
    }

    @Nullable
    ExecutableType getMethodType() {
        return null != this._input ? this._input.getMethodType() : null;
    }

    @Nonnull
    StepMethodType getStepMethodType() {
        return this._stepMethodType;
    }

    boolean isBuildIntrinsic() {
        return this.getName().equals("build");
    }

    boolean isChildIntrinsic() {
        return this.getName().equals("child") && this._key.equals("child");
    }

    boolean isChildrenIntrinsic() {
        return this.getName().equals("children") && this._key.equals("children");
    }

    boolean isChildrenStreamIntrinsic() {
        return this.getName().equals("children") && this._key.equals("*children_stream*");
    }
}

