/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor.vendor.proton;

import java.util.Objects;
import javax.annotation.Nonnull;

public final class StopWatch {
    @Nonnull
    private final String _name;
    private long _totalDuration;
    private long _start;

    public StopWatch(@Nonnull String name) {
        this._name = Objects.requireNonNull(name);
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    public long getTotalDuration() {
        return this._totalDuration;
    }

    public void start() {
        if (0L != this._start) {
            throw new IllegalStateException("Attempted to start " + this._name + " timer that had already been started");
        }
        this._start = System.nanoTime();
    }

    public void stop() {
        if (0L == this._start) {
            throw new IllegalStateException("Attempted to stop '" + this._name + "' timer that had not been started");
        }
        this._totalDuration += System.nanoTime() - this._start;
        this._start = 0L;
    }

    public void reset() {
        this._totalDuration = 0L;
    }

    @Nonnull
    public String toString() {
        return this._name + ": " + this._totalDuration;
    }
}

