/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor.vendor.google.common.collect;

import java.util.function.Consumer;
import react4j.processor.vendor.google.common.annotations.GwtCompatible;
import react4j.processor.vendor.google.common.annotations.GwtIncompatible;
import react4j.processor.vendor.google.common.collect.ImmutableAsList;
import react4j.processor.vendor.google.common.collect.ImmutableCollection;
import react4j.processor.vendor.google.common.collect.ImmutableList;
import react4j.processor.vendor.google.common.collect.UnmodifiableListIterator;

@GwtCompatible(emulated=true)
class RegularImmutableAsList<E>
extends ImmutableAsList<E> {
    private final ImmutableCollection<E> delegate;
    private final ImmutableList<? extends E> delegateList;

    RegularImmutableAsList(ImmutableCollection<E> delegate, ImmutableList<? extends E> delegateList) {
        this.delegate = delegate;
        this.delegateList = delegateList;
    }

    RegularImmutableAsList(ImmutableCollection<E> delegate, Object[] array) {
        this(delegate, ImmutableList.asImmutableList(array));
    }

    @Override
    ImmutableCollection<E> delegateCollection() {
        return this.delegate;
    }

    ImmutableList<? extends E> delegateList() {
        return this.delegateList;
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index) {
        return this.delegateList.listIterator(index);
    }

    @Override
    @GwtIncompatible
    public void forEach(Consumer<? super E> action) {
        this.delegateList.forEach(action);
    }

    @Override
    @GwtIncompatible
    int copyIntoArray(Object[] dst, int offset) {
        return this.delegateList.copyIntoArray(dst, offset);
    }

    @Override
    public E get(int index) {
        return this.delegateList.get(index);
    }
}

