/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import react4j.processor.CallbackDescriptor;
import react4j.processor.ComponentDescriptor;
import react4j.processor.Generator;
import react4j.processor.MethodChecks;
import react4j.processor.MethodDescriptor;
import react4j.processor.ProcessorUtil;
import react4j.processor.PropDescriptor;
import react4j.processor.ReactProcessorException;
import react4j.processor.StateValueDescriptor;
import react4j.processor.vendor.javapoet.JavaFile;
import react4j.processor.vendor.javapoet.TypeSpec;

@SupportedAnnotationTypes(value={"react4j.annotations.*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public final class ReactProcessor
extends AbstractProcessor {
    private static final List<String> LIFECYCLE_METHODS = Arrays.asList("componentDidMount", "componentDidUpdate", "componentWillReceiveProps", "componentWillUnmount", "componentDidCatch", "shouldComponentUpdate");
    private final HashMap<String, ExecutableElement> _componentLifecycleMethods = new HashMap();
    private ExecutableElement _componentRenderMethod;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        this._componentLifecycleMethods.clear();
        this._componentRenderMethod = null;
        TypeElement annotation = this.processingEnv.getElementUtils().getTypeElement("react4j.annotations.ReactComponent");
        Set<? extends Element> elements = env.getElementsAnnotatedWith(annotation);
        this.processElements(elements);
        return false;
    }

    private void processElements(@Nonnull Set<? extends Element> elements) {
        for (Element element : elements) {
            try {
                this.process((TypeElement)element);
            }
            catch (IOException ioe) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, ioe.getMessage(), element);
            }
            catch (ReactProcessorException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage(), e.getElement());
            }
            catch (Throwable e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                sw.flush();
                String message = "Unexpected error will running the " + this.getClass().getName() + " processor. This has resulted in a failure to process the code and has left the compiler in an invalid state. Please report the failure to the developers so that it can be fixed.\n Report the error at: https://github.com/react4j/react4j/issues\n\n\n" + sw.toString();
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
            }
        }
    }

    private void process(@Nonnull TypeElement element) throws IOException, ReactProcessorException {
        ComponentDescriptor descriptor = this.parse(element);
        if (descriptor.needsHelper()) {
            this.emitTypeSpec(descriptor.getPackageName(), Generator.buildComponentHelper(descriptor));
        }
        this.emitTypeSpec(descriptor.getPackageName(), Generator.buildEnhancedComponent(descriptor));
        this.emitTypeSpec(descriptor.getPackageName(), Generator.buildComponentBuilder(descriptor));
        if (descriptor.needsDaggerIntegration()) {
            this.emitTypeSpec(descriptor.getPackageName(), Generator.buildDaggerFactory(descriptor));
        }
    }

    private void emitTypeSpec(@Nonnull String packageName, @Nonnull TypeSpec typeSpec) throws IOException {
        JavaFile.builder(packageName, typeSpec).skipJavaLangImports(true).build().writeTo(this.processingEnv.getFiler());
    }

    @Nonnull
    private ComponentDescriptor parse(@Nonnull TypeElement typeElement) {
        String name = this.deriveComponentName(typeElement);
        PackageElement packageElement = this.processingEnv.getElementUtils().getPackageOf(typeElement);
        ComponentDescriptor descriptor = new ComponentDescriptor(name, packageElement, typeElement);
        this.determineComponentType(descriptor, typeElement);
        this.determineLifecycleMethods(typeElement, descriptor);
        this.determineRenderMethod(typeElement, descriptor);
        this.determineCallbacks(descriptor);
        this.determineProps(descriptor);
        this.determineDefaultPropsMethods(descriptor);
        this.determineDefaultPropsFields(descriptor);
        this.determineStateValues(descriptor);
        for (PropDescriptor prop : descriptor.getProps()) {
            if (this.isPropRequired(prop)) continue;
            prop.markAsOptional();
        }
        descriptor.sortProps();
        this.verifyNoUnexpectedAbstractMethod(descriptor);
        return descriptor;
    }

    private void linkStateMethods(@Nonnull ComponentDescriptor descriptor) {
        List candidates = ProcessorUtil.getMethods(descriptor.getElement(), this.processingEnv.getTypeUtils()).stream().filter(m -> m.getModifiers().contains((Object)Modifier.ABSTRACT)).filter(m -> null == ProcessorUtil.findAnnotationByType(descriptor.getElement(), "react4j.annotations.Prop") && null == ProcessorUtil.findAnnotationByType(descriptor.getElement(), "react4j.annotations.State")).collect(Collectors.toList());
        for (ExecutableElement method : candidates) {
            StateValueDescriptor stateValueNamed;
            String stateName;
            ExecutableType methodType = (ExecutableType)this.processingEnv.getTypeUtils().asMemberOf(descriptor.getDeclaredType(), method);
            if (method.getReturnType().getKind() == TypeKind.VOID && 1 == method.getParameters().size()) {
                stateName = ProcessorUtil.getPropertyMutatorName(method, "<default>");
                stateValueNamed = descriptor.findStateValueNamed(stateName);
                if (null == stateValueNamed || stateValueNamed.hasSetter()) continue;
                stateValueNamed.setSetter(method, methodType);
                continue;
            }
            if (method.getReturnType().getKind() == TypeKind.VOID || 0 != method.getParameters().size() || null == (stateValueNamed = descriptor.findStateValueNamed(stateName = ProcessorUtil.getPropertyAccessorName(method, "<default>"))) || stateValueNamed.hasGetter()) continue;
            stateValueNamed.setGetter(method, methodType);
        }
    }

    private void verifyNoUnexpectedAbstractMethod(@Nonnull ComponentDescriptor descriptor) {
        ExecutableElement abstractMethod;
        if (!descriptor.isArezComponent() && null != (abstractMethod = (ExecutableElement)ProcessorUtil.getMethods(descriptor.getElement(), this.processingEnv.getTypeUtils()).stream().filter(m -> m.getModifiers().contains((Object)Modifier.ABSTRACT)).filter(m -> descriptor.getProps().stream().noneMatch(p -> p.getMethod() == m) && descriptor.getStateValues().stream().noneMatch(p -> p.getGetter() == m || p.getSetter() == m)).findAny().orElse(null))) {
            throw new ReactProcessorException("@ReactComponent target has an unexpected abstract method", abstractMethod);
        }
    }

    private void determineDefaultPropsMethods(@Nonnull ComponentDescriptor descriptor) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        List defaultPropsMethods = ProcessorUtil.getMethods(descriptor.getElement(), typeUtils).stream().filter(m -> null != ProcessorUtil.findAnnotationByType(m, "react4j.annotations.PropDefault")).collect(Collectors.toList());
        for (ExecutableElement method : defaultPropsMethods) {
            String name = this.derivePropDefaultName(method);
            PropDescriptor prop = descriptor.findPropNamed(name);
            if (null == prop) {
                throw new ReactProcessorException("@PropDefault target for prop named '" + name + "' has no corresponding @Prop annotated method.", method);
            }
            ExecutableType methodType = (ExecutableType)typeUtils.asMemberOf(descriptor.getDeclaredType(), method);
            if (!this.processingEnv.getTypeUtils().isAssignable(methodType.getReturnType(), prop.getMethodType().getReturnType())) {
                throw new ReactProcessorException("@PropDefault target has a return type that is not assignable to the return type of the associated @Prop annotated method.", method);
            }
            prop.setDefaultMethod(method);
        }
    }

    private void determineDefaultPropsFields(@Nonnull ComponentDescriptor descriptor) {
        List defaultPropsFields = ProcessorUtil.getFieldElements(descriptor.getElement()).stream().filter(m -> null != ProcessorUtil.findAnnotationByType(m, "react4j.annotations.PropDefault")).collect(Collectors.toList());
        for (VariableElement field : defaultPropsFields) {
            String name = this.derivePropDefaultName(field);
            PropDescriptor prop = descriptor.findPropNamed(name);
            if (null == prop) {
                throw new ReactProcessorException("@PropDefault target for prop named '" + name + "' has no corresponding @Prop annotated method.", field);
            }
            if (!this.processingEnv.getTypeUtils().isAssignable(field.asType(), prop.getMethodType().getReturnType())) {
                throw new ReactProcessorException("@PropDefault target has a type that is not assignable to the return type of the associated @Prop annotated method.", field);
            }
            prop.setDefaultField(field);
        }
    }

    @Nonnull
    private String derivePropDefaultName(@Nonnull Element element) throws ReactProcessorException {
        String name = (String)ProcessorUtil.getAnnotationValue(this.processingEnv.getElementUtils(), element, "react4j.annotations.PropDefault", "name").getValue();
        if (ProcessorUtil.isSentinelName(name)) {
            if (element instanceof ExecutableElement) {
                String deriveName = ProcessorUtil.deriveName(element, ProcessorUtil.DEFAULT_GETTER_PATTERN, name);
                if (null == deriveName) {
                    throw new ReactProcessorException("@PropDefault target has not specified name nor is it named according to the convention 'get[Name]Default'.", element);
                }
                return deriveName;
            }
            String fieldName = element.getSimpleName().toString();
            boolean matched = true;
            int lengthPrefix = "DEFAULT_".length();
            int length = fieldName.length();
            if (fieldName.startsWith("DEFAULT_") && length > lengthPrefix) {
                for (int i = lengthPrefix; i < length; ++i) {
                    char ch = fieldName.charAt(i);
                    if (!Character.isLowerCase(ch) && (i == lengthPrefix && Character.isJavaIdentifierStart(ch) || i != lengthPrefix && Character.isJavaIdentifierPart(ch))) continue;
                    matched = false;
                    break;
                }
            } else {
                matched = false;
            }
            if (matched) {
                return this.uppercaseConstantToPascalCase(fieldName.substring(lengthPrefix));
            }
            throw new ReactProcessorException("@PropDefault target has not specified name nor is it named according to the convention 'DEFAULT_[NAME]'.", element);
        }
        if (!SourceVersion.isIdentifier(name)) {
            throw new ReactProcessorException("@PropDefault target specified an invalid name '" + name + "'. The name must be a valid java identifier.", element);
        }
        if (SourceVersion.isKeyword(name)) {
            throw new ReactProcessorException("@PropDefault target specified an invalid name '" + name + "'. The name must not be a java keyword.", element);
        }
        return name;
    }

    @Nonnull
    private String uppercaseConstantToPascalCase(@Nonnull String candidate) {
        String s = candidate.toLowerCase();
        StringBuilder sb = new StringBuilder();
        boolean uppercase = false;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if ('_' == ch) {
                uppercase = true;
                continue;
            }
            if (uppercase) {
                sb.append(Character.toUpperCase(ch));
                uppercase = false;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private void determineCallbacks(@Nonnull ComponentDescriptor descriptor) {
        List<CallbackDescriptor> callbacks = ProcessorUtil.getMethods(descriptor.getElement(), this.processingEnv.getTypeUtils()).stream().filter(m -> null != ProcessorUtil.findAnnotationByType(m, "react4j.annotations.Callback")).map(m -> this.createCallbackDescriptor(descriptor, (ExecutableElement)m)).collect(Collectors.toList());
        for (CallbackDescriptor callback : callbacks) {
            ExecutableElement method = callback.getMethod();
            TypeElement callbackType = this.getCallbackType(method);
            if (ElementKind.INTERFACE != callbackType.getKind()) {
                throw new ReactProcessorException("The @Callback specified an invalid type that is not an interface.", callback.getMethod());
            }
            if (null == ProcessorUtil.findAnnotationByType(callbackType, "jsinterop.annotations.JsFunction")) {
                throw new ReactProcessorException("The @Callback specified an invalid type that is not annotated with the annotation jsinterop.annotations.JsFunction.", callback.getMethod());
            }
            CallbackDescriptor matched = callbacks.stream().filter(h -> h != callback && h.getName().equals(callback.getName())).findAny().orElse(null);
            if (null != matched) {
                throw new ReactProcessorException("The @Callback has the same name as the callback defined by " + matched.getMethod() + ".", callback.getMethod());
            }
            CallbackDescriptor matched2 = callbacks.stream().filter(h -> h != callback && h.getMethod().getSimpleName().equals(callback.getMethod().getSimpleName())).findAny().orElse(null);
            if (null != matched2) {
                throw new ReactProcessorException("The @Callback has the same method name as the callback defined by " + matched2.getMethod() + ".", callback.getMethod());
            }
            ExecutableType methodType = callback.getMethodType();
            List<? extends TypeMirror> parameters = methodType.getParameterTypes();
            if (parameters.isEmpty()) continue;
            ExecutableElement target = callback.getCallbackMethod();
            List<? extends VariableElement> targetParameters = target.getParameters();
            if (targetParameters.size() != parameters.size()) {
                throw new ReactProcessorException("The @Callback target has " + parameters.size() + " parameters but the type parameter specified a callback with method type " + callback.getCallbackType().getQualifiedName() + " that has a callback method with " + targetParameters.size() + " parameters. The @Callback target should have zero parameters or match the number of parameter in the target method " + target.getSimpleName() + ".", callback.getMethod());
            }
            for (int i = 0; i < parameters.size(); ++i) {
                TypeMirror parameterType = parameters.get(i);
                VariableElement element = targetParameters.get(i);
                TypeMirror targetParameterType = element.asType();
                TypeMirror targetErased = this.processingEnv.getTypeUtils().erasure(targetParameterType);
                TypeMirror parameterErased = this.processingEnv.getTypeUtils().erasure(parameterType);
                if (this.processingEnv.getTypeUtils().isAssignable(targetErased, parameterErased)) continue;
                throw new ReactProcessorException("The @Callback target parameter named " + callback.getMethod().getParameters().get(i).getSimpleName() + " of type " + parameterType + " is not assignable from target type " + targetParameterType + " of parameter " + element.getSimpleName() + " in method " + callback.getCallbackType().getQualifiedName() + "." + target.getSimpleName() + ".", callback.getMethod());
            }
        }
        descriptor.setCallbacks(callbacks);
    }

    @Nonnull
    private CallbackDescriptor createCallbackDescriptor(@Nonnull ComponentDescriptor descriptor, @Nonnull ExecutableElement method) {
        this.verifyNoDuplicateAnnotations(method);
        String name = this.deriveCallbackName(method);
        TypeElement callbackType = this.getCallbackType(method);
        ExecutableType methodType = (ExecutableType)this.processingEnv.getTypeUtils().asMemberOf(descriptor.getDeclaredType(), method);
        List callbackMethods = ProcessorUtil.getMethods(callbackType, this.processingEnv.getTypeUtils()).stream().filter(m11 -> m11.getModifiers().contains((Object)Modifier.ABSTRACT)).collect(Collectors.toList());
        if (callbackMethods.isEmpty()) {
            throw new ReactProcessorException("Method annotated with @Callback specified type " + callbackType.getQualifiedName() + " that has no abstract method and thus is not a functional interface", method);
        }
        if (callbackMethods.size() > 1) {
            throw new ReactProcessorException("Method annotated with @Callback specified type " + callbackType.getQualifiedName() + " that has more than 1 abstract method and thus is not a functional interface", method);
        }
        boolean initCallbackContext = this.shouldInitCallbackContext(descriptor, method);
        if (initCallbackContext && descriptor.isArezComponent() && null != ProcessorUtil.findAnnotationByType(method, "arez.annotations.Action")) {
            String message = "@Callback target is also annotated with @arez.annotations.Action but the @Callback parameter 'initCallbackContext' is not set to Feature.DISABLE which would stop react4j from also annotating the method with @Action. Please remove @Action or change the 'initCallbackContext' to Feature.DISABLE.";
            throw new ReactProcessorException("@Callback target is also annotated with @arez.annotations.Action but the @Callback parameter 'initCallbackContext' is not set to Feature.DISABLE which would stop react4j from also annotating the method with @Action. Please remove @Action or change the 'initCallbackContext' to Feature.DISABLE.", method);
        }
        return new CallbackDescriptor(name, method, methodType, callbackType, (ExecutableElement)callbackMethods.get(0), initCallbackContext);
    }

    private boolean shouldInitCallbackContext(@Nonnull ComponentDescriptor descriptor, @Nonnull ExecutableElement method) {
        VariableElement injectParameter = (VariableElement)ProcessorUtil.getAnnotationValue(this.processingEnv.getElementUtils(), method, "react4j.annotations.Callback", "initCallbackContext").getValue();
        switch (injectParameter.getSimpleName().toString()) {
            case "ENABLE": {
                return true;
            }
            case "DISABLE": {
                return false;
            }
        }
        return descriptor.isArezComponent();
    }

    @Nonnull
    private TypeElement getCallbackType(@Nonnull ExecutableElement method) {
        DeclaredType typeMirror = ProcessorUtil.getTypeMirrorAnnotationParameter(this.processingEnv.getElementUtils(), method, "react4j.annotations.Callback", "value");
        assert (null != typeMirror);
        return (TypeElement)this.processingEnv.getTypeUtils().asElement(typeMirror);
    }

    @Nonnull
    private String deriveCallbackName(@Nonnull ExecutableElement method) throws ReactProcessorException {
        String name = (String)ProcessorUtil.getAnnotationValue(this.processingEnv.getElementUtils(), method, "react4j.annotations.Callback", "name").getValue();
        if (ProcessorUtil.isSentinelName(name)) {
            return method.getSimpleName().toString();
        }
        if (!SourceVersion.isIdentifier(name)) {
            throw new ReactProcessorException("@Callback target specified an invalid name '" + name + "'. The name must be a valid java identifier.", method);
        }
        if (SourceVersion.isKeyword(name)) {
            throw new ReactProcessorException("@Callback target specified an invalid name '" + name + "'. The name must not be a java keyword.", method);
        }
        return name;
    }

    private void determineProps(@Nonnull ComponentDescriptor descriptor) {
        List<PropDescriptor> props = ProcessorUtil.getMethods(descriptor.getElement(), this.processingEnv.getTypeUtils()).stream().filter(m -> null != ProcessorUtil.findAnnotationByType(m, "react4j.annotations.Prop")).map(m -> this.createPropDescriptor(descriptor, (ExecutableElement)m)).collect(Collectors.toList());
        PropDescriptor childrenProp = props.stream().filter(p -> p.getName().equals("children")).findAny().orElse(null);
        PropDescriptor childProp = props.stream().filter(p -> p.getName().equals("child")).findAny().orElse(null);
        if (null != childrenProp && null != childProp) {
            throw new ReactProcessorException("Multiple candidate children @Prop annotated methods: " + childrenProp.getMethod().getSimpleName() + " and " + childProp.getMethod().getSimpleName(), childrenProp.getMethod());
        }
        descriptor.setProps(props);
    }

    private boolean isPropRequired(@Nonnull PropDescriptor prop) {
        VariableElement injectParameter = (VariableElement)ProcessorUtil.getAnnotationValue(this.processingEnv.getElementUtils(), prop.getMethod(), "react4j.annotations.Prop", "require").getValue();
        switch (injectParameter.getSimpleName().toString()) {
            case "ENABLE": {
                return true;
            }
            case "DISABLE": {
                return false;
            }
        }
        return !prop.hasDefaultMethod() && !prop.hasDefaultField();
    }

    @Nonnull
    private PropDescriptor createPropDescriptor(@Nonnull ComponentDescriptor descriptor, @Nonnull ExecutableElement method) {
        String name = this.derivePropName(method);
        ExecutableType methodType = (ExecutableType)this.processingEnv.getTypeUtils().asMemberOf(descriptor.getDeclaredType(), method);
        this.verifyNoDuplicateAnnotations(method);
        MethodChecks.mustBeAbstract("react4j.annotations.Prop", method);
        MethodChecks.mustNotHaveAnyParameters("react4j.annotations.Prop", method);
        MethodChecks.mustReturnAValue("react4j.annotations.Prop", method);
        MethodChecks.mustNotThrowAnyExceptions("react4j.annotations.Prop", method);
        if ("key".equals(name)) {
            throw new ReactProcessorException("@Prop named 'key' is invalid as the name references value used in the reconciliation process. This value can be accessed via Component.getKey()", method);
        }
        if ("build".equals(name)) {
            throw new ReactProcessorException("@Prop named 'build' is invalid as it conflicts with the method named build() that is used in the generated Builder classes", method);
        }
        if ("child".equals(name) && methodType.getReturnType().getKind() != TypeKind.DECLARED && !"react4j.core.ReactNode".equals(methodType.getReturnType().toString())) {
            throw new ReactProcessorException("@Prop named 'child' should be of type react4j.core.ReactNode", method);
        }
        if ("children".equals(name) && methodType.getReturnType().getKind() != TypeKind.DECLARED && !"react4j.core.ReactNode[]".equals(methodType.getReturnType().toString())) {
            throw new ReactProcessorException("@Prop named 'children' should be of type react4j.core.ReactNode[]", method);
        }
        Element propType = this.processingEnv.getTypeUtils().asElement(method.getReturnType());
        return new PropDescriptor(name, method, methodType, propType);
    }

    @Nonnull
    private String derivePropName(@Nonnull ExecutableElement method) throws ReactProcessorException {
        String specifiedName = (String)ProcessorUtil.getAnnotationValue(this.processingEnv.getElementUtils(), method, "react4j.annotations.Prop", "name").getValue();
        String name = ProcessorUtil.getPropertyAccessorName(method, specifiedName);
        if (!SourceVersion.isIdentifier(name)) {
            throw new ReactProcessorException("@Prop target specified an invalid name '" + specifiedName + "'. The name must be a valid java identifier.", method);
        }
        if (SourceVersion.isKeyword(name)) {
            throw new ReactProcessorException("@Prop target specified an invalid name '" + specifiedName + "'. The name must not be a java keyword.", method);
        }
        return name;
    }

    private void determineStateValues(@Nonnull ComponentDescriptor descriptor) {
        List methods = ProcessorUtil.getMethods(descriptor.getElement(), this.processingEnv.getTypeUtils()).stream().filter(m -> null != ProcessorUtil.findAnnotationByType(m, "react4j.annotations.State")).collect(Collectors.toList());
        HashMap<String, StateValueDescriptor> values = new HashMap<String, StateValueDescriptor>();
        for (ExecutableElement method : methods) {
            ExecutableType methodType = (ExecutableType)this.processingEnv.getTypeUtils().asMemberOf(descriptor.getDeclaredType(), method);
            this.parseStateValueMethod(method, methodType, values);
        }
        ArrayList<StateValueDescriptor> stateValues = new ArrayList<StateValueDescriptor>(values.values());
        descriptor.setStateValues(stateValues);
        this.linkStateMethods(descriptor);
        for (StateValueDescriptor stateValue : stateValues) {
            if (!stateValue.hasGetter()) {
                throw new ReactProcessorException("@State target defined setter but no getter was defined and no getter could be automatically determined", stateValue.getSetter());
            }
            if (stateValue.hasSetter()) continue;
            throw new ReactProcessorException("@State target defined getter but no setter was defined and no setter could be automatically determined", stateValue.getGetter());
        }
        for (StateValueDescriptor stateValue : stateValues) {
            TypeMirror returnType = stateValue.getGetterType().getReturnType();
            TypeMirror parameterType = stateValue.getSetterType().getParameterTypes().get(0);
            if (this.processingEnv.getTypeUtils().isSameType(parameterType, returnType)) continue;
            throw new ReactProcessorException("@State property defines a setter and getter with different types. Getter type: " + returnType + " Setter type: " + parameterType + ".", stateValue.getGetter());
        }
    }

    private void parseStateValueMethod(@Nonnull ExecutableElement method, @Nonnull ExecutableType methodType, @Nonnull Map<String, StateValueDescriptor> values) {
        String name;
        String declaredName = (String)this.getAnnotationParameter(method, "react4j.annotations.State", "name");
        TypeMirror returnType = method.getReturnType();
        boolean setter = TypeKind.VOID == returnType.getKind();
        this.verifyNoDuplicateAnnotations(method);
        MethodChecks.mustBeAbstract("react4j.annotations.State", method);
        MethodChecks.mustNotThrowAnyExceptions("react4j.annotations.State", method);
        if (setter) {
            if (1 != method.getParameters().size()) {
                throw new ReactProcessorException("@State target must have a single parameter", method);
            }
            MethodChecks.mustNotReturnAValue("react4j.annotations.State", method);
            name = ProcessorUtil.getPropertyMutatorName(method, declaredName);
        } else {
            MethodChecks.mustNotHaveAnyParameters("react4j.annotations.State", method);
            MethodChecks.mustReturnAValue("react4j.annotations.State", method);
            name = ProcessorUtil.getPropertyAccessorName(method, declaredName);
        }
        if (!SourceVersion.isIdentifier(name)) {
            throw new ReactProcessorException("@State target specified an invalid name '" + name + "'. The name must be a valid java identifier.", method);
        }
        if (SourceVersion.isKeyword(name)) {
            throw new ReactProcessorException("@State target specified an invalid name '" + name + "'. The name must not be a java keyword.", method);
        }
        StateValueDescriptor stateValueDescriptor = values.computeIfAbsent(name, StateValueDescriptor::new);
        if (setter) {
            if (stateValueDescriptor.hasSetter()) {
                throw new ReactProcessorException("@State target defines duplicate state property mutator for property named '" + name + "'. Existing mutator: " + stateValueDescriptor.getSetter().getSimpleName(), method);
            }
            stateValueDescriptor.setSetter(method, methodType);
        } else {
            if (stateValueDescriptor.hasGetter()) {
                throw new ReactProcessorException("@State target defines duplicate state property accessor for property named '" + name + "'. Existing accessor: " + stateValueDescriptor.getGetter().getSimpleName(), method);
            }
            stateValueDescriptor.setGetter(method, methodType);
        }
    }

    private void determineLifecycleMethods(@Nonnull TypeElement typeElement, @Nonnull ComponentDescriptor descriptor) {
        Collection<ExecutableElement> lifecycleMethods = this.getComponentLifecycleMethods().values();
        Elements elementUtils = this.processingEnv.getElementUtils();
        Types typeUtils = this.processingEnv.getTypeUtils();
        TypeElement componentType = elementUtils.getTypeElement("react4j.core.Component");
        List<MethodDescriptor> overriddenLifecycleMethods = ProcessorUtil.getMethods(typeElement, this.processingEnv.getTypeUtils()).stream().filter(m -> lifecycleMethods.stream().anyMatch(l -> elementUtils.overrides((ExecutableElement)m, (ExecutableElement)l, typeElement))).filter(m -> m.getEnclosingElement() != componentType).map(m -> new MethodDescriptor((ExecutableElement)m, (ExecutableType)typeUtils.asMemberOf(descriptor.getDeclaredType(), (Element)m))).collect(Collectors.toList());
        descriptor.setLifecycleMethods(overriddenLifecycleMethods);
    }

    private void determineRenderMethod(@Nonnull TypeElement typeElement, @Nonnull ComponentDescriptor descriptor) {
        ExecutableElement renderMethod = this.getComponentRenderMethod();
        Elements elementUtils = this.processingEnv.getElementUtils();
        Types typeUtils = this.processingEnv.getTypeUtils();
        TypeElement componentType = elementUtils.getTypeElement("react4j.core.Component");
        MethodDescriptor overriddenRenderMethod = ProcessorUtil.getMethods(typeElement, this.processingEnv.getTypeUtils()).stream().filter(m -> elementUtils.overrides((ExecutableElement)m, renderMethod, typeElement)).filter(m -> m.getEnclosingElement() != componentType).map(m -> new MethodDescriptor((ExecutableElement)m, (ExecutableType)typeUtils.asMemberOf(descriptor.getDeclaredType(), (Element)m))).findAny().orElse(null);
        if (null == overriddenRenderMethod) {
            throw new ReactProcessorException("The react component does not override any render methods.", typeElement);
        }
    }

    @Nonnull
    private String deriveComponentName(@Nonnull TypeElement typeElement) {
        String name = (String)ProcessorUtil.getAnnotationValue(this.processingEnv.getElementUtils(), typeElement, "react4j.annotations.ReactComponent", "name").getValue();
        if (ProcessorUtil.isSentinelName(name)) {
            return typeElement.getSimpleName().toString();
        }
        if (!SourceVersion.isIdentifier(name)) {
            throw new ReactProcessorException("@ReactComponent target specified an invalid name '" + name + "'. The name must be a valid java identifier.", typeElement);
        }
        if (SourceVersion.isKeyword(name)) {
            throw new ReactProcessorException("@ReactComponent target specified an invalid name '" + name + "'. The name must not be a java keyword.", typeElement);
        }
        return name;
    }

    @Nonnull
    private HashMap<String, ExecutableElement> getComponentLifecycleMethods() {
        if (this._componentLifecycleMethods.isEmpty()) {
            TypeElement componentType = this.processingEnv.getElementUtils().getTypeElement("react4j.core.Component");
            for (ExecutableElement method : ProcessorUtil.getMethods(componentType, this.processingEnv.getTypeUtils())) {
                String methodName = method.getSimpleName().toString();
                if (!LIFECYCLE_METHODS.contains(methodName)) continue;
                this._componentLifecycleMethods.put(methodName, method);
            }
        }
        return this._componentLifecycleMethods;
    }

    @Nonnull
    private ExecutableElement getComponentRenderMethod() {
        if (null == this._componentRenderMethod) {
            TypeElement componentType = this.processingEnv.getElementUtils().getTypeElement("react4j.core.Component");
            for (ExecutableElement method : ProcessorUtil.getMethods(componentType, this.processingEnv.getTypeUtils())) {
                String methodName = method.getSimpleName().toString();
                if (!"render".equals(methodName)) continue;
                this._componentRenderMethod = method;
                break;
            }
        }
        return this._componentRenderMethod;
    }

    private void determineComponentType(@Nonnull ComponentDescriptor descriptor, @Nonnull TypeElement typeElement) {
        AnnotationMirror arezAnnotation;
        boolean isArezComponent;
        TypeElement componentType = this.processingEnv.getElementUtils().getTypeElement("react4j.core.Component");
        TypeMirror rawComponentType = this.processingEnv.getTypeUtils().erasure(componentType.asType());
        TypeElement arezComponentType = this.processingEnv.getElementUtils().getTypeElement("react4j.arez.ReactArezComponent");
        TypeMirror rawArezComponentType = null == arezComponentType ? null : this.processingEnv.getTypeUtils().erasure(arezComponentType.asType());
        DeclaredType type = descriptor.getDeclaredType();
        boolean isComponent = this.processingEnv.getTypeUtils().isSubtype(type, rawComponentType);
        boolean bl = isArezComponent = null != rawArezComponentType && this.processingEnv.getTypeUtils().isSubtype(type, rawArezComponentType);
        if (!isComponent) {
            throw new ReactProcessorException("@ReactComponent target must be a subclass of react4j.core.Component", typeElement);
        }
        if (isArezComponent && null != (arezAnnotation = (AnnotationMirror)typeElement.getAnnotationMirrors().stream().filter(m -> m.getAnnotationType().toString().equals("arez.annotations.ArezComponent")).findAny().orElse(null))) {
            throw new ReactProcessorException("@ReactComponent target extends react4j.arez.ReactArezComponent and should not be annotated with arez.annotations.ArezComponent as React4j will add annotation", typeElement);
        }
        boolean runArezScheduler = ProcessorUtil.getMethods(typeElement, this.processingEnv.getTypeUtils()).stream().anyMatch(this::hasAutorunAnnotation);
        boolean needsInjection = this.isInjectionRequired(typeElement);
        boolean isDaggerPresent = needsInjection && this.isDaggerRequired(typeElement);
        descriptor.setNeedsInjection(needsInjection);
        descriptor.setNeedsDaggerIntegration(isDaggerPresent);
        descriptor.setArezComponent(isArezComponent);
        descriptor.setRunArezScheduler(runArezScheduler);
    }

    private boolean isInjectionRequired(@Nonnull TypeElement typeElement) {
        VariableElement injectParameter = (VariableElement)ProcessorUtil.getAnnotationValue(this.processingEnv.getElementUtils(), typeElement, "react4j.annotations.ReactComponent", "inject").getValue();
        switch (injectParameter.getSimpleName().toString()) {
            case "ENABLE": {
                return true;
            }
            case "DISABLE": {
                return false;
            }
        }
        return ProcessorUtil.getFieldElements(typeElement).stream().anyMatch(this::hasInjectAnnotation) || ProcessorUtil.getMethods(typeElement, this.processingEnv.getTypeUtils()).stream().anyMatch(this::hasInjectAnnotation);
    }

    private boolean isDaggerRequired(@Nonnull TypeElement typeElement) {
        VariableElement injectParameter = (VariableElement)ProcessorUtil.getAnnotationValue(this.processingEnv.getElementUtils(), typeElement, "react4j.annotations.ReactComponent", "dagger").getValue();
        switch (injectParameter.getSimpleName().toString()) {
            case "ENABLE": {
                return true;
            }
            case "DISABLE": {
                return false;
            }
        }
        return null != this.processingEnv.getElementUtils().getTypeElement("dagger.Module");
    }

    private boolean hasAutorunAnnotation(Element method) {
        return null != ProcessorUtil.findAnnotationByType(method, "arez.annotations.Autorun");
    }

    private boolean hasInjectAnnotation(Element method) {
        return null != ProcessorUtil.findAnnotationByType(method, "javax.inject.Inject");
    }

    private <T> T getAnnotationParameter(@Nonnull Element element, @Nonnull String annotationName, @Nonnull String parameterName) {
        return (T)ProcessorUtil.getAnnotationValue(this.processingEnv.getElementUtils(), element, annotationName, parameterName).getValue();
    }

    private void verifyNoDuplicateAnnotations(@Nonnull ExecutableElement method) throws ReactProcessorException {
        String[] annotationTypes = new String[]{"react4j.annotations.Callback", "react4j.annotations.State", "react4j.annotations.Prop"};
        for (int i = 0; i < annotationTypes.length; ++i) {
            String type1 = annotationTypes[i];
            AnnotationMirror annotation1 = ProcessorUtil.findAnnotationByType(method, type1);
            if (null == annotation1) continue;
            for (int j = i + 1; j < annotationTypes.length; ++j) {
                String type2 = annotationTypes[j];
                AnnotationMirror annotation2 = ProcessorUtil.findAnnotationByType(method, type2);
                if (null == annotation2) continue;
                String message = "Method can not be annotated with both @" + ProcessorUtil.toSimpleName(type1) + " and @" + ProcessorUtil.toSimpleName(type2);
                throw new ReactProcessorException(message, method);
            }
        }
    }
}

