/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor.vendor.google.common.base;

import javax.annotation.Nullable;
import react4j.processor.vendor.google.common.annotations.Beta;
import react4j.processor.vendor.google.common.annotations.GwtCompatible;
import react4j.processor.vendor.google.common.base.Preconditions;
import react4j.processor.vendor.google.common.base.VerifyException;
import react4j.processor.vendor.google.errorprone.annotations.CanIgnoreReturnValue;

@Beta
@GwtCompatible
public final class Verify {
    public static void verify(boolean expression) {
        if (!expression) {
            throw new VerifyException();
        }
    }

    public static void verify(boolean expression, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new VerifyException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    @CanIgnoreReturnValue
    public static <T> T verifyNotNull(@Nullable T reference) {
        return Verify.verifyNotNull(reference, "expected a non-null reference", new Object[0]);
    }

    @CanIgnoreReturnValue
    public static <T> T verifyNotNull(@Nullable T reference, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        Verify.verify(reference != null, errorMessageTemplate, errorMessageArgs);
        return reference;
    }

    private Verify() {
    }
}

