/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor.vendor.google.common.cache;

import java.util.concurrent.Executor;
import react4j.processor.vendor.google.common.annotations.GwtIncompatible;
import react4j.processor.vendor.google.common.base.Preconditions;
import react4j.processor.vendor.google.common.cache.RemovalListener;
import react4j.processor.vendor.google.common.cache.RemovalNotification;

@GwtIncompatible
public final class RemovalListeners {
    private RemovalListeners() {
    }

    public static <K, V> RemovalListener<K, V> asynchronous(final RemovalListener<K, V> listener, final Executor executor) {
        Preconditions.checkNotNull(listener);
        Preconditions.checkNotNull(executor);
        return new RemovalListener<K, V>(){

            @Override
            public void onRemoval(final RemovalNotification<K, V> notification) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.onRemoval(notification);
                    }
                });
            }
        };
    }
}

