/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import javax.annotation.Nonnull;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import react4j.processor.ProcessorUtil;
import react4j.processor.ReactProcessorException;

final class MethodChecks {
    private MethodChecks() {
    }

    static void mustBeAbstract(@Nonnull String annotationName, @Nonnull ExecutableElement method) throws ReactProcessorException {
        if (!method.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new ReactProcessorException("@" + ProcessorUtil.toSimpleName(annotationName) + " target must be abstract", method);
        }
    }

    static void mustBeStatic(@Nonnull String annotationName, @Nonnull Element method) throws ReactProcessorException {
        if (!method.getModifiers().contains((Object)Modifier.STATIC)) {
            throw new ReactProcessorException("@" + ProcessorUtil.toSimpleName(annotationName) + " target must be static", method);
        }
    }

    static void mustBeFinal(@Nonnull String annotationName, @Nonnull Element method) throws ReactProcessorException {
        if (!method.getModifiers().contains((Object)Modifier.FINAL)) {
            throw new ReactProcessorException("@" + ProcessorUtil.toSimpleName(annotationName) + " target must be final", method);
        }
    }

    static void mustNotBePrivate(@Nonnull String annotationName, @Nonnull Element method) throws ReactProcessorException {
        if (method.getModifiers().contains((Object)Modifier.PRIVATE)) {
            throw new ReactProcessorException("@" + ProcessorUtil.toSimpleName(annotationName) + " target must not be private", method);
        }
    }

    static void mustNotHaveAnyParameters(@Nonnull String annotationName, @Nonnull ExecutableElement method) throws ReactProcessorException {
        if (!method.getParameters().isEmpty()) {
            throw new ReactProcessorException("@" + ProcessorUtil.toSimpleName(annotationName) + " target must not have any parameters", method);
        }
    }

    static void mustReturnAValue(@Nonnull String annotationName, @Nonnull ExecutableElement method) throws ReactProcessorException {
        if (TypeKind.VOID == method.getReturnType().getKind()) {
            throw new ReactProcessorException("@" + ProcessorUtil.toSimpleName(annotationName) + " target must return a value", method);
        }
    }

    static void mustNotReturnAValue(@Nonnull String annotationName, @Nonnull ExecutableElement method) throws ReactProcessorException {
        if (TypeKind.VOID != method.getReturnType().getKind()) {
            throw new ReactProcessorException("@" + ProcessorUtil.toSimpleName(annotationName) + " target must not return a value", method);
        }
    }

    static void mustNotThrowAnyExceptions(@Nonnull String annotationName, @Nonnull ExecutableElement method) throws ReactProcessorException {
        if (!method.getThrownTypes().isEmpty()) {
            throw new ReactProcessorException("@" + ProcessorUtil.toSimpleName(annotationName) + " target must not throw any exceptions", method);
        }
    }
}

