/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import react4j.processor.ProcessorUtil;
import react4j.processor.ReactProcessorException;

final class MethodChecks {
    private MethodChecks() {
    }

    static void mustBeAbstract(@Nonnull String annotationName, @Nonnull ExecutableElement method) throws ReactProcessorException {
        if (!method.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new ReactProcessorException("@" + ProcessorUtil.toSimpleName(annotationName) + " target must be abstract", method);
        }
    }

    static void mustNotBeAbstract(@Nonnull String annotationName, @Nonnull ExecutableElement method) throws ReactProcessorException {
        if (method.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new ReactProcessorException("@" + ProcessorUtil.toSimpleName(annotationName) + " target must not be abstract", method);
        }
    }

    static void mustBeStatic(@Nonnull String annotationName, @Nonnull Element method) throws ReactProcessorException {
        if (!method.getModifiers().contains((Object)Modifier.STATIC)) {
            throw new ReactProcessorException("@" + ProcessorUtil.toSimpleName(annotationName) + " target must be static", method);
        }
    }

    private static void mustNotBeStatic(@Nonnull String annotationName, @Nonnull Element method) throws ReactProcessorException {
        if (method.getModifiers().contains((Object)Modifier.STATIC)) {
            throw new ReactProcessorException("@" + ProcessorUtil.toSimpleName(annotationName) + " target must not be static", method);
        }
    }

    static void mustBeFinal(@Nonnull String annotationName, @Nonnull Element method) throws ReactProcessorException {
        if (!method.getModifiers().contains((Object)Modifier.FINAL)) {
            throw new ReactProcessorException("@" + ProcessorUtil.toSimpleName(annotationName) + " target must be final", method);
        }
    }

    static void mustNotBePrivate(@Nonnull String annotationName, @Nonnull Element method) throws ReactProcessorException {
        if (method.getModifiers().contains((Object)Modifier.PRIVATE)) {
            throw new ReactProcessorException("@" + ProcessorUtil.toSimpleName(annotationName) + " target must not be private", method);
        }
    }

    static void mustNotHaveAnyParameters(@Nonnull String annotationName, @Nonnull ExecutableElement method) throws ReactProcessorException {
        if (!method.getParameters().isEmpty()) {
            throw new ReactProcessorException("@" + ProcessorUtil.toSimpleName(annotationName) + " target must not have any parameters", method);
        }
    }

    static void mustReturnAValue(@Nonnull String annotationName, @Nonnull ExecutableElement method) throws ReactProcessorException {
        if (TypeKind.VOID == method.getReturnType().getKind()) {
            throw new ReactProcessorException("@" + ProcessorUtil.toSimpleName(annotationName) + " target must return a value", method);
        }
    }

    static void mustNotReturnAValue(@Nonnull String annotationName, @Nonnull ExecutableElement method) throws ReactProcessorException {
        if (TypeKind.VOID != method.getReturnType().getKind()) {
            throw new ReactProcessorException("@" + ProcessorUtil.toSimpleName(annotationName) + " target must not return a value", method);
        }
    }

    static void mustNotThrowAnyExceptions(@Nonnull String annotationName, @Nonnull ExecutableElement method) throws ReactProcessorException {
        if (!method.getThrownTypes().isEmpty()) {
            throw new ReactProcessorException("@" + ProcessorUtil.toSimpleName(annotationName) + " target must not throw any exceptions", method);
        }
    }

    static void mustBeSubclassCallable(@Nonnull TypeElement targetType, @Nonnull String annotationName, @Nonnull ExecutableElement method) throws ReactProcessorException {
        MethodChecks.mustNotBeStatic(annotationName, method);
        MethodChecks.mustNotBePrivate(annotationName, method);
        MethodChecks.mustNotBePackageAccessInDifferentPackage(targetType, annotationName, method);
    }

    static void mustNotBePackageAccessInDifferentPackage(@Nonnull TypeElement component, @Nonnull String annotationName, @Nonnull ExecutableElement method) throws ReactProcessorException {
        boolean isPackageAccess;
        Set<Modifier> modifiers = method.getModifiers();
        boolean bl = isPackageAccess = !modifiers.contains((Object)Modifier.PRIVATE) && !modifiers.contains((Object)Modifier.PROTECTED) && !modifiers.contains((Object)Modifier.PUBLIC);
        if (isPackageAccess) {
            Name methodPackageName;
            PackageElement packageElement = MethodChecks.getPackageElement(component);
            PackageElement methodPackageElement = MethodChecks.getPackageElement((TypeElement)method.getEnclosingElement());
            Name componentPackageName = null == packageElement ? null : packageElement.getQualifiedName();
            Name name = methodPackageName = null == methodPackageElement ? null : methodPackageElement.getQualifiedName();
            if (!Objects.equals(componentPackageName, methodPackageName)) {
                throw new ReactProcessorException("@" + ProcessorUtil.toSimpleName(annotationName) + " target must not be package access if the method is in a different package from the @ReactComponent", method);
            }
        }
    }

    @Nullable
    private static PackageElement getPackageElement(@Nonnull TypeElement element) {
        for (Element enclosingElement = element.getEnclosingElement(); null != enclosingElement; enclosingElement = enclosingElement.getEnclosingElement()) {
            if (!(enclosingElement instanceof PackageElement)) continue;
            return (PackageElement)enclosingElement;
        }
        return null;
    }
}

