/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.replicant.client.test;

import com.google.inject.Provides;
import javax.inject.Singleton;
import org.realityforge.guiceyloops.shared.AbstractModule;
import org.realityforge.replicant.client.EntityChangeBroker;
import org.realityforge.replicant.client.EntityRepository;
import org.realityforge.replicant.client.EntitySubscriptionManager;
import org.realityforge.replicant.client.EntitySystem;
import org.realityforge.replicant.client.EntitySystemImpl;
import org.realityforge.replicant.client.runtime.AreaOfInterestService;
import org.realityforge.replicant.client.runtime.AreaOfInterestServiceImpl;
import org.realityforge.replicant.client.runtime.ContextConverger;
import org.realityforge.replicant.client.runtime.ReplicantClientSystem;
import org.realityforge.replicant.client.test.TestContextConvergerImpl;

public class ReplicantClientTestModule
extends AbstractModule {
    protected void configure() {
        this.bindEntitySystem();
        this.bindContextConverger();
        this.bindReplicantClientSystem();
        this.bindAreaOfInterestService();
    }

    protected void bindEntitySystem() {
        this.bind(EntitySystem.class).to(EntitySystemImpl.class).asEagerSingleton();
    }

    protected void bindContextConverger() {
        this.bind(ContextConverger.class).to(TestContextConvergerImpl.class).asEagerSingleton();
    }

    protected void bindReplicantClientSystem() {
        this.bindMock(ReplicantClientSystem.class);
    }

    protected void bindAreaOfInterestService() {
        this.bind(AreaOfInterestService.class).to(AreaOfInterestServiceImpl.class).asEagerSingleton();
    }

    @Provides
    @Singleton
    public final EntityRepository getEntityRepository(EntitySystem system) {
        return system.getRepository();
    }

    @Provides
    @Singleton
    public final EntityChangeBroker getEntityChangeBroker(EntitySystem system) {
        return system.getChangeBroker();
    }

    @Provides
    @Singleton
    public final EntitySubscriptionManager getEntitySubscriptionManager(EntitySystem system) {
        return system.getSubscriptionManager();
    }
}

