/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.replicant.client.test.ee;

import java.lang.reflect.Field;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.persistence.EntityManager;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventAdapter;
import org.eclipse.persistence.descriptors.DescriptorEventListener;
import org.eclipse.persistence.sessions.Session;
import org.realityforge.replicant.client.EntitySystem;

public class ReplicantEntityCustomizer
extends DescriptorEventAdapter {
    private final EntitySystem _entitySystem;

    public ReplicantEntityCustomizer(@Nonnull EntitySystem entitySystem) {
        this._entitySystem = entitySystem;
    }

    public static void configure(@Nonnull EntityManager em, @Nonnull EntitySystem entitySystem) {
        Session session = (Session)em.unwrap(Session.class);
        for (Map.Entry entry : session.getDescriptors().entrySet()) {
            ((ClassDescriptor)entry.getValue()).getEventManager().addDefaultEventListener((DescriptorEventListener)new ReplicantEntityCustomizer(entitySystem));
        }
    }

    public void postBuild(DescriptorEvent event) {
        this.configureEntitySystem(event.getObject());
    }

    public void postMerge(DescriptorEvent event) {
        this.configureEntitySystem(event.getObject());
    }

    public void postRefresh(DescriptorEvent event) {
        this.configureEntitySystem(event.getObject());
    }

    public void preUpdate(DescriptorEvent event) {
        this.configureEntitySystem(event.getObject());
    }

    public void prePersist(DescriptorEvent event) {
        this.configureEntitySystem(event.getObject());
    }

    private void configureEntitySystem(Object object) {
        try {
            Field field = object.getClass().getDeclaredField("_$entitySystem");
            field.setAccessible(true);
            field.set(object, this._entitySystem);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to set field _$entitySystem", e);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }
}

