/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.tomcat;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.catalina.Manager;
import org.apache.catalina.session.StandardSession;
import org.redisson.api.RMap;
import org.redisson.api.RTopic;
import org.redisson.tomcat.AttributeRemoveMessage;
import org.redisson.tomcat.AttributeUpdateMessage;
import org.redisson.tomcat.AttributesClearMessage;
import org.redisson.tomcat.AttributesPutAllMessage;
import org.redisson.tomcat.RedissonSessionManager;

public class RedissonSession
extends StandardSession {
    private static final String IS_NEW_ATTR = "session:isNew";
    private static final String IS_VALID_ATTR = "session:isValid";
    private static final String THIS_ACCESSED_TIME_ATTR = "session:thisAccessedTime";
    private static final String MAX_INACTIVE_INTERVAL_ATTR = "session:maxInactiveInterval";
    private static final String LAST_ACCESSED_TIME_ATTR = "session:lastAccessedTime";
    private static final String CREATION_TIME_ATTR = "session:creationTime";
    public static final Set<String> ATTRS = new HashSet<String>(Arrays.asList("session:isNew", "session:isValid", "session:thisAccessedTime", "session:maxInactiveInterval", "session:lastAccessedTime", "session:creationTime"));
    private final RedissonSessionManager redissonManager;
    private final Map<String, Object> attrs;
    private RMap<String, Object> map;
    private RTopic topic;
    private final RedissonSessionManager.ReadMode readMode;
    private final RedissonSessionManager.UpdateMode updateMode;
    private static final long serialVersionUID = -2518607181636076487L;

    public RedissonSession(RedissonSessionManager manager, RedissonSessionManager.ReadMode readMode, RedissonSessionManager.UpdateMode updateMode) {
        super((Manager)manager);
        this.redissonManager = manager;
        this.readMode = readMode;
        this.updateMode = updateMode;
        try {
            Field attr = StandardSession.class.getDeclaredField("attributes");
            this.attrs = (Map)attr.get((Object)this);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Object getAttribute(String name) {
        if (this.readMode == RedissonSessionManager.ReadMode.REDIS) {
            return this.map.get((Object)name);
        }
        return super.getAttribute(name);
    }

    public void setId(String id, boolean notify) {
        super.setId(id, notify);
        this.map = this.redissonManager.getMap(id);
        this.topic = this.redissonManager.getTopic();
    }

    public void delete() {
        this.map.delete();
        if (this.readMode == RedissonSessionManager.ReadMode.MEMORY) {
            this.topic.publish((Object)new AttributesClearMessage(this.redissonManager.getNodeId(), this.getId()));
        }
        this.map = null;
    }

    public void setCreationTime(long time) {
        super.setCreationTime(time);
        if (this.map != null) {
            HashMap<String, Object> newMap = new HashMap<String, Object>(3);
            newMap.put(CREATION_TIME_ATTR, this.creationTime);
            newMap.put(LAST_ACCESSED_TIME_ATTR, this.lastAccessedTime);
            newMap.put(THIS_ACCESSED_TIME_ATTR, this.thisAccessedTime);
            this.map.putAll(newMap);
            if (this.readMode == RedissonSessionManager.ReadMode.MEMORY) {
                this.topic.publish((Object)this.createPutAllMessage(newMap));
            }
        }
    }

    public void access() {
        super.access();
        if (this.map != null) {
            HashMap<String, Object> newMap = new HashMap<String, Object>(2);
            newMap.put(LAST_ACCESSED_TIME_ATTR, this.lastAccessedTime);
            newMap.put(THIS_ACCESSED_TIME_ATTR, this.thisAccessedTime);
            this.map.putAll(newMap);
            if (this.readMode == RedissonSessionManager.ReadMode.MEMORY) {
                this.topic.publish((Object)this.createPutAllMessage(newMap));
            }
            if (this.getMaxInactiveInterval() >= 0) {
                this.map.expire((long)this.getMaxInactiveInterval(), TimeUnit.SECONDS);
            }
        }
    }

    protected AttributesPutAllMessage createPutAllMessage(Map<String, Object> newMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : newMap.entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
        return new AttributesPutAllMessage(this.redissonManager.getNodeId(), this.getId(), map);
    }

    public void setMaxInactiveInterval(int interval) {
        super.setMaxInactiveInterval(interval);
        if (this.map != null) {
            this.fastPut(MAX_INACTIVE_INTERVAL_ATTR, this.maxInactiveInterval);
            if (this.maxInactiveInterval >= 0) {
                this.map.expire((long)this.getMaxInactiveInterval(), TimeUnit.SECONDS);
            }
        }
    }

    private void fastPut(String name, Object value) {
        this.map.fastPut((Object)name, value);
        if (this.readMode == RedissonSessionManager.ReadMode.MEMORY) {
            this.topic.publish((Object)new AttributeUpdateMessage(this.redissonManager.getNodeId(), this.getId(), name, value));
        }
    }

    public void setValid(boolean isValid) {
        super.setValid(isValid);
        if (this.map != null) {
            if (!isValid && !this.map.isExists()) {
                return;
            }
            this.fastPut(IS_VALID_ATTR, isValid);
        }
    }

    public void setNew(boolean isNew) {
        super.setNew(isNew);
        if (this.map != null) {
            this.fastPut(IS_NEW_ATTR, isNew);
        }
    }

    public void endAccess() {
        boolean oldValue = this.isNew;
        super.endAccess();
        if (this.isNew != oldValue) {
            this.fastPut(IS_NEW_ATTR, this.isNew);
        }
    }

    public void superSetAttribute(String name, Object value, boolean notify) {
        super.setAttribute(name, value, notify);
    }

    public void setAttribute(String name, Object value, boolean notify) {
        super.setAttribute(name, value, notify);
        if (this.updateMode == RedissonSessionManager.UpdateMode.DEFAULT && this.map != null && value != null) {
            this.fastPut(name, value);
        }
    }

    public void superRemoveAttributeInternal(String name, boolean notify) {
        super.removeAttributeInternal(name, notify);
    }

    protected void removeAttributeInternal(String name, boolean notify) {
        super.removeAttributeInternal(name, notify);
        if (this.updateMode == RedissonSessionManager.UpdateMode.DEFAULT && this.map != null) {
            this.map.fastRemove((Object[])new String[]{name});
            if (this.readMode == RedissonSessionManager.ReadMode.MEMORY) {
                this.topic.publish((Object)new AttributeRemoveMessage(this.redissonManager.getNodeId(), this.getId(), name));
            }
        }
    }

    public void save() {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        newMap.put(CREATION_TIME_ATTR, this.creationTime);
        newMap.put(LAST_ACCESSED_TIME_ATTR, this.lastAccessedTime);
        newMap.put(THIS_ACCESSED_TIME_ATTR, this.thisAccessedTime);
        newMap.put(MAX_INACTIVE_INTERVAL_ATTR, this.maxInactiveInterval);
        newMap.put(IS_VALID_ATTR, this.isValid);
        newMap.put(IS_NEW_ATTR, this.isNew);
        if (this.attrs != null) {
            for (Map.Entry<String, Object> entry : this.attrs.entrySet()) {
                newMap.put(entry.getKey(), entry.getValue());
            }
        }
        this.map.putAll(newMap);
        if (this.readMode == RedissonSessionManager.ReadMode.MEMORY) {
            this.topic.publish((Object)this.createPutAllMessage(newMap));
        }
        if (this.maxInactiveInterval >= 0) {
            this.map.expire((long)this.getMaxInactiveInterval(), TimeUnit.SECONDS);
        }
    }

    public void load(Map<String, Object> attrs) {
        Boolean isNew;
        Boolean isValid;
        Long thisAccessedTime;
        Integer maxInactiveInterval;
        Long lastAccessedTime;
        Long creationTime = (Long)attrs.remove(CREATION_TIME_ATTR);
        if (creationTime != null) {
            this.creationTime = creationTime;
        }
        if ((lastAccessedTime = (Long)attrs.remove(LAST_ACCESSED_TIME_ATTR)) != null) {
            this.lastAccessedTime = lastAccessedTime;
        }
        if ((maxInactiveInterval = (Integer)attrs.remove(MAX_INACTIVE_INTERVAL_ATTR)) != null) {
            this.maxInactiveInterval = maxInactiveInterval;
        }
        if ((thisAccessedTime = (Long)attrs.remove(THIS_ACCESSED_TIME_ATTR)) != null) {
            this.thisAccessedTime = thisAccessedTime;
        }
        if ((isValid = (Boolean)attrs.remove(IS_VALID_ATTR)) != null) {
            this.isValid = isValid;
        }
        if ((isNew = (Boolean)attrs.remove(IS_NEW_ATTR)) != null) {
            this.isNew = isNew;
        }
        for (Map.Entry<String, Object> entry : attrs.entrySet()) {
            super.setAttribute(entry.getKey(), entry.getValue(), false);
        }
    }
}

