/*
 * Decompiled with CFR 0.152.
 */
package org.reekwest.http.client;

import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.reekwest.http.core.Request;
import org.reekwest.http.core.Response;
import org.reekwest.http.core.Status;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u0004B\u000f\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0002H\u0096\u0002J\f\u0010\f\u001a\u00020\r*\u00020\u0002H\u0002J3\u0010\u000e\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010j\u0002`\u00120\u000fj\u0002`\u0013*\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u000e\u001a\u00060\u0017j\u0002`\u0018*\u00020\u0019H\u0002J\f\u0010\u000e\u001a\u00020\u001a*\u00020\u001bH\u0002J\f\u0010\u001c\u001a\u00020\u0003*\u00020\u001dH\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001e"}, d2={"Lorg/reekwest/http/client/ApacheHttpClient;", "Lkotlin/Function1;", "Lorg/reekwest/http/core/Request;", "Lorg/reekwest/http/core/Response;", "Lorg/reekwest/http/core/HttpHandler;", "client", "Lorg/apache/http/impl/client/CloseableHttpClient;", "(Lorg/apache/http/impl/client/CloseableHttpClient;)V", "getClient", "()Lorg/apache/http/impl/client/CloseableHttpClient;", "invoke", "request", "toApacheRequest", "Lorg/apache/http/client/methods/HttpRequestBase;", "toTarget", "", "Lkotlin/Pair;", "", "Lorg/reekwest/http/core/Parameter;", "Lorg/reekwest/http/core/Headers;", "", "Lorg/apache/http/Header;", "([Lorg/apache/http/Header;)Ljava/util/List;", "Ljava/nio/ByteBuffer;", "Lorg/reekwest/http/core/Body;", "Lorg/apache/http/HttpEntity;", "Lorg/reekwest/http/core/Status;", "Lorg/apache/http/StatusLine;", "toUtterlyIdleResponse", "Lorg/apache/http/client/methods/CloseableHttpResponse;", "reekwest-client-apache_main"})
public final class ApacheHttpClient
implements Function1<Request, Response> {
    @NotNull
    private final CloseableHttpClient client;

    @NotNull
    public Response invoke(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return this.toUtterlyIdleResponse(this.client.execute((HttpUriRequest)this.toApacheRequest(request)));
    }

    private final Response toUtterlyIdleResponse(@NotNull CloseableHttpResponse $receiver) {
        return new Response(this.toTarget($receiver.getStatusLine()), this.toTarget($receiver.getAllHeaders()), this.toTarget($receiver.getEntity()));
    }

    private final HttpRequestBase toApacheRequest(@NotNull Request $receiver) {
        return (HttpRequestBase)new HttpEntityEnclosingRequestBase($receiver){
            final /* synthetic */ Request receiver$0;

            @NotNull
            public String getMethod() {
                return this.receiver$0.getMethod().name();
            }
            {
                Pair it;
                Iterable $receiver$iv$iv;
                ByteArrayEntity byteArrayEntity;
                this.receiver$0 = $receiver;
                Request request = this.receiver$0;
                this.setURI(new URI(request.getUri().toString()));
                String string = String.valueOf(request.getBody());
                Object object = null;
                boolean bl = true;
                Iterator<T> iterator = null;
                ByteArrayEntity byteArrayEntity2 = byteArrayEntity;
                ByteArrayEntity byteArrayEntity3 = byteArrayEntity;
                Object object2 = this;
                if (bl & true) {
                    object = Charsets.UTF_8;
                }
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string2.getBytes((Charset)object);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray2 = byArray;
                byteArrayEntity2(byArray2);
                object2.setEntity((HttpEntity)byteArrayEntity3);
                Iterable $receiver$iv = request.getHeaders();
                object = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    it = (Pair)element$iv$iv;
                    if (!(Intrinsics.areEqual((Object)((String)it.getFirst()), (Object)"content-length") ^ true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    it = (Pair)item$iv$iv;
                    object2 = destination$iv$iv;
                    this.addHeader((String)it.getFirst(), (String)it.getSecond());
                    byteArrayEntity3 = Unit.INSTANCE;
                    object2.add(byteArrayEntity3);
                }
                List cfr_ignored_0 = (List)destination$iv$iv;
                this.setConfig(RequestConfig.custom().setRedirectsEnabled(false).setCookieSpec("ignoreCookies").build());
            }
        };
    }

    private final Status toTarget(@NotNull StatusLine $receiver) {
        int n = $receiver.getStatusCode();
        String string = $receiver.getReasonPhrase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"reasonPhrase");
        return new Status(n, string);
    }

    private final ByteBuffer toTarget(@NotNull HttpEntity $receiver) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(EntityUtils.toByteArray((HttpEntity)$receiver));
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.wrap(toByteArray(this))");
        return byteBuffer;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, String>> toTarget(@NotNull Header[] $receiver) {
        void $receiver$iv$iv;
        Object $receiver$iv = $receiver;
        Object[] objectArray = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(((Object[])$receiver$iv).length);
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void it;
            void item$iv$iv = $receiver$iv$iv[i];
            Header header = (Header)item$iv$iv;
            Collection collection = destination$iv$iv;
            Pair pair = TuplesKt.to((Object)it.getName(), (Object)it.getValue());
            collection.add(pair);
        }
        Object thisCollection$iv = $receiver$iv = (Collection)((List)destination$iv$iv);
        Pair[] pairArray = thisCollection$iv.toArray(new Pair[thisCollection$iv.size()]);
        if (pairArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return CollectionsKt.listOf((Object[])Arrays.copyOf(pairArray, pairArray.length));
    }

    @NotNull
    public final CloseableHttpClient getClient() {
        return this.client;
    }

    public ApacheHttpClient(@NotNull CloseableHttpClient client) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.client = client;
    }

    public /* synthetic */ ApacheHttpClient(CloseableHttpClient closeableHttpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            CloseableHttpClient closeableHttpClient2 = HttpClients.createDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpClient2, (String)"HttpClients.createDefault()");
            closeableHttpClient = closeableHttpClient2;
        }
        this(closeableHttpClient);
    }

    public ApacheHttpClient() {
        this(null, 1, null);
    }
}

