// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.audio;

/**
 * Provides an accessor for a bits/sample per channel property.
 */
public interface BitsPerSampleAccessor {

	/**
	 * Retrieves the bits/sample per channel from the bits/sample per channel
	 * property.
	 * 
	 * @return The bits/sample per channel stored by the bits/sample per channel
	 *         property.
	 */
	BitsPerSample getBitsPerSample();

	/**
	 * Provides a mutator for a bits/sample per channel property.
	 */
	public interface BitsPerSampleMutator {

		/**
		 * Sets the bits/sample per channel for the bits/sample per channel
		 * property.
		 * 
		 * @param aBitsPerSample The bits/sample per channel to be stored by the
		 *        sampling rate property.
		 */
		void setBitsPerSample( BitsPerSample aBitsPerSample );
	}

	/**
	 * Provides a builder method for a bits/sample per channel property
	 * returning the builder for applying multiple build operations.
	 * 
	 * @param <B> The builder to return in order to be able to apply multiple
	 *        build operations.
	 */
	public interface BitsPerSampleBuilder<B extends BitsPerSampleBuilder<B>> {

		/**
		 * Sets the bits/sample per channel for the bits/sample per channel
		 * property.
		 * 
		 * @param aBitsPerSample The bits/sample per channel to be stored by the
		 *        sampling rate property.
		 * 
		 * @return The builder for applying multiple build operations.
		 */
		B withBitsPerSample( BitsPerSample aBitsPerSample );
	}

	/**
	 * Provides a bits/sample per channel property.
	 */
	public interface BitsPerSampleProperty extends BitsPerSampleAccessor, BitsPerSampleMutator {

		/**
		 * This method stores and passes through the given argument, which is
		 * very useful for builder APIs: Sets the given {@link BitsPerSample}
		 * (setter) as of {@link #setBitsPerSample(BitsPerSample)} and returns
		 * the very same value (getter).
		 * 
		 * @param aBitsPerSample The {@link BitsPerSample} to set (via
		 *        {@link #setBitsPerSample(BitsPerSample)}).
		 * 
		 * @return Returns the value passed for it to be used in conclusive
		 *         processing steps.
		 */
		default BitsPerSample letBitsPerSample( BitsPerSample aBitsPerSample ) {
			setBitsPerSample( aBitsPerSample );
			return aBitsPerSample;
		}
	}
}
