// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.audio;

/**
 * A {@link MonoSampleImpl} represents a single amplitude (one for the mono
 * channel) assigned to an according time positioning.
 */
public class MonoSampleImpl extends SoundSampleImpl implements MonoSample {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Constructs a {@link MonoSample} instance with the according sound
	 * sample's settings
	 * 
	 * @param aSample The mono sample (a single value representing the mono
	 *        channel) for the related time positioning.
	 */
	public MonoSampleImpl( MonoSample aSample ) {
		super( aSample );
	}

	/**
	 * Constructs a {@link MonoSample} instance with the according time and
	 * sample settings.
	 * 
	 * @param aSample The mono sample (a single value representing the mono
	 *        channel) for the related time positioning.
	 */
	public MonoSampleImpl( double aSample ) {
		super( new double[] {
				aSample
		} );
	}

	/**
	 * Constructs a {@link MonoSample} instance with the according time and
	 * sample settings.
	 * 
	 * @param aTimeMillis The time positioning of this sound sample.
	 * @param aSample The mono sample (a single value representing the mono
	 *        channel) for the related time positioning.
	 */
	public MonoSampleImpl( double aTimeMillis, double aSample ) {
		super( aTimeMillis, new double[] {
				aSample
		} );
		;
	}

	/**
	 * Constructs a {@link MonoSample} instance with the according time and
	 * sample settings.
	 * 
	 * @param aTimeMillis The time positioning of this sound sample.
	 * @param aSample The mono sample (a single value representing the mono
	 *        channel) for the related time positioning.
	 * @param aSamplingRate The sampling rate for the given sample.
	 */
	public MonoSampleImpl( double aTimeMillis, double aSample, int aSamplingRate ) {
		super( aTimeMillis, new double[] {
				aSample
		}, aSamplingRate );
	}

	/**
	 * Constructs a {@link MonoSample} instance with the according time and
	 * sample settings.
	 * 
	 * @param aSample The mono sample (a single value representing the mono
	 *        channel) for the related time positioning.
	 * @param aSamplingRate The sampling rate for the given sample.
	 */
	public MonoSampleImpl( double aSample, int aSamplingRate ) {
		super( new double[] {
				aSample
		}, aSamplingRate );
	}

	/**
	 * Constructs a {@link MonoSample} instance with the according time and
	 * sample settings.
	 * 
	 * @param aIndex The index of the sample according to its position in the
	 *        sample sequence (e.g. sound file).
	 * @param aSample The mono sample (a single value representing the mono
	 *        channel) for the related time positioning.
	 */
	public MonoSampleImpl( long aIndex, double aSample ) {
		super( aIndex, new double[] {
				aSample
		} );
	}

	/**
	 * Constructs a {@link MonoSample} instance with the according time and
	 * sample settings.
	 * 
	 * @param aIndex The index of the sample according to its position in the
	 *        sample sequence (e.g. sound file).
	 * @param aSample The mono sample (a single value representing the mono
	 *        channel) for the related time positioning.
	 * @param aSamplingRate The sampling rate for the given sample.
	 */
	public MonoSampleImpl( long aIndex, double aSample, int aSamplingRate ) {
		super( aIndex, new double[] {
				aSample
		}, aSamplingRate );
	}

	/**
	 * Constructs a {@link MonoSample} instance with the according time and
	 * sample settings.
	 * 
	 * @param aIndex The index of the sample according to its position in the
	 *        sample sequence (e.g. sound file).
	 * @param aTimeMillis The time positioning of this sound sample.
	 * @param aSample The mono sample (a single value representing the mono
	 *        channel) for the related time positioning.
	 */
	public MonoSampleImpl( long aIndex, double aTimeMillis, double aSample ) {
		super( aIndex, aTimeMillis, new double[] {
				aSample
		} );
	}

	/**
	 * Constructs a {@link MonoSample} instance with the according time and
	 * sample settings.
	 * 
	 * @param aIndex The index of the sample according to its position in the
	 *        sample sequence (e.g. sound file).
	 * @param aTimeMillis The time positioning of this sound sample.
	 * @param aSample The mono sample (a single value representing the mono
	 *        channel) for the related time positioning.
	 * @param aSamplingRate The sampling rate for the given sample.
	 */
	public MonoSampleImpl( long aIndex, double aTimeMillis, double aSample, int aSamplingRate ) {
		super( aIndex, aTimeMillis, new double[] {
				aSample
		}, aSamplingRate );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return "MonoSampleImpl [index=" + getIndex() + ", timeStamp=" + getTimeStamp() + ", sampleData=" + getMonoData() + ", sampligRate=" + getSamplingRate() + "]";
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
