/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipException;
import org.refcodes.audio.SampleReader;
import org.refcodes.audio.SoundSample;
import org.refcodes.tabular.CsvStringRecordReader;

public abstract class AbstractCsvSampleReader<S extends SoundSample>
implements SampleReader<S> {
    protected CsvStringRecordReader _csvReader;
    private boolean _hasHeader = false;

    public AbstractCsvSampleReader(File aFile) throws ZipException, IOException {
        this(new CsvStringRecordReader(aFile));
    }

    public AbstractCsvSampleReader(InputStream aInputStream) throws IOException {
        this(new CsvStringRecordReader(aInputStream));
    }

    protected AbstractCsvSampleReader(CsvStringRecordReader aCsvReader) {
        this._csvReader = aCsvReader;
    }

    public boolean hasNext() {
        try {
            this.doProbeHeader();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this._csvReader.hasNext();
    }

    @Override
    public void close() throws IOException {
        this._csvReader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProbeHeader() throws IOException {
        if (!this._hasHeader) {
            AbstractCsvSampleReader abstractCsvSampleReader = this;
            synchronized (abstractCsvSampleReader) {
                if (!this._hasHeader) {
                    this._csvReader.readHeader();
                    this._hasHeader = true;
                }
            }
        }
    }
}

