/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.refcodes.audio.BitsPerSample;
import org.refcodes.audio.LineOutSampleWriter;
import org.refcodes.audio.SoundSample;
import org.refcodes.exception.BugException;

public abstract class AbstractLineOutSampleWriter<S extends SoundSample, B extends LineOutSampleWriter<S, B>>
implements LineOutSampleWriter<S, B> {
    protected static final long MAX_16_BIT = 65535L;
    protected static final long MAX_8_BIT = 255L;
    protected BitsPerSample _bitsPerSample = BitsPerSample.HIGH_RES;

    public AbstractLineOutSampleWriter() {
    }

    public AbstractLineOutSampleWriter(BitsPerSample aBitsPerSample) {
        this._bitsPerSample = aBitsPerSample;
    }

    @Override
    public void setBitsPerSample(BitsPerSample aBitsPerSample) {
        this._bitsPerSample = aBitsPerSample;
    }

    @Override
    public BitsPerSample getBitsPerSample() {
        return this._bitsPerSample;
    }

    protected long toWavSample(double eSampleData) {
        switch (this._bitsPerSample) {
            case HIGH_RES: {
                return (long)(eSampleData * 32767.0);
            }
            case LOW_RES: {
                return (long)(eSampleData * 127.0);
            }
        }
        throw new BugException("Missing case statement for <" + this._bitsPerSample + "> in implementation!");
    }

    protected static SourceDataLine toLineOut(SoundSample aSoundSample, BitsPerSample aBitsPerSample) throws LineUnavailableException {
        AudioSystem.getMixerInfo();
        AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, aSoundSample.getSamplingRate(), aBitsPerSample.getBitCount() * aSoundSample.getChannelCount(), aSoundSample.getChannelCount(), aBitsPerSample.getByteCount() * aSoundSample.getChannelCount(), aSoundSample.getSamplingRate(), true);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        SourceDataLine theLine = (SourceDataLine)AudioSystem.getLine(info);
        theLine.open();
        theLine.start();
        return theLine;
    }
}

