/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.refcodes.audio.SampleWriter;
import org.refcodes.audio.SoundSample;

public abstract class AbstractSvgSampleWriter<S extends SoundSample, B extends SampleWriter<S, B>>
implements SampleWriter<S, B> {
    protected PrintStream _printStream;

    public AbstractSvgSampleWriter(File aFile) throws FileNotFoundException {
        this(new PrintStream(aFile));
    }

    public AbstractSvgSampleWriter(OutputStream aOutputStream) {
        this(new PrintStream(aOutputStream));
    }

    public AbstractSvgSampleWriter(PrintStream aPrintStream) {
        this._printStream = aPrintStream;
    }

    @Override
    public void close() throws IOException {
        this._printStream.println("</svg>");
        this._printStream.close();
    }

    protected double toYCoordinate(double aSampleData, double aFactor) {
        return aSampleData * aFactor / 2.0 + aFactor / 2.0;
    }

    protected void writeSvgHeader() {
        this._printStream.println("<svg>");
    }

    protected static String toString(double aDouble) {
        return AbstractSvgSampleWriter.format(Double.toString(aDouble));
    }

    protected static double toDouble(String aDouble) {
        return Double.valueOf(AbstractSvgSampleWriter.format(aDouble));
    }

    protected static String format(String aDouble) {
        int index = aDouble.indexOf(46);
        if (index == -1) {
            index = aDouble.indexOf(44);
        }
        if (index != -1) {
            while (aDouble.endsWith("0")) {
                aDouble = aDouble.substring(0, aDouble.length() - 1);
            }
            if (aDouble.endsWith(".") || aDouble.endsWith(",")) {
                aDouble = aDouble.substring(0, aDouble.length() - 1);
            }
        }
        return aDouble;
    }
}

