/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.zip.ZipException;
import org.refcodes.audio.AbstractCsvSampleReader;
import org.refcodes.audio.CsvSoundSampleWriter;
import org.refcodes.audio.MonoSample;
import org.refcodes.audio.MonoSampleBuilderImpl;
import org.refcodes.audio.MonoSampleImpl;
import org.refcodes.audio.MonoSampleReader;
import org.refcodes.audio.SamplingRate;
import org.refcodes.tabular.CsvStringRecordReader;
import org.refcodes.tabular.Record;

public class CsvMonoSampleReader
extends AbstractCsvSampleReader<MonoSample>
implements MonoSampleReader {
    private MonoSampleBuilderImpl _soundSample = new MonoSampleBuilderImpl(0L, SamplingRate.AUDIO_CD.getSamplesPerSecond());

    public CsvMonoSampleReader(File aFile) throws ZipException, IOException {
        super(aFile);
    }

    public CsvMonoSampleReader(InputStream aInputStream) throws IOException {
        super(aInputStream);
    }

    protected CsvMonoSampleReader(CsvStringRecordReader aCsvReader) {
        super(aCsvReader);
    }

    public MonoSample nextRow() throws IOException {
        String theTimeStamp;
        String eSampleDataCsv;
        this.doProbeHeader();
        Record theSampleCsv = this._csvReader.next();
        double theSamplingData = 0.0;
        if (theSampleCsv.containsKey((Object)"sample_data") && (eSampleDataCsv = (String)theSampleCsv.get((Object)"sample_data")) != null) {
            theSamplingData = CsvSoundSampleWriter.toDouble(eSampleDataCsv);
        }
        this._soundSample.setMonoData(theSamplingData);
        String theIndex = (String)theSampleCsv.get((Object)"index");
        if (theIndex != null && theIndex.length() != 0) {
            this._soundSample.setIndex(Long.parseLong(theIndex));
        } else {
            this._soundSample.increaseIndex();
        }
        String theSamplingRate = (String)theSampleCsv.get((Object)"sampling_rate");
        if (theSamplingRate != null && theSamplingRate.length() != 0) {
            this._soundSample.setSamplingRate(Integer.parseInt(theSamplingRate));
        }
        if ((theTimeStamp = (String)theSampleCsv.get((Object)"time_stamp")) != null && theTimeStamp.length() != 0) {
            BigDecimal theDecimal = new BigDecimal(theTimeStamp);
            this._soundSample.setTimeStamp(theDecimal.doubleValue());
        } else {
            this._soundSample.updateTimeStamp();
        }
        return new MonoSampleImpl(this._soundSample);
    }

    public String nextRaw() {
        return this._csvReader.nextRaw();
    }

    @Override
    public double nextMonoData() throws IOException {
        return this.nextRow().getMonoData();
    }

    @Override
    public int getSamplingRate() {
        return this._soundSample.getSamplingRate();
    }

    public long getIndex() {
        return this._soundSample.getIndex();
    }
}

