/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.refcodes.audio.AbstractCsvSampleWriter;
import org.refcodes.audio.CsvDeltaMode;
import org.refcodes.audio.MonoSample;
import org.refcodes.audio.MonoSampleBuilder;
import org.refcodes.audio.MonoSampleBuilderImpl;
import org.refcodes.audio.MonoSampleWriter;
import org.refcodes.audio.SamplingRate;

public class CsvMonoSampleWriter
extends AbstractCsvSampleWriter<MonoSample, CsvMonoSampleWriter>
implements MonoSampleWriter<CsvMonoSampleWriter> {
    private MonoSampleBuilder _soundSample = new MonoSampleBuilderImpl(0L, SamplingRate.AUDIO_CD.getSamplesPerSecond());
    private boolean _hasHeader = false;
    private boolean _isSampleDataDirty = true;
    private boolean _isSamplingRateDirty = true;

    public CsvMonoSampleWriter(File aFile) throws FileNotFoundException {
        super(aFile);
    }

    public CsvMonoSampleWriter(OutputStream aOutputStream) {
        super(aOutputStream);
    }

    public CsvMonoSampleWriter(PrintStream aPrintStream) {
        super(aPrintStream);
    }

    public CsvMonoSampleWriter(File aFile, CsvDeltaMode aDeltaMode) throws FileNotFoundException {
        super(aFile, aDeltaMode);
    }

    public CsvMonoSampleWriter(OutputStream aOutputStream, CsvDeltaMode aDeltaMode) {
        super(aOutputStream, aDeltaMode);
    }

    public CsvMonoSampleWriter(PrintStream aPrintStream, CsvDeltaMode aDeltaMode) {
        super(aPrintStream, aDeltaMode);
    }

    @Override
    public void writeNext(double aSampleData) {
        this.doUpdateSampleData(aSampleData);
        this._soundSample.updateTimeStamp();
        this.writeNext(this._soundSample);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeNext(MonoSample aSample) {
        double theSample = aSample.getMonoData();
        Object[] theRow = new String[4];
        if (!this._hasHeader) {
            CsvMonoSampleWriter csvMonoSampleWriter = this;
            synchronized (csvMonoSampleWriter) {
                if (!this._hasHeader) {
                    theRow[0] = "index";
                    theRow[1] = "time_stamp";
                    theRow[2] = "sample_data";
                    theRow[theRow.length - 1] = "sampling_rate";
                    this._csvWriter.writeHeader((String[])theRow);
                    this._hasHeader = true;
                }
            }
        }
        if (aSample != this._soundSample) {
            this.doUpdateSampleData(aSample.getMonoData());
            if (aSample.getSamplingRate() != -1 && aSample.getSamplingRate() != this._soundSample.getSamplingRate()) {
                this._soundSample.setSamplingRate(aSample.getSamplingRate());
                this._isSamplingRateDirty = true;
            }
            if (aSample.getIndex() != -1L) {
                this._soundSample.setIndex(aSample.getIndex());
            }
            if (aSample.getTimeStamp() != -1.0) {
                this._soundSample.setTimeStamp(aSample.getTimeStamp());
            }
        }
        theRow[0] = Long.toString(this._soundSample.getIndex());
        theRow[1] = CsvMonoSampleWriter.toString(this._soundSample.getTimeStamp());
        if (!this._deltaMode.isSampleDataDelta() || this._isSampleDataDirty) {
            theRow[2] = CsvMonoSampleWriter.toString(theSample);
        }
        if (!this._deltaMode.isSamplingRateDelta() || this._isSamplingRateDirty) {
            theRow[theRow.length - 1] = Integer.toString(this._soundSample.getSamplingRate());
        }
        this._csvWriter.writeNext(theRow);
        this._soundSample.increaseIndex();
        this._isSampleDataDirty = false;
        this._isSamplingRateDirty = false;
    }

    @Override
    public int getSamplingRate() {
        return this._soundSample.getSamplingRate();
    }

    @Override
    public void setSamplingRate(int aSamplingRate) {
        if (aSamplingRate != -1 && aSamplingRate != this._soundSample.getSamplingRate()) {
            this._soundSample.setSamplingRate(aSamplingRate);
            this._isSamplingRateDirty = true;
        }
    }

    @Override
    public CsvMonoSampleWriter withSamplingRate(int aSamplingRate) {
        this.setSamplingRate(aSamplingRate);
        return this;
    }

    private void doUpdateSampleData(double aSampleData) {
        double theSampleData = this._soundSample.getMonoData();
        if (theSampleData != aSampleData) {
            this._isSampleDataDirty = true;
        }
        this._soundSample.setMonoData(aSampleData);
    }
}

