/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.zip.ZipException;
import org.refcodes.audio.AbstractCsvSampleReader;
import org.refcodes.audio.CsvSoundSampleWriter;
import org.refcodes.audio.SamplingRate;
import org.refcodes.audio.SoundSample;
import org.refcodes.audio.SoundSampleBuilderImpl;
import org.refcodes.audio.SoundSampleImpl;
import org.refcodes.audio.SoundSampleReader;
import org.refcodes.tabular.CsvStringRecordReader;
import org.refcodes.tabular.Record;

public class CsvSoundSampleReader
extends AbstractCsvSampleReader<SoundSample>
implements SoundSampleReader {
    private SoundSampleBuilderImpl _soundSample = new SoundSampleBuilderImpl(0L, SamplingRate.AUDIO_CD.getSamplesPerSecond());

    public CsvSoundSampleReader(File aFile) throws ZipException, IOException {
        super(aFile);
    }

    public CsvSoundSampleReader(InputStream aInputStream) throws IOException {
        super(aInputStream);
    }

    protected CsvSoundSampleReader(CsvStringRecordReader aCsvReader) {
        super(aCsvReader);
    }

    public SoundSample nextRow() throws IOException {
        String theTimeStamp;
        this.doProbeHeader();
        Record theSampleCsv = this._csvReader.next();
        ArrayList<Double> theSamplingDatas = new ArrayList<Double>();
        if (theSampleCsv.containsKey((Object)"sample_data")) {
            eSampleDataCsv = (String)theSampleCsv.get((Object)"sample_data");
            theSamplingDatas.add(eSampleDataCsv != null ? Double.valueOf(CsvSoundSampleWriter.toDouble(eSampleDataCsv)) : null);
        } else {
            int index = 0;
            String eKey = "channel_" + index;
            while (theSampleCsv.containsKey((Object)eKey)) {
                eSampleDataCsv = (String)theSampleCsv.get((Object)eKey);
                theSamplingDatas.add(eSampleDataCsv != null ? Double.valueOf(CsvSoundSampleWriter.toDouble(eSampleDataCsv)) : null);
                eKey = "channel_" + ++index;
            }
        }
        double[] theSample = this._soundSample.getSampleData();
        if (theSample == null || theSample.length == 0) {
            theSample = new double[theSamplingDatas.size()];
            this._soundSample.setSampleData(theSample);
        }
        for (int i = 0; i < theSample.length; ++i) {
            if (theSamplingDatas.get(i) == null) continue;
            theSample[i] = (Double)theSamplingDatas.get(i);
        }
        String theIndex = (String)theSampleCsv.get((Object)"index");
        if (theIndex != null && theIndex.length() != 0) {
            this._soundSample.setIndex(Long.parseLong(theIndex));
        } else {
            this._soundSample.increaseIndex();
        }
        String theSamplingRate = (String)theSampleCsv.get((Object)"sampling_rate");
        if (theSamplingRate != null && theSamplingRate.length() != 0) {
            this._soundSample.setSamplingRate(Integer.parseInt(theSamplingRate));
        }
        if ((theTimeStamp = (String)theSampleCsv.get((Object)"time_stamp")) != null && theTimeStamp.length() != 0) {
            BigDecimal theDecimal = new BigDecimal(theTimeStamp);
            this._soundSample.setTimeStamp(theDecimal.toBigInteger().doubleValue());
        } else {
            this._soundSample.updateTimeStamp();
        }
        return new SoundSampleImpl(this._soundSample);
    }

    public String nextRaw() {
        return this._csvReader.nextRaw();
    }

    @Override
    public double[] nextSampleData() throws IOException {
        return this.nextRow().getSampleData();
    }

    @Override
    public int getSamplingRate() {
        return this._soundSample.getSamplingRate();
    }

    public long getIndex() {
        return this._soundSample.getIndex();
    }
}

