/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.util.function.Function;
import org.refcodes.audio.CurveFunctionFunction;
import org.refcodes.audio.CurveFunctionSoundSampleBuilderImpl;
import org.refcodes.audio.MonoSample;
import org.refcodes.audio.MonoSampleBuilder;
import org.refcodes.audio.MonoSampleBuilderImpl;
import org.refcodes.audio.SamplingRateAccessor;

public interface CurveFunctionSoundSampleBuilder
extends SamplingRateAccessor.SamplingRateProperty,
SamplingRateAccessor.SamplingRateBuilder<CurveFunctionSoundSampleBuilder> {
    public void setTrigonometricFunction(Function<Double, Double> var1);

    public Function<Double, Double> getTrigonometricFunction();

    default public CurveFunctionSoundSampleBuilder withTrigonometricFunction(Function<Double, Double> aFunction) {
        this.setTrigonometricFunction(aFunction);
        return this;
    }

    default public void setTrigonometricFunction(CurveFunctionFunction aFunction) {
        this.setTrigonometricFunction(aFunction.getFunction());
    }

    default public CurveFunctionSoundSampleBuilder withTrigonometricFunction(CurveFunctionFunction aFunction) {
        this.setTrigonometricFunction(aFunction.getFunction());
        return this;
    }

    public void setIndex(int var1);

    public int getIndex();

    default public CurveFunctionSoundSampleBuilder withIndex(int aIndex) {
        this.setIndex(aIndex);
        return this;
    }

    public void setFrequency(double var1);

    public double getFrequency();

    default public CurveFunctionSoundSampleBuilder withFrequency(double aFrequencyInHz) {
        this.setFrequency(aFrequencyInHz);
        return this;
    }

    public void setAmplitude(double var1);

    public double getAmplitude();

    default public CurveFunctionSoundSampleBuilder withAmplitude(double aAmplitude) {
        this.setAmplitude(aAmplitude);
        return this;
    }

    public void setXOffset(int var1);

    public int getXOffset();

    default public CurveFunctionSoundSampleBuilder withXOffset(int aXOffset) {
        this.setXOffset(aXOffset);
        return this;
    }

    public void setYOffset(double var1);

    public double getYOffset();

    default public CurveFunctionSoundSampleBuilder withYOffset(double aYOffset) {
        this.setYOffset(aYOffset);
        return this;
    }

    @Override
    default public CurveFunctionSoundSampleBuilder withSamplingRate(int aSamplingRate) {
        this.setSamplingRate(aSamplingRate);
        return null;
    }

    public MonoSample next();

    public MonoSample toMonoSample();

    public MonoSample toMonoSample(int var1);

    public static MonoSampleBuilder asMonoSample(double aIndex, Function<Double, Double> aFunction, double aFrequencyHz, double aAmplitude, int aXOffset, double aYOffset, int aSamplingRate) {
        double theTime = aIndex / (double)aSamplingRate;
        double theSample = aFunction.apply(Math.PI * 2 * (aIndex - (double)aXOffset) * aFrequencyHz / (double)aSamplingRate);
        theSample *= aAmplitude;
        return new MonoSampleBuilderImpl(theTime, theSample += aYOffset);
    }

    public static CurveFunctionSoundSampleBuilder build() {
        return new CurveFunctionSoundSampleBuilderImpl();
    }
}

