/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.io.IOException;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.refcodes.audio.AbstractLineOutSampleWriter;
import org.refcodes.audio.BitsPerSample;
import org.refcodes.audio.LineOutSampleWriter;
import org.refcodes.audio.MonoSample;
import org.refcodes.audio.MonoSampleBuilder;
import org.refcodes.audio.MonoSampleBuilderImpl;
import org.refcodes.audio.MonoSampleWriter;
import org.refcodes.audio.SamplingRate;
import org.refcodes.numerical.NumericalUtility;

public class LineOutMonoSampleWriter
extends AbstractLineOutSampleWriter<MonoSample, LineOutMonoSampleWriter>
implements LineOutSampleWriter<MonoSample, LineOutMonoSampleWriter>,
MonoSampleWriter<LineOutMonoSampleWriter> {
    private MonoSampleBuilder _soundSample = new MonoSampleBuilderImpl(0L, SamplingRate.AUDIO_CD.getSamplesPerSecond());
    private SourceDataLine _lineOut = null;

    @Override
    public LineOutMonoSampleWriter withBitsPerSample(BitsPerSample aBitsPerSample) {
        this.setBitsPerSample(aBitsPerSample);
        return this;
    }

    @Override
    public void writeNext(double aSampleData) throws IOException {
        this._soundSample.setMonoData(aSampleData);
        this._soundSample.updateTimeStamp();
        this.writeNext(this._soundSample);
    }

    @Override
    public void writeNext(MonoSample aSample) throws IOException {
        if (aSample != this._soundSample) {
            if (aSample.getIndex() != -1L) {
                this._soundSample.setIndex(aSample.getIndex());
            }
            if (aSample.getSamplingRate() != -1) {
                this._soundSample.setSamplingRate(aSample.getSamplingRate());
            }
            if (aSample.getTimeStamp() != -1.0) {
                this._soundSample.setTimeStamp(aSample.getTimeStamp());
            } else {
                this._soundSample.updateTimeStamp();
            }
            this._soundSample.setMonoData(aSample.getMonoData());
        }
        long eValue = this.toWavSample(this._soundSample.getMonoData());
        byte[] eBytes = NumericalUtility.toBigEndianBytes((long)eValue, (int)(this._soundSample.getChannelCount() * this._bitsPerSample.getByteCount()));
        try {
            SourceDataLine theLineOut = this.getLineOut();
            while (theLineOut.getBufferSize() < eBytes.length) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            theLineOut.write(eBytes, 0, eBytes.length);
        }
        catch (LineUnavailableException e) {
            throw new IOException("The audio-out line is unavailable: " + e.getMessage(), e);
        }
        this._soundSample.increaseIndex();
    }

    @Override
    public int getSamplingRate() {
        return this._soundSample.getSamplingRate();
    }

    @Override
    public void setSamplingRate(int aSamplingRate) {
        if (aSamplingRate != -1 && aSamplingRate != this._soundSample.getSamplingRate()) {
            this._soundSample.setSamplingRate(aSamplingRate);
        }
    }

    @Override
    public LineOutMonoSampleWriter withSamplingRate(int aSamplingRate) {
        this.setSamplingRate(aSamplingRate);
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this._lineOut != null) {
            this._lineOut.stop();
            this._lineOut.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SourceDataLine getLineOut() throws LineUnavailableException {
        if (this._lineOut == null) {
            LineOutMonoSampleWriter lineOutMonoSampleWriter = this;
            synchronized (lineOutMonoSampleWriter) {
                if (this._lineOut == null) {
                    this._lineOut = LineOutMonoSampleWriter.toLineOut(this._soundSample, this._bitsPerSample);
                }
            }
        }
        return this._lineOut;
    }
}

