/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

public enum SamplingRate {
    TELEPHONE(8000),
    LOWEST_PCM(11025),
    VOICE_OVER_IP(16000),
    LOW_PCM(22050),
    AUDIO_CD(44100),
    PROFESSIONAL(48000),
    HIGHER_PROFESSIONAL(88200),
    DVD_AUDIO(96000),
    HDC(176400),
    HIGH_PROFESSIONAL(192000),
    EXTREME(352800),
    HIGHEST(384800);

    private int _samplingRate;

    private SamplingRate(int aSamplingRate) {
        this._samplingRate = aSamplingRate;
    }

    public int getSamplesPerSecond() {
        return this._samplingRate;
    }

    public static SamplingRate getLowestSamplingRate() {
        return TELEPHONE;
    }

    public static SamplingRate getHigestSamplingRate() {
        return HIGHEST;
    }

    public SamplingRate getNextHigherSamplingRate() {
        return SamplingRate.toNextHigherSamplingRate(this);
    }

    public SamplingRate getPreviousLowerSamplingRate() {
        return SamplingRate.toPreviousLowerSamplingRate(this);
    }

    private static SamplingRate toNextHigherSamplingRate(SamplingRate aSamplingRate) {
        for (int i = 0; i < SamplingRate.values().length - 1; ++i) {
            if (aSamplingRate != SamplingRate.values()[i]) continue;
            return SamplingRate.values()[i + 1];
        }
        return null;
    }

    private static SamplingRate toPreviousLowerSamplingRate(SamplingRate aSamplingRate) {
        for (int i = 1; i < SamplingRate.values().length; ++i) {
            if (aSamplingRate != SamplingRate.values()[i]) continue;
            return SamplingRate.values()[i - 1];
        }
        return null;
    }
}

