/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.util.Arrays;
import org.refcodes.audio.SoundSample;
import org.refcodes.audio.SoundSampleBuilder;

public class SoundSampleBuilderImpl
implements SoundSampleBuilder {
    private double _timeStamp = -1.0;
    private int _sampligRate = -1;
    private double[] _sampleData = null;
    private long _index = -1L;

    public SoundSampleBuilderImpl(SoundSample aSoundSample) {
        this._index = aSoundSample.getIndex();
        this._timeStamp = aSoundSample.getTimeStamp();
        this._sampligRate = aSoundSample.getSamplingRate();
        if (aSoundSample.getSampleData() != null) {
            this._sampleData = Arrays.copyOf(aSoundSample.getSampleData(), aSoundSample.getChannelCount());
        }
    }

    public SoundSampleBuilderImpl(double[] aSampleData) {
        this._sampleData = aSampleData;
    }

    public SoundSampleBuilderImpl(double aTimeMillis, double[] aSampleData) {
        this._timeStamp = aTimeMillis;
        this._sampleData = aSampleData;
    }

    public SoundSampleBuilderImpl(double aTimeMillis, double[] aSampleData, int aSamplingRate) {
        this._timeStamp = aTimeMillis;
        this._sampleData = aSampleData;
        this._sampligRate = aSamplingRate;
    }

    public SoundSampleBuilderImpl(double[] aSampleData, int aSamplingRate) {
        this._sampleData = aSampleData;
        this._sampligRate = aSamplingRate;
    }

    public SoundSampleBuilderImpl(long aIndex, double[] aSampleData) {
        this._index = aIndex;
        this._sampleData = aSampleData;
    }

    public SoundSampleBuilderImpl(long aIndex, double[] aSampleData, int aSamplingRate) {
        this._index = aIndex;
        this._sampleData = aSampleData;
        this._sampligRate = aSamplingRate;
    }

    public SoundSampleBuilderImpl(long aIndex, double aTimeMillis, double[] aSampleData) {
        this._index = aIndex;
        this._timeStamp = aTimeMillis;
        this._sampleData = aSampleData;
    }

    public SoundSampleBuilderImpl(long aIndex, double aTimeMillis, double[] aSampleData, int aSamplingRate) {
        this._index = aIndex;
        this._timeStamp = aTimeMillis;
        this._sampleData = aSampleData;
        this._sampligRate = aSamplingRate;
    }

    public SoundSampleBuilderImpl(long aIndex, int aSamplingRate) {
        this._index = aIndex;
        this._sampligRate = aSamplingRate;
    }

    @Override
    public double[] getSampleData() {
        return this._sampleData;
    }

    @Override
    public double getTimeStamp() {
        return this._timeStamp;
    }

    @Override
    public int getSamplingRate() {
        return this._sampligRate;
    }

    public long getIndex() {
        return this._index;
    }

    public void setIndex(long aIndex) {
        this._index = aIndex;
    }

    public void increaseIndex() {
        ++this._index;
    }

    public void decreaseIndex() {
        --this._index;
    }

    @Override
    public void setSampleData(double[] aSampleData) {
        this._sampleData = aSampleData;
    }

    @Override
    public void setTimeStamp(double aTimeMillis) {
        this._timeStamp = aTimeMillis;
    }

    @Override
    public void setSamplingRate(int aSamplingRate) {
        this._sampligRate = aSamplingRate;
    }

    public String toString() {
        return "SoundSampleBuilderImpl [index=" + this.getIndex() + ", timeStamp=" + this.getTimeStamp() + ", sampleData=" + Arrays.toString(this.getSampleData()) + ", sampligRate=" + this.getSamplingRate() + "]";
    }
}

