/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import org.refcodes.audio.AbstractWavSampleWriter;
import org.refcodes.audio.BitsPerSample;
import org.refcodes.audio.SamplingRate;
import org.refcodes.audio.SoundSample;
import org.refcodes.audio.SoundSampleBuilder;
import org.refcodes.audio.SoundSampleBuilderImpl;
import org.refcodes.audio.SoundSampleWriter;
import org.refcodes.numerical.NumericalUtility;

public class WavSoundSampleWriter
extends AbstractWavSampleWriter<SoundSample, WavSoundSampleWriter>
implements SoundSampleWriter<WavSoundSampleWriter> {
    private SoundSampleBuilder _soundSample = new SoundSampleBuilderImpl(0L, SamplingRate.AUDIO_CD.getSamplesPerSecond());
    private boolean _hasHeader = false;

    public WavSoundSampleWriter(File aFile) throws FileNotFoundException {
        super(aFile);
    }

    public WavSoundSampleWriter(OutputStream aOutputStream) {
        super(aOutputStream);
    }

    @Override
    public WavSoundSampleWriter withBitsPerSample(BitsPerSample aBitsPerSample) {
        this.setBitsPerSample(aBitsPerSample);
        return this;
    }

    @Override
    public void writeNext(double ... aSampleData) throws IOException {
        if (aSampleData == null || aSampleData.length == 0) {
            throw new IllegalArgumentException("You must provide at least one sample value, bit you provided " + (aSampleData == null ? "<null>" : " an empty array") + "!");
        }
        this._soundSample.setSampleData(aSampleData);
        this._soundSample.updateTimeStamp();
        this.writeNext(this._soundSample);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeNext(SoundSample aSample) throws IOException {
        if (!this._hasHeader) {
            WavSoundSampleWriter wavSoundSampleWriter = this;
            synchronized (wavSoundSampleWriter) {
                if (!this._hasHeader) {
                    if (aSample.getSamplingRate() > 0) {
                        this.setSamplingRate(aSample.getSamplingRate());
                    }
                    this.writeHeader(this.getSamplingRate(), aSample.getChannelCount());
                    this._hasHeader = true;
                }
            }
        }
        for (int i = 0; i < aSample.getChannelCount(); ++i) {
            double eSampleData = aSample.getSampleData()[i];
            byte[] eBytes = NumericalUtility.toLittleEndianBytes((long)this.toWavSample(eSampleData), (int)this.getBitsPerSample().getByteCount());
            this._outputStream.write(eBytes);
        }
        this._soundSample.increaseIndex();
    }

    @Override
    public int getSamplingRate() {
        return this._soundSample.getSamplingRate();
    }

    @Override
    public void setSamplingRate(int aSamplingRate) {
        if (aSamplingRate != -1 && aSamplingRate != this._soundSample.getSamplingRate()) {
            this._soundSample.setSamplingRate(aSamplingRate);
        }
    }

    @Override
    public WavSoundSampleWriter withSamplingRate(int aSamplingRate) {
        this.setSamplingRate(aSamplingRate);
        return this;
    }
}

