/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import org.refcodes.audio.BitsPerSample;
import org.refcodes.audio.SoundSample;
import org.refcodes.audio.WavSampleWriter;
import org.refcodes.exception.BugException;
import org.refcodes.numerical.NumericalUtility;

public abstract class AbstractWavSampleWriter<S extends SoundSample, B extends WavSampleWriter<S, B>>
implements WavSampleWriter<S, B> {
    public static String RIFF = "RIFF";
    public static String WAVE = "WAVE";
    public static String FORMAT = "fmt ";
    public static String DATA = "data";
    protected static final long MAX_16_BIT = 65535L;
    protected static final long MAX_8_BIT = 255L;
    protected BufferedOutputStream _outputStream;
    protected File _file = null;
    protected BitsPerSample _bitsPerSample = BitsPerSample.HIGH_RES;

    public AbstractWavSampleWriter(File aFile) throws FileNotFoundException {
        this(new FileOutputStream(aFile));
        this._file = aFile;
    }

    public AbstractWavSampleWriter(OutputStream aOutputStream) {
        this._outputStream = aOutputStream instanceof BufferedOutputStream ? (BufferedOutputStream)aOutputStream : new BufferedOutputStream(aOutputStream);
    }

    @Override
    public void setBitsPerSample(BitsPerSample aBitsPerSample) {
        this._bitsPerSample = aBitsPerSample;
    }

    @Override
    public BitsPerSample getBitsPerSample() {
        return this._bitsPerSample;
    }

    @Override
    public void close() throws IOException {
        this._outputStream.flush();
        this._outputStream.close();
        if (this._file != null) {
            long size = this._file.length();
            try (RandomAccessFile theRndFile = new RandomAccessFile(this._file, "rw");){
                theRndFile.seek(4L);
                byte[] theSizeAfter = NumericalUtility.toLittleEndianBytes((long)(size - 8L), (int)4);
                theRndFile.write(theSizeAfter);
                theRndFile.seek(40L);
                theSizeAfter = NumericalUtility.toLittleEndianBytes((long)(size - 28L), (int)4);
                theRndFile.write(theSizeAfter);
            }
        }
    }

    protected long toWavSample(double eSampleData) {
        switch (this._bitsPerSample) {
            case HIGH_RES: {
                return (long)(eSampleData * 32767.0);
            }
            case LOW_RES: {
                return (long)((eSampleData + 1.0) * 127.0);
            }
        }
        throw new BugException("Missing case statement for <" + this._bitsPerSample + "> in implementation!");
    }

    protected void writeHeader(int aSamplingRate, int aChannelNumber) throws IOException {
        this._outputStream.write(RIFF.getBytes(StandardCharsets.US_ASCII));
        this._outputStream.write(NumericalUtility.toLittleEndianBytes((long)0L, (int)4));
        this._outputStream.write(WAVE.getBytes(StandardCharsets.US_ASCII));
        this._outputStream.write(FORMAT.getBytes(StandardCharsets.US_ASCII));
        this._outputStream.write(NumericalUtility.toLittleEndianBytes((long)16L, (int)4));
        this._outputStream.write(NumericalUtility.toLittleEndianBytes((long)1L, (int)2));
        this._outputStream.write(NumericalUtility.toLittleEndianBytes((long)aChannelNumber, (int)2));
        this._outputStream.write(NumericalUtility.toLittleEndianBytes((long)aSamplingRate, (int)4));
        this._outputStream.write(NumericalUtility.toLittleEndianBytes((long)(aSamplingRate * aChannelNumber * this._bitsPerSample.getByteCount()), (int)4));
        this._outputStream.write(NumericalUtility.toLittleEndianBytes((long)(this._bitsPerSample.getByteCount() * aChannelNumber), (int)2));
        this._outputStream.write(NumericalUtility.toLittleEndianBytes((long)(this._bitsPerSample.getBitCount() * aChannelNumber), (int)2));
        this._outputStream.write(DATA.getBytes(StandardCharsets.US_ASCII));
        this._outputStream.write(NumericalUtility.toLittleEndianBytes((long)0L, (int)4));
    }
}

