/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

public enum BitsPerSample {
    LOW_RES(8),
    HIGH_RES(16);

    private int _bitsPerSample;

    private BitsPerSample(int aResolution) {
        this._bitsPerSample = aResolution;
    }

    public int getBitCount() {
        return this._bitsPerSample;
    }

    public int getByteCount() {
        return this._bitsPerSample / 8;
    }

    public static BitsPerSample getLowestResolution() {
        return LOW_RES;
    }

    public static BitsPerSample getHigestResolution() {
        return HIGH_RES;
    }

    public BitsPerSample getNextHigherResolution() {
        return BitsPerSample.toNextHigherResolution(this);
    }

    public BitsPerSample getPreviousLowerResolution() {
        return BitsPerSample.toPreviousLowerResolution(this);
    }

    private static BitsPerSample toNextHigherResolution(BitsPerSample aResolution) {
        for (int i = 0; i < BitsPerSample.values().length - 1; ++i) {
            if (aResolution != BitsPerSample.values()[i]) continue;
            return BitsPerSample.values()[i + 1];
        }
        return null;
    }

    private static BitsPerSample toPreviousLowerResolution(BitsPerSample aResolution) {
        for (int i = 1; i < BitsPerSample.values().length; ++i) {
            if (aResolution != BitsPerSample.values()[i]) continue;
            return BitsPerSample.values()[i - 1];
        }
        return null;
    }
}

