/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import org.refcodes.audio.AbstractCsvSampleWriter;
import org.refcodes.audio.CsvDeltaMode;
import org.refcodes.audio.SamplingRate;
import org.refcodes.audio.SoundSample;
import org.refcodes.audio.SoundSampleBuilder;
import org.refcodes.audio.SoundSampleBuilderImpl;
import org.refcodes.audio.SoundSampleWriter;

public class CsvSoundSampleWriter
extends AbstractCsvSampleWriter<SoundSample, CsvSoundSampleWriter>
implements SoundSampleWriter<CsvSoundSampleWriter> {
    private SoundSampleBuilder _soundSample = new SoundSampleBuilderImpl(0L, SamplingRate.AUDIO_CD.getSamplesPerSecond());
    private boolean _hasHeader = false;
    private boolean[] _isSampleDataDirty;
    private boolean _isSamplingRateDirty = true;

    public CsvSoundSampleWriter(File aFile) throws FileNotFoundException {
        super(aFile);
    }

    public CsvSoundSampleWriter(OutputStream aOutputStream) {
        super(aOutputStream);
    }

    public CsvSoundSampleWriter(PrintStream aPrintStream) {
        super(aPrintStream);
    }

    public CsvSoundSampleWriter(File aFile, CsvDeltaMode aDeltaMode) throws FileNotFoundException {
        super(aFile, aDeltaMode);
    }

    public CsvSoundSampleWriter(OutputStream aOutputStream, CsvDeltaMode aDeltaMode) {
        super(aOutputStream, aDeltaMode);
    }

    public CsvSoundSampleWriter(PrintStream aPrintStream, CsvDeltaMode aDeltaMode) {
        super(aPrintStream, aDeltaMode);
    }

    @Override
    public void writeNext(double ... aSampleData) {
        if (aSampleData == null || aSampleData.length == 0) {
            throw new IllegalArgumentException("You must provide at least one sample value, bit you provided " + (aSampleData == null ? "<null>" : " an empty array") + "!");
        }
        this.doUpdateSampleData(aSampleData);
        this._soundSample.updateTimeStamp();
        this.writeNext(this._soundSample);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeNext(SoundSample aSample) {
        double[] theSample = aSample.getSampleData();
        Object[] theRow = new String[theSample.length + 3];
        if (!this._hasHeader) {
            CsvSoundSampleWriter csvSoundSampleWriter = this;
            synchronized (csvSoundSampleWriter) {
                if (!this._hasHeader) {
                    theRow[0] = "index";
                    theRow[1] = "time_stamp";
                    if (theSample.length > 1) {
                        for (int i = 0; i < theSample.length; ++i) {
                            theRow[i + 2] = "channel_" + i;
                        }
                    } else {
                        theRow[2] = "sample_data";
                    }
                    theRow[theRow.length - 1] = "sampling_rate";
                    this._csvWriter.writeHeader((String[])theRow);
                    this._hasHeader = true;
                }
            }
        }
        if (aSample != this._soundSample) {
            this.doUpdateSampleData(aSample.getSampleData());
            if (aSample.getSamplingRate() != -1 && aSample.getSamplingRate() != this._soundSample.getSamplingRate()) {
                this._soundSample.setSamplingRate(aSample.getSamplingRate());
                this._isSamplingRateDirty = true;
            }
            if (aSample.getIndex() != -1L) {
                this._soundSample.setIndex(aSample.getIndex());
            }
            if (aSample.getTimeStamp() != -1.0) {
                this._soundSample.setTimeStamp(aSample.getTimeStamp());
            }
        }
        theRow[0] = Long.toString(this._soundSample.getIndex());
        theRow[1] = CsvSoundSampleWriter.toString(this._soundSample.getTimeStamp());
        for (int i = 0; i < theSample.length; ++i) {
            if (this._deltaMode.isSampleDataDelta() && !this._isSampleDataDirty[i]) continue;
            theRow[i + 2] = CsvSoundSampleWriter.toString(theSample[i]);
        }
        if (!this._deltaMode.isSamplingRateDelta() || this._isSamplingRateDirty) {
            theRow[theRow.length - 1] = Integer.toString(this._soundSample.getSamplingRate());
        }
        this._csvWriter.writeNext(theRow);
        this._soundSample.increaseIndex();
        Arrays.fill(this._isSampleDataDirty, false);
        this._isSamplingRateDirty = false;
    }

    @Override
    public int getSamplingRate() {
        return this._soundSample.getSamplingRate();
    }

    @Override
    public void setSamplingRate(int aSamplingRate) {
        if (aSamplingRate != -1 && aSamplingRate != this._soundSample.getSamplingRate()) {
            this._soundSample.setSamplingRate(aSamplingRate);
            this._isSamplingRateDirty = true;
        }
    }

    @Override
    public CsvSoundSampleWriter withSamplingRate(int aSamplingRate) {
        this.setSamplingRate(aSamplingRate);
        return this;
    }

    private void doUpdateSampleData(double ... aSampleData) {
        if (this._isSampleDataDirty == null) {
            this._isSampleDataDirty = new boolean[aSampleData.length];
            Arrays.fill(this._isSampleDataDirty, true);
        }
        double[] theSampleData = this._soundSample.getSampleData();
        for (int i = 0; i < aSampleData.length; ++i) {
            if (theSampleData != null && theSampleData[i] == aSampleData[i]) continue;
            this._isSampleDataDirty[i] = true;
        }
        this._soundSample.setSampleData(aSampleData);
    }
}

