/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.io.IOException;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.refcodes.audio.AbstractLineOutSampleWriter;
import org.refcodes.audio.BitsPerSample;
import org.refcodes.audio.LineOutSampleWriter;
import org.refcodes.audio.SamplingRate;
import org.refcodes.audio.SoundSample;
import org.refcodes.audio.SoundSampleBuilder;
import org.refcodes.audio.SoundSampleBuilderImpl;
import org.refcodes.audio.SoundSampleWriter;
import org.refcodes.numerical.NumericalUtility;

public class LineOutSoundSampleWriter
extends AbstractLineOutSampleWriter<SoundSample, LineOutSoundSampleWriter>
implements LineOutSampleWriter<SoundSample, LineOutSoundSampleWriter>,
SoundSampleWriter<LineOutSoundSampleWriter> {
    private SoundSampleBuilder _soundSample = new SoundSampleBuilderImpl(0L, SamplingRate.AUDIO_CD.getSamplesPerSecond());
    private SourceDataLine _lineOut = null;

    @Override
    public LineOutSoundSampleWriter withBitsPerSample(BitsPerSample aBitsPerSample) {
        this.setBitsPerSample(aBitsPerSample);
        return this;
    }

    @Override
    public void writeNext(double ... aSampleData) throws IOException {
        if (aSampleData == null || aSampleData.length == 0) {
            throw new IllegalArgumentException("You must provide at least one sample value, bit you provided " + (aSampleData == null ? "<null>" : " an empty array") + "!");
        }
        this._soundSample.setSampleData(aSampleData);
        this._soundSample.updateTimeStamp();
        this.writeNext(this._soundSample);
    }

    @Override
    public void writeNext(SoundSample aSample) throws IOException {
        if (aSample != this._soundSample) {
            if (aSample.getIndex() != -1L) {
                this._soundSample.setIndex(aSample.getIndex());
            }
            if (aSample.getSamplingRate() != -1) {
                this._soundSample.setSamplingRate(aSample.getSamplingRate());
            }
            if (aSample.getTimeStamp() != -1.0) {
                this._soundSample.setTimeStamp(aSample.getTimeStamp());
            } else {
                this._soundSample.updateTimeStamp();
            }
            this._soundSample.setSampleData(aSample.getSampleData());
        }
        for (int i = 0; i < this._soundSample.getChannelCount(); ++i) {
            long eValue = this.toWavSample(this._soundSample.getSampleData()[i]);
            byte[] eBytes = NumericalUtility.toBigEndianBytes((long)eValue, (int)this._bitsPerSample.getByteCount());
            try {
                SourceDataLine theLineOut = this.getLineOut();
                while (theLineOut.getBufferSize() < eBytes.length) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                theLineOut.write(eBytes, 0, eBytes.length);
                continue;
            }
            catch (LineUnavailableException e) {
                throw new IOException("The audio-out line is unavailable: " + e.getMessage(), e);
            }
        }
        this._soundSample.increaseIndex();
    }

    @Override
    public int getSamplingRate() {
        return this._soundSample.getSamplingRate();
    }

    @Override
    public void setSamplingRate(int aSamplingRate) {
        if (aSamplingRate != -1 && aSamplingRate != this._soundSample.getSamplingRate()) {
            this._soundSample.setSamplingRate(aSamplingRate);
        }
    }

    @Override
    public LineOutSoundSampleWriter withSamplingRate(int aSamplingRate) {
        this.setSamplingRate(aSamplingRate);
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this._lineOut != null) {
            this._lineOut.stop();
            this._lineOut.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SourceDataLine getLineOut() throws LineUnavailableException {
        if (this._lineOut == null) {
            LineOutSoundSampleWriter lineOutSoundSampleWriter = this;
            synchronized (lineOutSoundSampleWriter) {
                if (this._lineOut == null) {
                    this._lineOut = LineOutSoundSampleWriter.toLineOut(this._soundSample, this._bitsPerSample);
                }
            }
        }
        return this._lineOut;
    }
}

